/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;

public class HtmlBrowserComponent
extends CloneableTopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 2912844785502987960L;
    private HtmlBrowser browserComponent;
    private HtmlBrowser.Factory browserFactory;
    private String urlToLoad;
    private boolean enableHome = true;
    private boolean enableLocation = true;
    private boolean statusVisible = false;
    private boolean toolbarVisible = true;

    public HtmlBrowserComponent() {
        this(true, false);
    }

    public HtmlBrowserComponent(boolean bl, boolean bl2) {
        this(IDESettings.getWWWBrowser(), bl, bl2);
    }

    private HtmlBrowserComponent(boolean bl, boolean bl2, URL uRL) {
        this(IDESettings.getWWWBrowser(), bl, bl2);
        this.urlToLoad = null == uRL ? null : uRL.toExternalForm();
    }

    public HtmlBrowserComponent(HtmlBrowser.Factory factory, boolean bl, boolean bl2) {
        this.setName("");
        this.setLayout(new BorderLayout());
        this.browserFactory = factory;
        this.setToolTipText(NbBundle.getBundle(HtmlBrowser.class).getString("HINT_WebBrowser"));
        this.setName(NbBundle.getMessage(HtmlBrowserComponent.class, (String)"Title_WebBrowser"));
        this.setDisplayName(NbBundle.getMessage(HtmlBrowserComponent.class, (String)"Title_WebBrowser"));
    }

    public int getPersistenceType() {
        return 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("statusMessage".equals(propertyChangeEvent.getPropertyName())) {
            StatusDisplayer.getDefault().setStatusText(this.browserComponent.getBrowserImpl().getStatusMessage());
            return;
        }
        if ("title".equals(propertyChangeEvent.getPropertyName())) {
            String string = this.browserComponent.getBrowserImpl().getTitle();
            if (string == null || string.length() < 1) {
                return;
            }
            this.setToolTipText(string);
        }
    }

    public void open() {
        if (null != this.browserComponent && this.browserComponent.getBrowserComponent() == null) {
            return;
        }
        super.open();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new BrowserReplacer(this);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.setStatusLineVisible(objectInput.readBoolean());
        this.setToolbarVisible(objectInput.readBoolean());
        this.browserComponent.setURL((URL)objectInput.readObject());
    }

    protected CloneableTopComponent createClonedObject() {
        HtmlBrowserComponent htmlBrowserComponent = new HtmlBrowserComponent(this.browserFactory, this.isToolbarVisible(), this.isStatusLineVisible());
        htmlBrowserComponent.setURL(this.getDocumentURL());
        return htmlBrowserComponent;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HtmlBrowserComponent.class);
    }

    protected void componentActivated() {
        Component component;
        HtmlBrowser.Impl impl;
        if (null == this.browserComponent) {
            this.browserComponent = new HtmlBrowser(this.browserFactory, this.toolbarVisible, this.statusVisible);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
            if (this.browserComponent.getBrowserComponent() != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
        }
        if (null != this.browserComponent && null != (impl = this.browserComponent.getBrowserImpl()) && null != (component = impl.getComponent())) {
            component.requestFocusInWindow();
        }
        super.componentActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HtmlBrowserComponent.this.setEnableHome(HtmlBrowserComponent.this.enableHome);
                HtmlBrowserComponent.this.setEnableLocation(HtmlBrowserComponent.this.enableLocation);
                HtmlBrowserComponent.this.setToolbarVisible(HtmlBrowserComponent.this.toolbarVisible);
                HtmlBrowserComponent.this.setStatusLineVisible(HtmlBrowserComponent.this.statusVisible);
                if (null != HtmlBrowserComponent.this.urlToLoad) {
                    HtmlBrowserComponent.this.setURL(HtmlBrowserComponent.this.urlToLoad);
                }
                HtmlBrowserComponent.this.urlToLoad = null;
            }
        });
    }

    protected void componentClosed() {
        if (null != this.browserComponent) {
            this.toolbarVisible = this.isToolbarVisible();
            this.statusVisible = this.isStatusLineVisible();
            URL uRL = this.browserComponent.getBrowserImpl().getURL();
            this.urlToLoad = null == uRL ? null : uRL.toExternalForm();
            this.browserComponent.getBrowserImpl().removePropertyChangeListener((PropertyChangeListener)this);
            this.browserComponent.getBrowserImpl().dispose();
        }
        this.removeAll();
        this.browserComponent = null;
    }

    protected void componentOpened() {
    }

    public Image getIcon() {
        return new ImageIcon(HtmlBrowser.class.getResource("/org/openide/resources/html/htmlView.gif")).getImage();
    }

    public void setURL(String string) {
        if (null == this.browserComponent) {
            this.urlToLoad = string;
            return;
        }
        this.browserComponent.setURL(string);
    }

    public void setURL(URL uRL) {
        if (null == this.browserComponent) {
            this.urlToLoad = null == uRL ? null : uRL.toExternalForm();
            return;
        }
        this.browserComponent.setURL(uRL);
    }

    public final URL getDocumentURL() {
        if (null == this.browserComponent) {
            URL uRL = null;
            if (null != this.urlToLoad) {
                try {
                    uRL = new URL(this.urlToLoad);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return uRL;
        }
        return this.browserComponent.getDocumentURL();
    }

    public final void setEnableHome(boolean bl) {
        if (null == this.browserComponent) {
            this.enableHome = bl;
            return;
        }
        this.browserComponent.setEnableHome(bl);
    }

    public final void setEnableLocation(boolean bl) {
        if (null == this.browserComponent) {
            this.enableLocation = bl;
            return;
        }
        this.browserComponent.setEnableLocation(bl);
    }

    public boolean isStatusLineVisible() {
        if (null == this.browserComponent) {
            return this.statusVisible;
        }
        return this.browserComponent.isStatusLineVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        if (null == this.browserComponent) {
            this.statusVisible = bl;
            return;
        }
        this.browserComponent.setStatusLineVisible(bl);
    }

    public boolean isToolbarVisible() {
        if (null == this.browserComponent) {
            return this.toolbarVisible;
        }
        return this.browserComponent.isToolbarVisible();
    }

    public void setToolbarVisible(boolean bl) {
        if (null == this.browserComponent) {
            this.toolbarVisible = bl;
            return;
        }
        this.browserComponent.setToolbarVisible(bl);
    }

    protected String preferredID() {
        return "HtmlBrowserComponent";
    }

    void setURLAndOpen(URL uRL) {
        if (null == this.browserComponent) {
            this.browserComponent = new HtmlBrowser(this.browserFactory, this.toolbarVisible, this.statusVisible);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
            if (this.browserComponent.getBrowserComponent() != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
        }
        this.browserComponent.setURL(uRL);
        if (null != this.browserComponent.getBrowserComponent()) {
            this.open();
            this.requestActive();
        }
    }

    public static final class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient HtmlBrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(HtmlBrowserComponent htmlBrowserComponent) {
            this.bComp = htmlBrowserComponent;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeBoolean(this.bComp.isStatusLineVisible());
            objectOutput.writeBoolean(this.bComp.isToolbarVisible());
            objectOutput.writeObject(this.bComp.getDocumentURL());
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.statLine = objectInput.readBoolean();
            this.toolbar = objectInput.readBoolean();
            this.url = (URL)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if ("http".equals(this.url.getProtocol()) && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {
                return null;
            }
            catch (Exception exception) {
                Logger.getLogger(HtmlBrowserComponent.class.getName()).log(Level.WARNING, null, exception);
            }
            this.bComp = new HtmlBrowserComponent(this.statLine, this.toolbar, this.url);
            return this.bComp;
        }
    }
}

