/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.SecuritySupport;

public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";
    private static SecuritySupport ss = new SecuritySupport();
    private static boolean _jarread = false;

    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        String className = null;
        ClassLoader cl = ss.getContextClassLoader();
        try {
            className = ss.getSystemProperty(property);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (className == null && !_jarread) {
            _jarread = true;
            String service = "META-INF/services/org.xml.sax.driver";
            try {
                InputStream in;
                if (cl != null) {
                    in = ss.getResourceAsStream(cl, service);
                    if (in == null) {
                        cl = null;
                        in = ss.getResourceAsStream(cl, service);
                    }
                } else {
                    in = ss.getResourceAsStream(cl, service);
                }
                if (in != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                    className = reader.readLine();
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (className == null) {
            className = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        }
        if (className != null) {
            return XMLReaderFactory.loadClass(cl, className);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception e) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String className) throws SAXException {
        return XMLReaderFactory.loadClass(ss.getContextClassLoader(), className);
    }

    private static XMLReader loadClass(ClassLoader loader, String className) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(loader, className);
        }
        catch (ClassNotFoundException e1) {
            throw new SAXException("SAX2 driver class " + className + " not found", e1);
        }
        catch (IllegalAccessException e2) {
            throw new SAXException("SAX2 driver class " + className + " found but cannot be loaded", e2);
        }
        catch (InstantiationException e3) {
            throw new SAXException("SAX2 driver class " + className + " loaded but cannot be instantiated (no empty public constructor?)", e3);
        }
        catch (ClassCastException e4) {
            throw new SAXException("SAX2 driver class " + className + " does not implement XMLReader", e4);
        }
    }
}

