/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private static final boolean eagerHttpFallback = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.transport.proxy.eagerHttpFallback"));
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    private static long getConnectTimeout() {
        return AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean bl = false;
        try {
            Boolean bl2;
            String string = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl2 = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && string != null && string.length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String string, int n) throws IOException {
        Object object;
        IOException iOException;
        AsyncConnector asyncConnector;
        Socket socket;
        Socket socket2;
        RMISocketFactory rMISocketFactory;
        block59: {
            if (proxyLog.isLoggable(Log.BRIEF)) {
                proxyLog.log(Log.BRIEF, "host: " + string + ", port: " + n);
            }
            if (this.altFactoryList.size() == 0) {
                return this.initialFactory.createSocket(string, n);
            }
            rMISocketFactory = (RMISocketFactory)this.successTable.get(string);
            if (rMISocketFactory != null) {
                if (proxyLog.isLoggable(Log.BRIEF)) {
                    proxyLog.log(Log.BRIEF, "previously successful factory found: " + rMISocketFactory);
                }
                return rMISocketFactory.createSocket(string, n);
            }
            socket2 = null;
            socket = null;
            asyncConnector = new AsyncConnector(this.initialFactory, string, n, AccessController.getContext());
            iOException = null;
            try {
                Object object2 = asyncConnector;
                synchronized (object2) {
                    Thread thread = AccessController.doPrivileged(new NewThreadAction(asyncConnector, "AsyncConnector", true));
                    thread.start();
                    try {
                        long l = System.currentTimeMillis();
                        long l2 = l + connectTimeout;
                        do {
                            asyncConnector.wait(l2 - l);
                        } while ((socket2 = this.checkConnector(asyncConnector)) == null && (l = System.currentTimeMillis()) < l2);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException("interrupted while waiting for connector");
                    }
                }
                if (socket2 == null) {
                    throw new NoRouteToHostException("connect timed out: " + string);
                }
                proxyLog.log(Log.BRIEF, "direct socket connection successful");
                object2 = socket2;
                return object2;
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                iOException = noRouteToHostException;
            }
            catch (SocketException socketException) {
                if (eagerHttpFallback) {
                    iOException = socketException;
                    break block59;
                }
                throw socketException;
            }
            finally {
                if (iOException != null) {
                    if (proxyLog.isLoggable(Log.BRIEF)) {
                        proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                    }
                    for (int i = 0; i < this.altFactoryList.size(); ++i) {
                        rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(i);
                        try {
                            if (proxyLog.isLoggable(Log.BRIEF)) {
                                proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                            }
                            object = rMISocketFactory.createSocket(string, n);
                            InputStream inputStream = ((Socket)object).getInputStream();
                            int n2 = inputStream.read();
                            ((Socket)object).close();
                        }
                        catch (IOException iOException2) {
                            if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                            proxyLog.log(Log.BRIEF, "factory failed: ", iOException2);
                            continue;
                        }
                        proxyLog.log(Log.BRIEF, "factory succeeded");
                        try {
                            socket = rMISocketFactory.createSocket(string, n);
                        }
                        catch (IOException iOException3) {}
                        break;
                    }
                }
            }
        }
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            try {
                object = asyncConnector;
                synchronized (object) {
                    socket2 = this.checkConnector(asyncConnector);
                }
                if (socket2 != null) {
                    if (socket != null) {
                        socket.close();
                    }
                    return socket2;
                }
                asyncConnector.notUsed();
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                iOException = noRouteToHostException;
            }
            catch (SocketException socketException) {
                if (eagerHttpFallback) {
                    iOException = socketException;
                }
                throw socketException;
            }
            if (socket != null) {
                this.rememberFactory(string, rMISocketFactory);
                return socket;
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = asyncConnector.getException();
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return asyncConnector.getSocket();
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return this.initialFactory.createServerSocket(n);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory rMISocketFactory, String string, int n, AccessControlContext accessControlContext) {
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket socket = this.factory.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = socket;
                    this.notify();
                }
                RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = exception;
                    this.notify();
                }
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

