/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, 0, string2);
    }

    public SignedInfo(Document document, String string, int n, String string2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", string2);
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this._doc, string, n) : new SignatureAlgorithm(this._doc, string);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document document, Element element, Element element2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = element2;
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(element, null);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        this.c14nMethod = XMLUtils.getNextElement(element.getFirstChild());
        String string2 = this.getCanonicalizationMethodURI();
        if (!(string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
            try {
                Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
                this._c14nizedBytes = canonicalizer.canonicalizeSubtree(this._constructionElement);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(this._c14nizedBytes));
                Node node = this._doc.importNode(document.getDocumentElement(), true);
                this._constructionElement.getParentNode().replaceChild(node, this._constructionElement);
                this._constructionElement = (Element)node;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLSecurityException("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new XMLSecurityException("empty", iOException);
            }
            catch (SAXException sAXException) {
                throw new XMLSecurityException("empty", sAXException);
            }
        }
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        this._signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        Object object;
        if (this._c14nizedBytes == null) {
            object = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = ((Canonicalizer)object).canonicalizeSubtree(this._constructionElement);
        }
        object = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, object, 0, ((Object)object).length);
        return object;
    }

    public void signInOctectStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setWriter(outputStream);
            String string = this.getInclusiveNamespaces();
            if (string == null) {
                canonicalizer.canonicalizeSubtree(this._constructionElement);
            } else {
                canonicalizer.canonicalizeSubtree(this._constructionElement, string);
            }
        } else {
            try {
                outputStream.write(this._c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException("" + iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    @Override
    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String string = this.c14nMethod.getAttributeNS(null, "Algorithm");
        if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            return null;
        }
        Element element = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (element != null) {
            try {
                String string2 = new InclusiveNamespaces(element, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return string2;
            }
            catch (XMLSecurityException xMLSecurityException) {
                return null;
            }
        }
        return null;
    }
}

