/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.util.WeakSet;

public final class MutualExclusionSupport<K> {
    private final Map<K, Set<Closeable>> exclusive = Collections.synchronizedMap(new WeakHashMap());
    private final Map<K, Set<Closeable>> shared = Collections.synchronizedMap(new WeakHashMap());

    public synchronized Closeable addResource(K k, boolean bl) throws IOException {
        boolean bl2 = true;
        Map<K, Set<Closeable>> map = bl ? this.exclusive : this.shared;
        Map<K, Set<Closeable>> map2 = bl ? this.shared : this.exclusive;
        Set<Closeable> set = map.get(k);
        WeakSet weakSet = map2.get(k);
        for (int i = 0; i < 10 && bl2; ++i) {
            boolean bl3 = bl2 = set != null && set.size() > 0;
            if (!bl2) {
                if (weakSet == null) {
                    weakSet = new WeakSet();
                    map2.put(k, (Set<Closeable>)weakSet);
                }
                boolean bl4 = bl2 = !bl && weakSet.size() > 0;
            }
            if (!bl2) continue;
            try {
                this.wait(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (bl2) {
            try {
                FSException.io(bl ? "EXC_CannotGetSharedAccess" : "EXC_CannotGetExclusiveAccess", k.toString());
            }
            catch (IOException iOException) {
                assert (this.addStack(iOException, set, (Set<Closeable>)weakSet));
                throw iOException;
            }
        }
        Closeable closeable = new Closeable(k, bl);
        weakSet.add((Closeable)closeable);
        return closeable;
    }

    private boolean addStack(IOException iOException, Set<Closeable> set, Set<Closeable> set2) {
        this.addStack(iOException, set);
        this.addStack(iOException, set2);
        return true;
    }

    private void addStack(IOException iOException, Set<Closeable> set) {
        if (set != null) {
            for (Closeable closeable : set) {
                Throwable throwable = closeable.stack;
                if (throwable == null) continue;
                Throwable throwable2 = iOException;
                while (throwable2.getCause() != null) {
                    throwable2 = throwable2.getCause();
                }
                throwable2.initCause(throwable);
            }
        }
    }

    private synchronized void removeResource(K k, Closeable closeable, boolean bl) {
        Map<K, Set<Closeable>> map = bl ? this.shared : this.exclusive;
        Set<Closeable> set = map.get(k);
        if (set != null) {
            set.remove(closeable);
        }
    }

    synchronized boolean isBeingWritten(K k) {
        Set<Closeable> set = this.exclusive.get(k);
        return set != null && !set.isEmpty();
    }

    public final class Closeable {
        private final boolean isShared;
        private final Reference<K> keyRef;
        private boolean isClosed = false;
        Throwable stack;

        private Closeable(K k, boolean bl) {
            this.isShared = bl;
            this.keyRef = new WeakReference(k);
            assert (this.populateStack());
        }

        private boolean populateStack() {
            this.stack = new Throwable("opened stream here");
            return true;
        }

        public void close() {
            if (!this.isClosed()) {
                this.isClosed = true;
                Object k = this.keyRef.get();
                if (k != null) {
                    MutualExclusionSupport.this.removeResource(k, this, this.isShared);
                }
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

