/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RefreshSlow;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

public final class FileObjectFactory {
    public static final Map<File, FileObjectFactory> AllFactories = new HashMap<File, FileObjectFactory>();
    public static boolean WARNINGS = true;
    final Map<Integer, Object> allIBaseFileObjects = Collections.synchronizedMap(new WeakHashMap());
    private BaseFileObj root;
    private static final Logger LOG_REFRESH = Logger.getLogger("org.netbeans.modules.masterfs.REFRESH");

    private FileObjectFactory(File file) {
        this(new FileInfo(file));
    }

    private FileObjectFactory(FileInfo fileInfo) {
        BaseFileObj baseFileObj;
        this.root = baseFileObj = this.create(fileInfo);
    }

    public static FileObjectFactory getInstance(File file) {
        return FileObjectFactory.getInstance(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObjectFactory getInstance(File file, boolean bl) {
        FileObjectFactory fileObjectFactory = null;
        FileInfo fileInfo = new FileInfo(file).getRoot();
        File file2 = fileInfo.getFile();
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            fileObjectFactory = AllFactories.get(file2);
        }
        if (fileObjectFactory == null && bl && fileInfo.isConvertibleToFileObject()) {
            map = AllFactories;
            synchronized (map) {
                fileObjectFactory = AllFactories.get(file2);
                if (fileObjectFactory == null) {
                    fileObjectFactory = new FileObjectFactory(file2);
                    AllFactories.put(file2, fileObjectFactory);
                }
            }
        }
        return fileObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileObjectFactory> getInstances() {
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            return new ArrayList<FileObjectFactory>(AllFactories.values());
        }
    }

    public final BaseFileObj getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFactoriesSize() {
        Map<File, FileObjectFactory> map = AllFactories;
        synchronized (map) {
            return AllFactories.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        object = new ArrayList();
        for (Object object2 : arrayList) {
            if (object2 instanceof Reference) {
                object.add(object2);
                continue;
            }
            object.addAll((List)object2);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            FileObject fileObject = reference != null ? (FileObject)reference.get() : null;
            if (fileObject == null) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFileObj getFileObject(FileInfo fileInfo, Caller caller) {
        int n;
        File file = fileInfo.getFile();
        FolderObj folderObj = BaseFileObj.getExistingParentFor(file, this);
        FileNaming fileNaming = null;
        boolean bl = true;
        if (folderObj != null) {
            ChildrenCache childrenCache = folderObj.getChildrenCache();
            Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
            privileged.enterReadAccess();
            try {
                String string = BaseFileObj.getNameExt(file);
                bl = childrenCache.isCacheInitialized();
                fileNaming = childrenCache.getChild(string, false);
            }
            finally {
                privileged.exitReadAccess();
            }
        }
        int n2 = bl ? -1 : (n = fileNaming != null ? 1 : 0);
        if (n == -1 && FileBasedFileSystem.isModificationInProgress()) {
            n = file.exists() ? 1 : 0;
        }
        return this.issueIfExist(file, caller, folderObj, fileNaming, n, !caller.equals((Object)Caller.Others));
    }

    private boolean checkCacheState(boolean bl, File file, Caller caller) {
        if (!bl && (caller.equals((Object)Caller.GetParent) || caller.equals((Object)Caller.ToFileObject))) {
            return true;
        }
        if (this.isWarningEnabled() && caller != null && !caller.equals((Object)Caller.GetChildern)) {
            boolean bl2;
            boolean bl3 = file.exists();
            boolean bl4 = bl2 = bl != bl3;
            if (bl2) {
                File[] fileArray;
                File file2;
                if (!bl3 && (file2 = file.getParentFile()) != null && (fileArray = file2.listFiles()) != null && Arrays.asList(fileArray).contains(file)) {
                    return true;
                }
                this.printWarning(file);
            }
        }
        return true;
    }

    private Integer initRealExists(int n) {
        Integer n2 = new Integer(n);
        return n2;
    }

    private void printWarning(File file) {
        StringBuilder stringBuilder = new StringBuilder("WARNING(please REPORT):  Externally ");
        stringBuilder.append(file.exists() ? "created " : "deleted ");
        stringBuilder.append(file.isDirectory() ? "folder: " : "file: ");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append(" (Possibly not refreshed FileObjects when external command finished.");
        stringBuilder.append(" For additional information see: http://wiki.netbeans.org/wiki/view/FileSystems)");
        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, illegalStateException.getMessage(), illegalStateException);
    }

    private BaseFileObj issueIfExist(File file, Caller caller, FileObject fileObject, FileNaming fileNaming, int n, boolean bl) {
        boolean bl2 = false;
        BaseFileObj baseFileObj = null;
        Integer n2 = this.initRealExists(n);
        FileChangedManager fileChangedManager = FileChangedManager.getInstance();
        baseFileObj = this.getCachedOnly(file);
        if (fileObject != null && fileObject.isValid()) {
            if (fileNaming != null) {
                if (baseFileObj == null) {
                    boolean bl3 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(true, file, caller));
                } else if (baseFileObj.isValid()) {
                    boolean bl4 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                    if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                } else {
                    bl2 = FileObjectFactory.touchExists(file, n2);
                    if (!bl2) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                }
            } else if (baseFileObj == null) {
                boolean bl5 = bl2 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl2) && bl2 != FileObjectFactory.touchExists(file, n2)) {
                    bl2 = !bl2;
                    this.refreshFromGetter(fileObject, bl);
                }
                assert (this.checkCacheState(bl2, file, caller));
            } else if (baseFileObj.isValid()) {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (!bl2) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            } else {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (bl2) {
                    this.refreshFromGetter(fileObject, bl);
                }
            }
        } else if (baseFileObj == null) {
            bl2 = caller == Caller.GetParent ? true : FileObjectFactory.touchExists(file, n2);
        } else if (baseFileObj.isValid()) {
            if (fileObject == null) {
                boolean bl6 = bl2 = n2 == -1 ? true : FileObjectFactory.touchExists(file, n2);
                if (fileChangedManager.impeachExistence(file, bl2) && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
                assert (this.checkCacheState(bl2, file, caller));
            } else {
                bl2 = FileObjectFactory.touchExists(file, n2);
                if (!bl2) {
                    this.refreshFromGetter(baseFileObj, bl);
                }
            }
        } else {
            boolean bl7 = bl2 = n2 == -1 ? false : FileObjectFactory.touchExists(file, n2);
            if (fileChangedManager.impeachExistence(file, bl2)) {
                bl2 = FileObjectFactory.touchExists(file, n2);
            }
            assert (this.checkCacheState(bl2, file, caller));
        }
        if (!bl2) {
            switch (caller) {
                case GetParent: {
                    BaseFileObj baseFileObj2 = null;
                    baseFileObj2 = baseFileObj != null && !baseFileObj.isRoot() ? baseFileObj : this.getOrCreate(new FileInfo(file, 1));
                    if (baseFileObj2 instanceof BaseFileObj && baseFileObj2.isValid() && !(bl2 = FileObjectFactory.touchExists(file, n2))) {
                        baseFileObj2.setValid(false);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                    return baseFileObj2;
                }
                case ToFileObject: {
                    bl2 = FileObjectFactory.touchExists(file, n2);
                    if (bl2 && fileObject != null && fileObject.isValid()) {
                        this.refreshFromGetter(fileObject, bl);
                    }
                    assert (this.checkCacheState(bl2, file, caller));
                    break;
                }
            }
        }
        return bl2 ? this.getOrCreate(new FileInfo(file, 1)) : null;
    }

    private static boolean touchExists(File file, Integer n) {
        if (n == -1) {
            n = FileChangedManager.getInstance().exists(file) ? 1 : 0;
        }
        assert (n != -1);
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj getOrCreate(FileInfo fileInfo) {
        Object object;
        boolean bl;
        BaseFileObj baseFileObj = null;
        File file = fileInfo.getFile();
        boolean bl2 = bl = fileInfo.isWindows() && file.getName().endsWith(".") && !file.getName().matches("[.]{1,2}");
        if (bl) {
            object = FileUtil.normalizeFile((File)file);
            boolean bl3 = bl = !((File)object).getName().endsWith(".");
            if (bl) {
                return null;
            }
        }
        object = this.allIBaseFileObjects;
        synchronized (object) {
            baseFileObj = this.getCachedOnly(file);
            if (baseFileObj == null || !baseFileObj.isValid()) {
                File file2 = file.getParentFile();
                baseFileObj = file2 != null ? this.create(fileInfo) : this.getRoot();
            }
            return baseFileObj;
        }
    }

    private BaseFileObj create(FileInfo fileInfo) {
        if (!fileInfo.isConvertibleToFileObject()) {
            return null;
        }
        File file = fileInfo.getFile();
        FileNaming fileNaming = fileInfo.getFileNaming();
        FileNaming fileNaming2 = fileNaming = fileNaming == null ? NamingFactory.fromFile(file) : fileNaming;
        if (fileNaming == null) {
            return null;
        }
        if (fileNaming.isFile() && !fileNaming.isDirectory()) {
            FileObj fileObj = new FileObj(file, fileNaming);
            return this.putInCache(fileObj, fileObj.getFileName().getId());
        }
        if (!fileNaming.isFile() && fileNaming.isDirectory()) {
            FolderObj folderObj = new FolderObj(file, fileNaming);
            return this.putInCache(folderObj, folderObj.getFileName().getId());
        }
        assert (false);
        return null;
    }

    final void refreshAll(RefreshSlow refreshSlow, boolean bl, boolean bl2) {
        Set<BaseFileObj> set = this.collectForRefresh(bl);
        this.refresh(set, refreshSlow, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BaseFileObj> collectForRefresh(boolean bl) {
        WeakSet weakSet;
        Map<Integer, Object> map = this.allIBaseFileObjects;
        synchronized (map) {
            weakSet = new WeakSet(this.allIBaseFileObjects.size() * 3 + 11);
            for (Object object : this.allIBaseFileObjects.values()) {
                Object object22;
                if (object instanceof List) {
                    for (Object object22 : (List)object) {
                        BaseFileObj baseFileObj = this.shallBeChecked(object22 != null ? (BaseFileObj)((Object)((Reference)object22).get()) : null, bl);
                        if (baseFileObj == null) continue;
                        weakSet.add(baseFileObj);
                    }
                    continue;
                }
                WeakReference weakReference = (WeakReference)object;
                object22 = this.shallBeChecked(weakReference != null ? (BaseFileObj)((Object)weakReference.get()) : null, bl);
                if (object22 == null) continue;
                weakSet.add(object22);
            }
        }
        weakSet.remove((Object)this.root);
        return weakSet;
    }

    private BaseFileObj shallBeChecked(BaseFileObj baseFileObj, boolean bl) {
        FolderObj folderObj;
        if (baseFileObj != null && bl && (folderObj = (FolderObj)(baseFileObj instanceof FolderObj ? baseFileObj : baseFileObj.getExistingParent())) != null && Watcher.isWatched(baseFileObj)) {
            LOG_REFRESH.log(Level.FINER, "skip: {0}", (Object)baseFileObj);
            baseFileObj = null;
        }
        return baseFileObj;
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, File ... fileArray) {
        return this.refresh(set, refreshSlow, true, fileArray);
    }

    private static boolean isInFiles(BaseFileObj baseFileObj, File[] fileArray) {
        if (baseFileObj == null) {
            return false;
        }
        if (fileArray == null) {
            return true;
        }
        for (File file : fileArray) {
            if (!FileObjectFactory.isParentOf(file, baseFileObj.getFileName().getFile())) continue;
            return true;
        }
        return false;
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, boolean bl) {
        return this.refresh(set, refreshSlow, bl, null);
    }

    private boolean refresh(Set<BaseFileObj> set, RefreshSlow refreshSlow, boolean bl, File[] fileArray) {
        int n = 0;
        Iterator<BaseFileObj> iterator = set.iterator();
        while (iterator.hasNext()) {
            BaseFileObj baseFileObj;
            BaseFileObj baseFileObj2 = null;
            if (refreshSlow != null && (baseFileObj = refreshSlow.preferrable()) != null && set.remove((Object)baseFileObj)) {
                LOG_REFRESH.log(Level.FINER, "Preferring {0}", (Object)baseFileObj);
                baseFileObj2 = baseFileObj;
                iterator = set.iterator();
            }
            if (baseFileObj2 == null) {
                baseFileObj2 = iterator.next();
                iterator.remove();
            }
            ++n;
            if (!FileObjectFactory.isInFiles(baseFileObj2, fileArray)) continue;
            if (refreshSlow != null) {
                if (!refreshSlow.refreshFileObject(baseFileObj2, bl, n)) {
                    return false;
                }
                n = 0;
                continue;
            }
            baseFileObj2.refresh(bl);
        }
        return true;
    }

    public static boolean isParentOf(File file, File file2) {
        File file3;
        for (file3 = file2; file3 != null && !Utils.equals(file3, file); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename(Set<BaseFileObj> set) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Map<Integer, Object> map = this.allIBaseFileObjects;
        synchronized (map) {
            Object object5;
            Object object2;
            Integer n;
            for (Map.Entry<Integer, Object> object3 : this.allIBaseFileObjects.entrySet()) {
                Object object4 = object3.getValue();
                n = object3.getKey();
                if (!(object4 instanceof List)) {
                    object2 = (WeakReference)object4;
                    object5 = object2 != null ? (BaseFileObj)((Object)((Reference)object2).get()) : null;
                    if (!set.contains(object5)) continue;
                    hashMap.put(n, object5);
                    continue;
                }
                for (Object object5 : (List)object4) {
                    BaseFileObj baseFileObj = object5 != null ? (BaseFileObj)((Object)((Reference)object5).get()) : null;
                    if (!set.contains((Object)baseFileObj)) continue;
                    hashMap.put(n, object5);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                n = (Integer)entry.getKey();
                object2 = this.allIBaseFileObjects.remove(n);
                if (object2 instanceof List) {
                    object5 = (List)object2;
                    object5.remove(entry.getValue());
                    this.allIBaseFileObjects.put(n, object2);
                    continue;
                }
                object5 = (BaseFileObj)((Object)entry.getValue());
                this.putInCache((BaseFileObj)((Object)object5), object5.getFileName().getId());
            }
        }
    }

    public final BaseFileObj getCachedOnly(File file) {
        return this.getCachedOnly(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseFileObj getCachedOnly(File file, boolean bl) {
        BaseFileObj baseFileObj;
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            Object object2 = this.allIBaseFileObjects.get(NamingFactory.createID(file));
            Reference<BaseFileObj> reference = (Reference<BaseFileObj>)(object2 instanceof Reference ? object2 : null);
            reference = reference == null && object2 instanceof List ? FileObjectFactory.getReference((List)object2, file) : reference;
            BaseFileObj baseFileObj2 = baseFileObj = reference != null ? (BaseFileObj)((Object)reference.get()) : null;
            assert (baseFileObj == null || baseFileObj instanceof BaseFileObj);
        }
        object = baseFileObj;
        if (object != null && bl && !file.getName().equals(((BaseFileObj)((Object)object)).getNameExt()) && !Utils.equals(file, ((BaseFileObj)((Object)object)).getFileName().getFile())) {
            object = null;
        }
        return object;
    }

    private static Reference<BaseFileObj> getReference(List<?> list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            BaseFileObj baseFileObj;
            Reference reference2 = (Reference)list.get(i);
            BaseFileObj baseFileObj2 = baseFileObj = reference2 != null ? (BaseFileObj)((Object)reference2.get()) : null;
            if (baseFileObj == null || baseFileObj.getFileName().getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj putInCache(BaseFileObj baseFileObj, Integer n) {
        Map<Integer, Object> map = this.allIBaseFileObjects;
        synchronized (map) {
            WeakReference<BaseFileObj> weakReference = new WeakReference<BaseFileObj>(baseFileObj);
            WeakReference<BaseFileObj> weakReference2 = this.allIBaseFileObjects.put(n, weakReference);
            if (weakReference2 != null) {
                if (weakReference2 instanceof List) {
                    List list = (List)((Object)weakReference2);
                    list.add(weakReference);
                    this.allIBaseFileObjects.put(n, weakReference2);
                } else {
                    BaseFileObj baseFileObj2;
                    assert (weakReference2 instanceof WeakReference);
                    Reference reference = weakReference2;
                    BaseFileObj baseFileObj3 = baseFileObj2 = reference != null ? (BaseFileObj)((Object)reference.get()) : null;
                    if (baseFileObj2 != null && !baseFileObj.getFileName().equals(baseFileObj2.getFileName())) {
                        ArrayList<Reference> arrayList = new ArrayList<Reference>();
                        arrayList.add(reference);
                        arrayList.add(weakReference);
                        this.allIBaseFileObjects.put(n, arrayList);
                    }
                }
            }
        }
        return baseFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.allIBaseFileObjects;
        synchronized (object) {
            arrayList.addAll(this.allIBaseFileObjects.values());
        }
        object = new ArrayList();
        for (Reference reference : arrayList) {
            FileObject fileObject = reference != null ? (FileObject)reference.get() : null;
            if (fileObject == null) continue;
            object.add(fileObject.getPath());
        }
        return object.toString();
    }

    public static synchronized Map<File, FileObjectFactory> factories() {
        return new HashMap<File, FileObjectFactory>(AllFactories);
    }

    public boolean isWarningEnabled() {
        return WARNINGS && !Utilities.isMac();
    }

    public static void reinitForTests() {
        AllFactories.clear();
    }

    public final BaseFileObj getValidFileObject(File file, Caller caller) {
        BaseFileObj baseFileObj = this.getFileObject(new FileInfo(file), caller);
        return baseFileObj != null && baseFileObj.isValid() ? baseFileObj : null;
    }

    public void refresh(boolean bl) {
        this.refresh(null, bl);
    }

    void refresh(RefreshSlow refreshSlow, boolean bl) {
        this.refresh(refreshSlow, false, bl);
    }

    final void refresh(final RefreshSlow refreshSlow, final boolean bl, final boolean bl2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileObjectFactory.this.refreshAll(refreshSlow, bl, bl2);
            }
        };
        stopWatch.start();
        try {
            if (refreshSlow != null) {
                FileBasedFileSystem.runAsInconsistent(runnable);
            } else {
                FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileBasedFileSystem.runAsInconsistent(runnable);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        if (LOG_REFRESH.isLoggable(Level.FINE)) {
            LOG_REFRESH.log(Level.FINE, "FS.refresh statistics ({0}FileObjects):\n  {1}\n  {2}\n  {3}\n  {4}\n", new Object[]{Statistics.fileObjects(), Statistics.REFRESH_FS.toString(), Statistics.LISTENERS_CALLS.toString(), Statistics.REFRESH_FOLDER.toString(), Statistics.REFRESH_FILE.toString()});
        }
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    final void refreshFor(final RefreshSlow refreshSlow, final boolean bl, final File ... fileArray) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Set set = FileObjectFactory.this.collectForRefresh(bl);
                FileObjectFactory.this.refresh((Set<BaseFileObj>)set, refreshSlow, fileArray);
                if (LOG_REFRESH.isLoggable(Level.FINER)) {
                    LOG_REFRESH.log(Level.FINER, "Refresh for {0} objects", set.size());
                    for (BaseFileObj baseFileObj : set) {
                        LOG_REFRESH.log(Level.FINER, "  {0}", (Object)baseFileObj);
                    }
                }
            }
        };
        stopWatch.start();
        try {
            if (refreshSlow != null) {
                FileBasedFileSystem.runAsInconsistent(runnable);
            } else {
                FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileBasedFileSystem.runAsInconsistent(runnable);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        if (LOG_REFRESH.isLoggable(Level.FINE)) {
            LOG_REFRESH.log(Level.FINE, "FS.refresh statistics ({0}FileObjects):\n  {1}\n  {2}\n  {3}\n  {4}\n", new Object[]{Statistics.fileObjects(), Statistics.REFRESH_FS.toString(), Statistics.LISTENERS_CALLS.toString(), Statistics.REFRESH_FOLDER.toString(), Statistics.REFRESH_FILE.toString()});
        }
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    private void refreshFromGetter(FileObject fileObject, boolean bl) {
        try {
            if (bl) {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new AsyncRefreshAtomicAction(fileObject));
            } else {
                fileObject.refresh();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static class AsyncRefreshAtomicAction
    implements FileSystem.AtomicAction {
        private FileObject fo;

        AsyncRefreshAtomicAction(FileObject fileObject) {
            this.fo = fileObject;
        }

        public void run() throws IOException {
            this.fo.refresh();
        }
    }

    public static enum Caller {
        ToFileObject,
        GetFileObject,
        GetChildern,
        GetParent,
        Others;

    }
}

