/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.view.ui.slides.ResizeGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;

final class SlideGestureRecognizer
implements ActionListener,
MouseListener,
MouseMotionListener {
    private SlideBar slideBar;
    private Component mouseInButton = null;
    private int curMouseLocX;
    private int curMouseLocY;
    private AutoSlideTrigger autoSlideTrigger = new AutoSlideTrigger();
    private ResizeGestureRecognizer resizer;
    private boolean pressingButton = false;
    private static final Logger LOG = Logger.getLogger(SlideGestureRecognizer.class.getName());

    SlideGestureRecognizer(SlideBar slideBar, ResizeGestureRecognizer resizeGestureRecognizer) {
        this.slideBar = slideBar;
        this.resizer = resizeGestureRecognizer;
    }

    public void attachButton(AbstractButton abstractButton) {
        abstractButton.addActionListener(this);
        abstractButton.addMouseListener(this);
        abstractButton.addMouseMotionListener(this);
    }

    public void detachButton(AbstractButton abstractButton) {
        abstractButton.removeActionListener(this);
        abstractButton.removeMouseListener(this);
        abstractButton.addMouseMotionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.slideBar.userClickedSlidingButton((Component)actionEvent.getSource());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.autoSlideTrigger.isEnabled()) {
            this.curMouseLocX = mouseEvent.getX();
            this.curMouseLocY = mouseEvent.getY();
        }
        if (this.pressingButton && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            this.pressingButton = false;
            this.autoSlideTrigger.activateAutoSlideInGesture();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.slideBar.isHoveringAllowed()) {
            return;
        }
        this.mouseInButton = (Component)mouseEvent.getSource();
        this.curMouseLocX = mouseEvent.getX();
        this.curMouseLocY = mouseEvent.getY();
        this.pressingButton = false;
        if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
            this.pressingButton = true;
            return;
        }
        this.autoSlideTrigger.activateAutoSlideInGesture();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseInButton = null;
        this.pressingButton = false;
        this.autoSlideTrigger.deactivateAutoSlideInGesture(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.autoSlideTrigger.deactivateAutoSlideInGesture(mouseEvent);
        this.handlePopupRequests(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.autoSlideTrigger.deactivateAutoSlideInGesture(mouseEvent);
        this.handlePopupRequests(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void handlePopupRequests(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.slideBar)) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.slideBar.userTriggeredPopup(mouseEvent, (Component)mouseEvent.getSource());
        }
    }

    private final class AutoSlideTrigger
    implements ActionListener,
    AWTEventListener {
        private Timer slideInTimer = new Timer(200, this);
        private Timer slideOutTimer;
        private int initialX;
        private int initialY;
        private boolean autoSlideActive = false;
        private Rectangle activeArea;

        AutoSlideTrigger() {
            this.slideInTimer.setRepeats(true);
            this.slideInTimer.setCoalesce(true);
        }

        public void activateAutoSlideInGesture() {
            this.initialX = SlideGestureRecognizer.this.curMouseLocX;
            this.initialY = SlideGestureRecognizer.this.curMouseLocY;
            this.slideInTimer.start();
        }

        public void deactivateAutoSlideInGesture(MouseEvent mouseEvent) {
            this.slideInTimer.stop();
            this.notifySlideOutTimer(mouseEvent);
        }

        public boolean isEnabled() {
            return this.autoSlideActive || this.slideInTimer.isRunning();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.slideInTimer.equals(actionEvent.getSource())) {
                this.slideInTimerReaction(actionEvent);
            } else {
                this.slideOutTimerReaction(actionEvent);
            }
        }

        private void slideInTimerReaction(ActionEvent actionEvent) {
            if (this.isSlideInGesture()) {
                this.slideInTimer.stop();
                if (this.autoSlideActive) {
                    this.autoSlideOut();
                }
                this.autoSlideActive = true;
                if (SlideGestureRecognizer.this.slideBar.userTriggeredAutoSlideIn(SlideGestureRecognizer.this.mouseInButton)) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
                } else {
                    this.autoSlideActive = false;
                }
            } else {
                this.initialX = SlideGestureRecognizer.this.curMouseLocX;
                this.initialY = SlideGestureRecognizer.this.curMouseLocY;
            }
        }

        private void slideOutTimerReaction(ActionEvent actionEvent) {
            LOG.fine("slideOutTimerReaction entered, trying to auto slide out");
            this.slideOutTimer.stop();
            this.autoSlideOutIfNeeded();
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            this.notifySlideOutTimer((MouseEvent)aWTEvent);
        }

        private void autoSlideOutIfNeeded() {
            if (!this.autoSlideActive) {
                return;
            }
            if (SlideGestureRecognizer.this.slideBar.isActive()) {
                this.cleanup();
                return;
            }
            this.cleanup();
            this.autoSlideOut();
        }

        private void autoSlideOut() {
            SlideGestureRecognizer.this.slideBar.userTriggeredAutoSlideOut();
        }

        private void cleanup() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.autoSlideActive = false;
            this.activeArea = null;
        }

        private boolean isSlideInGesture() {
            if (SlideGestureRecognizer.this.mouseInButton == null) {
                return false;
            }
            int n = Math.abs(this.initialX - SlideGestureRecognizer.this.curMouseLocX);
            int n2 = Math.abs(this.initialY - SlideGestureRecognizer.this.curMouseLocY);
            return n <= 2 && n2 <= 2;
        }

        private boolean isSlideOutGesture(MouseEvent mouseEvent) {
            if (SlideGestureRecognizer.this.resizer.isDragging()) {
                this.activeArea = null;
                return false;
            }
            if (this.activeArea == null) {
                this.activeArea = this.computeActiveArea();
                if (this.activeArea == null) {
                    return false;
                }
            }
            Point point = mouseEvent.getPoint();
            if (!(mouseEvent.getSource() instanceof Component)) {
                return false;
            }
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            boolean bl = !this.activeArea.contains(point);
            return bl;
        }

        private Rectangle computeActiveArea() {
            Component component = SlideGestureRecognizer.this.slideBar.getSlidedComp();
            if (component == null || !component.isShowing()) {
                return null;
            }
            Point point = SlideGestureRecognizer.this.slideBar.getLocationOnScreen();
            Rectangle rectangle = new Rectangle(point.x - 1, point.y - 1, SlideGestureRecognizer.this.slideBar.getWidth() - 1, SlideGestureRecognizer.this.slideBar.getHeight() - 1);
            Point point2 = component.getLocationOnScreen();
            int n = point2.x;
            int n2 = point2.y;
            int n3 = component.getHeight();
            int n4 = component.getWidth();
            int n5 = SlideGestureRecognizer.this.slideBar.getModel().getOrientation();
            if (n5 == 2) {
                n4 += 8;
            }
            if (n5 == 1) {
                n4 += 8;
                n -= 8;
            }
            if (n5 == 3) {
                n3 += 8;
                n2 -= 8;
            }
            if (n5 == 4) {
                n3 += 8;
            }
            rectangle = SwingUtilities.computeUnion(n, n2, n4, n3, rectangle);
            return rectangle;
        }

        private void notifySlideOutTimer(MouseEvent mouseEvent) {
            if (!this.autoSlideActive) {
                return;
            }
            if (!this.isSlideOutGesture(mouseEvent)) {
                if (this.slideOutTimer != null && this.slideOutTimer.isRunning()) {
                    this.slideOutTimer.stop();
                    LOG.fine("notifySlideOutTimer: slide out gesture not satisfied, stopping auto slide out");
                }
                return;
            }
            if (this.slideOutTimer == null) {
                this.slideOutTimer = new Timer(400, this);
                this.slideOutTimer.setRepeats(false);
                LOG.fine("notifySlideOutTimer: created slideOutTimer");
            }
            if (!this.slideOutTimer.isRunning()) {
                this.slideOutTimer.start();
                LOG.fine("notifySlideOutTimer: started slideoutTimer");
            }
        }
    }
}

