/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public final class IDEUtils {
    private static final String CREATE_NEW_CONFIGURATION_HINT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_CreateNewConfigurationHint");
    private static final String SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationLabelText");
    private static final String SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationDialogCaption");
    private static final String INVALID_TARGET_JVM_EXEFILE_ERROR = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidTargetJVMExeFileError");
    private static final String ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ErrorConvertingProfilingSettingsMessage");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ListAccessName");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_OkButtonText");

    public static String getAntProfilerStartArgument15(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk17");
    }

    public static String getAntProfilerStartArgument18(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk18");
    }

    public static ProfilingSettings selectSettings(int n, ProfilingSettings[] profilingSettingsArray, ProfilingSettings profilingSettings) {
        int n2;
        Object[] objectArray = new Object[profilingSettingsArray.length + 1];
        for (int i = 0; i < profilingSettingsArray.length; ++i) {
            objectArray[i] = profilingSettingsArray[i];
        }
        objectArray[profilingSettingsArray.length] = CREATE_NEW_CONFIGURATION_HINT;
        JLabel jLabel = new JLabel(SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT);
        final JButton jButton = new JButton(OK_BUTTON_TEXT);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(450, 250));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.setLayout(new BorderLayout(0, 5));
        jPanel.add((Component)jLabel, "North");
        final JList<Object> jList = new JList<Object>(objectArray);
        jLabel.setLabelFor(jList);
        jList.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jButton.setEnabled(jList.getSelectedIndex() != -1);
            }
        });
        if (profilingSettings != null) {
            jList.setSelectedValue(profilingSettings, true);
        } else {
            jList.setSelectedIndex(0);
        }
        jPanel.add((Component)new JScrollPane(jList), "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton && (n2 = jList.getSelectedIndex()) != -1) {
            if (n2 < objectArray.length - 1) {
                ProfilingSettings profilingSettings2 = (ProfilingSettings)objectArray[n2];
                profilingSettings2.setProfilingType(n);
                return profilingSettings2;
            }
            ProfilingSettings profilingSettings3 = ProfilingSettingsManager.createNewSettings((int)n, (ProfilingSettings[])profilingSettingsArray);
            if (profilingSettings3 == null) {
                return null;
            }
            profilingSettings3.setProfilingType(n);
            return profilingSettings3;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int n, int n2, String string) {
        String string2 = Profiler.getDefault().getLibsDir();
        return "-agentpath:" + Platform.getAgentNativeLibFullName((String)string2, (boolean)false, (String)string, (int)n2) + "=" + string2 + "," + n + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }
}

