/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.ui.NBHTMLLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

final class ProfilerDialogs {
    private static final Logger LOGGER = Logger.getLogger(ProfilerDialogs.class.getName());
    private static final String DONT_SHOW_AGAIN_MSG = NbBundle.getMessage(ProfilerDialogs.class, (String)"ProfilerDialogs_DontShowAgainMsg");
    private static final String SHOW_DETAILS_BUTTON_TEXT = NbBundle.getMessage(ProfilerDialogs.class, (String)"ProfilerDialogs_ShowDetailsButtonText");
    private static boolean DEBUG = System.getProperty("org.netbeans.modules.profiler.ui.ProfilerDialogs") != null;
    private static final DialogDisplayer standard = DialogDisplayer.getDefault();
    private static boolean silent = false;

    private ProfilerDialogs() {
    }

    public static void setSilent(boolean bl) {
        silent = bl;
    }

    public static Dialog createDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setLeaf(true);
        return standard.createDialog(dialogDescriptor);
    }

    public static Object notify(NotifyDescriptor notifyDescriptor) {
        if (silent) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Silently closed message: " + notifyDescriptor.getMessage());
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("notify: " + notifyDescriptor.getClass().getName());
        }
        if (notifyDescriptor instanceof DNSAMessage) {
            DNSAMessage dNSAMessage = (DNSAMessage)notifyDescriptor;
            Object object = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dNSAMessage.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAMessage key: " + dNSAMessage.getDNSAKey() + ", autoAccept: " + object);
            }
            if (object != null) {
                return object;
            }
            DNSAPanel dNSAPanel = new DNSAPanel(dNSAMessage.getMessage(), dNSAMessage.getDNSADefault(), dNSAMessage.getDNSAMessage());
            dNSAMessage.setMessage(dNSAPanel);
            Object object2 = standard.notify(notifyDescriptor);
            if (object2 != DialogDescriptor.CANCEL_OPTION && object2 != DialogDescriptor.CLOSED_OPTION && dNSAPanel.isAutoChecked()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("DNSAMessage key: " + dNSAMessage.getDNSAKey() + ", setting autoAccept: " + object);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dNSAMessage.getDNSAKey(), ProfilerDialogs.ndOptionToString(object2));
            }
            return object2;
        }
        if (notifyDescriptor instanceof DNSAConfirmation) {
            DNSAConfirmation dNSAConfirmation = (DNSAConfirmation)notifyDescriptor;
            Object object = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dNSAConfirmation.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAConfirmation key: " + dNSAConfirmation.getDNSAKey() + ", autoAccept: " + object);
            }
            if (object != null) {
                return object;
            }
            DNSAPanel dNSAPanel = new DNSAPanel(dNSAConfirmation.getMessage(), dNSAConfirmation.getDNSADefault(), dNSAConfirmation.getDNSAMessage());
            dNSAConfirmation.setMessage(dNSAPanel);
            Object object3 = standard.notify(notifyDescriptor);
            if (object3 != DialogDescriptor.CANCEL_OPTION && object3 != DialogDescriptor.CLOSED_OPTION && dNSAPanel.isAutoChecked()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("ProfilerDialogs: DNSAConfirmation key: " + dNSAConfirmation.getDNSAKey() + ", setting autoAccept: " + object);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dNSAConfirmation.getDNSAKey(), ProfilerDialogs.ndOptionToString(object3));
            }
            return object3;
        }
        if (notifyDescriptor instanceof DNSAConfirmationChecked) {
            DNSAConfirmationChecked dNSAConfirmationChecked = (DNSAConfirmationChecked)notifyDescriptor;
            Object object = ProfilerDialogs.stringToNDOption(ProfilerIDESettings.getInstance().getDoNotShowAgain(dNSAConfirmationChecked.getDNSAKey()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DNSAConfirmationChecked key: " + dNSAConfirmationChecked.getDNSAKey() + ", autoAccept: " + object);
            }
            if (object != null) {
                return object;
            }
            DNSAPanel dNSAPanel = new DNSAPanel(dNSAConfirmationChecked.getMessage(), dNSAConfirmationChecked.getDNSADefault(), dNSAConfirmationChecked.getDNSAMessage());
            dNSAConfirmationChecked.setMessage(dNSAPanel);
            Object object4 = standard.notify(notifyDescriptor);
            if (object4 != DialogDescriptor.CANCEL_OPTION && object4 != DialogDescriptor.CLOSED_OPTION && dNSAPanel.isAutoChecked() && object4 != DialogDescriptor.NO_OPTION) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("ProfilerDialogs: DNSAConfirmationChecked key: " + dNSAConfirmationChecked.getDNSAKey() + ", setting autoAccept: " + object);
                }
                ProfilerIDESettings.getInstance().setDoNotShowAgain(dNSAConfirmationChecked.getDNSAKey(), ProfilerDialogs.ndOptionToString(object4));
            }
            return object4;
        }
        if (notifyDescriptor instanceof MessageWithDetails) {
            MessageWithDetails messageWithDetails;
            Object object;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("MessageWithDetails message:" + ((MessageWithDetails)notifyDescriptor).getDetailsMessage());
            }
            if ((object = standard.notify((NotifyDescriptor)(messageWithDetails = (MessageWithDetails)notifyDescriptor))) == messageWithDetails.getShowDetailsButton()) {
                object = standard.notify((NotifyDescriptor)new NotifyDescriptor.Message(messageWithDetails.getDetailsMessage(), messageWithDetails.getMessageType()));
            }
            return object;
        }
        return standard.notify(notifyDescriptor);
    }

    private static String ndOptionToString(Object object) {
        if (object == NotifyDescriptor.CANCEL_OPTION) {
            return "CANCEL_OPTION";
        }
        if (object == NotifyDescriptor.CLOSED_OPTION) {
            return "CLOSED_OPTION";
        }
        if (object == NotifyDescriptor.NO_OPTION) {
            return "NO_OPTION";
        }
        if (object == NotifyDescriptor.OK_OPTION) {
            return "OK_OPTION";
        }
        if (object == NotifyDescriptor.YES_OPTION) {
            return "YES_OPTION";
        }
        return null;
    }

    private static Object stringToNDOption(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("CANCEL_OPTION")) {
            return NotifyDescriptor.CANCEL_OPTION;
        }
        if (string.equals("CLOSED_OPTION")) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (string.equals("NO_OPTION")) {
            return NotifyDescriptor.NO_OPTION;
        }
        if (string.equals("OK_OPTION")) {
            return NotifyDescriptor.OK_OPTION;
        }
        if (string.equals("YES_OPTION")) {
            return NotifyDescriptor.YES_OPTION;
        }
        return null;
    }

    static /* synthetic */ String access$000() {
        return DONT_SHOW_AGAIN_MSG;
    }

    static /* synthetic */ String access$100() {
        return SHOW_DETAILS_BUTTON_TEXT;
    }

    private static final class DNSAPanel
    extends JPanel {
        private final JCheckBox check;

        DNSAPanel(Object object, boolean bl, String string) {
            Object object2 = null;
            if (object instanceof Component) {
                object2 = (Component)object;
            } else if (object instanceof String) {
                object2 = new NBHTMLLabel((String)object);
                ((Component)object2).setFocusable(false);
            }
            this.setLayout(new BorderLayout(0, 10));
            this.check = new JCheckBox(string, bl);
            if (object2 != null) {
                this.add((Component)object2, "Center");
            }
            this.add((Component)this.check, "South");
        }

        public boolean isAutoChecked() {
            return this.check.isSelected();
        }
    }

    public static final class MessageWithDetails
    extends DialogDescriptor {
        private JButton showDetailsButton = new JButton(ProfilerDialogs.access$100());
        private Object detailsMsg;

        public MessageWithDetails(Object object, Object object2, boolean bl) {
            super(object, NotifyDescriptor.getTitleForType((int)1));
            this.detailsMsg = object2;
            this.showDetailsButton.setDefaultCapable(false);
            this.setOptions(new Object[]{OK_OPTION});
            this.setAdditionalOptions(new Object[]{this.showDetailsButton});
            this.setLeaf(!bl);
        }

        public MessageWithDetails(Object object, Object object2, int n, boolean bl) {
            super(object, NotifyDescriptor.getTitleForType((int)n));
            this.setMessageType(n);
            this.detailsMsg = object2;
            this.showDetailsButton.setDefaultCapable(false);
            this.setOptions(new Object[]{OK_OPTION});
            this.setAdditionalOptions(new Object[]{this.showDetailsButton});
            this.setLeaf(!bl);
        }

        public Object getDetailsMessage() {
            return this.detailsMsg;
        }

        public Object getShortMessage() {
            return this.getMessage();
        }

        public JButton getShowDetailsButton() {
            return this.showDetailsButton;
        }
    }

    public static final class DNSAMessage
    extends NotifyDescriptor.Message {
        private final String dnsaKey;
        private String dnsaMessage = ProfilerDialogs.access$000();
        private boolean dnsaDefault = true;

        public DNSAMessage(String string, Object object) {
            super(object);
            this.dnsaKey = string;
        }

        public DNSAMessage(String string, Object object, int n) {
            super(object, n);
            this.dnsaKey = string;
        }

        public void setDNSADefault(boolean bl) {
            this.dnsaDefault = bl;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String string) {
            this.dnsaMessage = string;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }

    public static final class DNSAConfirmationChecked
    extends NotifyDescriptor.Confirmation {
        private final String dnsaKey;
        private String dnsaMessage = ProfilerDialogs.access$000();
        private boolean dnsaDefault = false;

        public DNSAConfirmationChecked(String string, Object object) {
            super(object);
            this.dnsaKey = string;
        }

        public DNSAConfirmationChecked(String string, Object object, String string2) {
            super(object, string2);
            this.dnsaKey = string;
        }

        public DNSAConfirmationChecked(String string, Object object, int n) {
            super(object, n);
            this.dnsaKey = string;
        }

        public DNSAConfirmationChecked(String string, Object object, String string2, int n) {
            super(object, string2, n);
            this.dnsaKey = string;
        }

        public DNSAConfirmationChecked(String string, Object object, int n, int n2) {
            super(object, n, n2);
            this.dnsaKey = string;
        }

        public DNSAConfirmationChecked(String string, Object object, String string2, int n, int n2) {
            super(object, string2, n, n2);
            this.dnsaKey = string;
        }

        public void setDNSADefault(boolean bl) {
            this.dnsaDefault = bl;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String string) {
            this.dnsaMessage = string;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }

    public static final class DNSAConfirmation
    extends NotifyDescriptor.Confirmation {
        private final String dnsaKey;
        private String dnsaMessage = ProfilerDialogs.access$000();
        private boolean dnsaDefault = true;

        public DNSAConfirmation(String string, Object object) {
            super(object);
            this.dnsaKey = string;
        }

        public DNSAConfirmation(String string, Object object, String string2) {
            super(object, string2);
            this.dnsaKey = string;
        }

        public DNSAConfirmation(String string, Object object, int n) {
            super(object, n);
            this.dnsaKey = string;
        }

        public DNSAConfirmation(String string, Object object, String string2, int n) {
            super(object, string2, n);
            this.dnsaKey = string;
        }

        public DNSAConfirmation(String string, Object object, int n, int n2) {
            super(object, n, n2);
            this.dnsaKey = string;
        }

        public DNSAConfirmation(String string, Object object, String string2, int n, int n2) {
            super(object, string2, n, n2);
            this.dnsaKey = string;
        }

        public void setDNSADefault(boolean bl) {
            this.dnsaDefault = bl;
        }

        public boolean getDNSADefault() {
            return this.dnsaDefault;
        }

        public String getDNSAKey() {
            return this.dnsaKey;
        }

        public void setDNSAMessage(String string) {
            this.dnsaMessage = string;
        }

        public String getDNSAMessage() {
            return this.dnsaMessage;
        }
    }
}

