/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExportAction.class.getName());
    private static final String EXPORT_ACTION_NAME = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionName");
    private static final String EXPORT_ACTION_DESCRIPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionDescr");
    private static final String OVERWRITE_FILE_CAPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileCaption");
    private static final String OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileMsg");
    private static final String INVALID_LOCATION_FOR_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_InvalidLocationForFileMsg");
    private static final String CANNOT_OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_CannotOverwriteFileMsg");
    private static final String EXPORT_DIALOG_TITLE = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogTitle");
    private static final String EXPORT_DIALOG_BUTTON = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogButton");
    private static final String EXPORT_DIALOG_CSV_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogCSVFilter");
    private static final String EXPORT_DIALOG_EXCEL_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogExcelFilter");
    private static final String EXPORT_DIALOG_XML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogXMLFilter");
    private static final String EXPORT_DIALOG_HTML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogHTMLFilter");
    private static final String EXPORT_DIALOG_NPS_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogNPSFilter");
    private static final String NO_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_NoViewMsg");
    private static final String EXPORTING_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportingViewMsg");
    private static final String OOME_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OomeExportingMsg");
    private static final String IOEXCEPTION_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_IOException_Exporting_Msg");
    private static final String SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.Export");
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String FILE_EXTENSION_NPS = "nps";
    public static final int MODE_CSV = 1;
    public static final int MODE_EXCEL = 2;
    public static final int MODE_XML = 3;
    public static final int MODE_HTML = 4;
    public static final int MODE_NPS = 5;
    private static File exportDir;
    private JFileChooser fileChooser;
    private ExportProvider exportProvider;
    private int exportedFileType;
    private LoadedSnapshot snapshot;

    public ExportAction(ExportProvider exportProvider, LoadedSnapshot loadedSnapshot) {
        this.putValue("Name", EXPORT_ACTION_NAME);
        this.putValue("ShortDescription", EXPORT_ACTION_DESCRIPTION);
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.exportProvider = exportProvider;
        if (loadedSnapshot != null) {
            this.snapshot = loadedSnapshot;
        }
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasExportableView()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_XML);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_XML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_HTML);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_HTML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_EXCEL_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_CSV_FILTER;
                }
            });
        }
        if (this.exportProvider.hasLoadedSnapshot()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_NPS);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_NPS_FILTER;
                }
            });
            FileFilter[] fileFilterArray = this.fileChooser.getChoosableFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (!fileFilterArray[i].getDescription().equals(EXPORT_DIALOG_NPS_FILTER)) continue;
                this.fileChooser.setFileFilter(fileFilterArray[i]);
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(EXPORT_DIALOG_TITLE);
            this.fileChooser.setApproveButtonText(EXPORT_DIALOG_BUTTON);
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (!ProfilerDialogs.displayConfirmation((String)MessageFormat.format(OVERWRITE_FILE_CAPTION, file.getName()), (String)OVERWRITE_FILE_CAPTION)) {
                return false;
            }
            if (!file.delete()) {
                ProfilerDialogs.displayError((String)MessageFormat.format(CANNOT_OVERWRITE_FILE_MSG, file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        File file;
        String string;
        int n;
        String string2 = null;
        String string3 = exportProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        if ((n = jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow())) != 0) {
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_XML_FILTER)) {
            string = FILE_EXTENSION_XML;
            this.exportedFileType = 3;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_HTML_FILTER)) {
            string = FILE_EXTENSION_HTML;
            this.exportedFileType = 4;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_EXCEL_FILTER)) {
            string = FILE_EXTENSION_CSV;
            this.exportedFileType = 2;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_NPS_FILTER)) {
            string = FILE_EXTENSION_NPS;
            this.exportedFileType = 5;
        } else {
            string = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        }
        if (file2.isDirectory()) {
            exportDir = file2;
            file = file2;
            string2 = string3;
        } else {
            file = this.fileChooser.getCurrentDirectory();
            String string4 = file2.getName();
            if (string4.endsWith("." + string)) {
                int n2 = string4.lastIndexOf(".");
                string2 = n2 == -1 ? string4 : string4.substring(0, n2);
            }
        }
        return new SelectedFile(file, string2, string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SelectedFile selectedFile;
        if (!this.exportProvider.hasExportableView() && !this.exportProvider.hasLoadedSnapshot()) {
            ProfilerDialogs.displayError((String)NO_VIEW_MSG);
            return;
        }
        final LiveResultsWindow liveResultsWindow = this.exportProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.exportProvider : null;
        final AppStatusHandler appStatusHandler = Profiler.getDefault().getTargetAppRunner().getAppStatusHandler();
        if (liveResultsWindow != null) {
            appStatusHandler.pauseLiveUpdates();
        }
        if ((selectedFile = this.selectExportTargetFile(this.exportProvider)) == null) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (this.exportedFileType == 5) {
            File file = selectedFile.getSelectedFile();
            if (!this.checkFileExists(file)) {
                return;
            }
            try {
                if (!file.getAbsolutePath().toLowerCase().endsWith(".nps")) {
                    ProfilerDialogs.displayError((String)INVALID_LOCATION_FOR_FILE_MSG);
                    return;
                }
                FileObject fileObject = FileUtil.createData((File)file);
                if (fileObject == null) {
                    ProfilerDialogs.displayError((String)INVALID_LOCATION_FOR_FILE_MSG);
                    return;
                }
                selectedFile = null;
                ResultsManager.getDefault().saveSnapshot(this.snapshot, fileObject);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_CREATE_FAILED_MSG, iOException.getMessage()), iOException);
            }
        } else {
            final File file = selectedFile.getSelectedFile();
            selectedFile = null;
            if (!this.checkFileExists(file)) {
                if (liveResultsWindow != null) {
                    appStatusHandler.resumeLiveUpdates();
                }
                return;
            }
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle progressHandle = null;
                    progressHandle = ProgressHandleFactory.createHandle((String)EXPORTING_VIEW_MSG);
                    progressHandle.setInitialDelay(500);
                    progressHandle.start();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        ExportDataDumper exportDataDumper = new ExportDataDumper(fileOutputStream);
                        ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, exportDataDumper);
                        if (exportDataDumper.getCaughtException() != null) {
                            ProfilerDialogs.displayError((String)(exportDataDumper.getNumExceptions() + IOEXCEPTION_EXPORTING_MSG));
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        ProfilerDialogs.displayError((String)(OOME_EXPORTING_MSG + outOfMemoryError.getMessage()));
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                        if (liveResultsWindow != null) {
                            appStatusHandler.resumeLiveUpdates();
                        }
                    }
                }
            });
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File file, String string, String string2) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
        }

        File getSelectedFile() {
            String string = this.folder.getAbsolutePath();
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            return new File(string + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean hasExportableView();

        public boolean hasLoadedSnapshot();
    }
}

