/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddRootMethodAction
extends NodeAction {
    public AddRootMethodAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(AddRootMethodAction.class, (String)"LBL_AddRootMethodAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(final Node[] nodeArray) {
        new NBSwingWorker(){

            protected void doInBackground() {
                try {
                    DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                    if (dataObject == null) {
                        return;
                    }
                    JavaProfilerSource javaProfilerSource = JavaProfilerSource.createFrom((FileObject)dataObject.getPrimaryFile());
                    if (javaProfilerSource == null) {
                        return;
                    }
                    int n = EditorSupport.getCurrentOffset();
                    if (n == -1) {
                        return;
                    }
                    SourceMethodInfo sourceMethodInfo = javaProfilerSource.resolveMethodAtPosition(n);
                    if (sourceMethodInfo == null) {
                        ProfilerDialogs.displayWarning((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_NoMethodFoundAtPosition"));
                        return;
                    }
                    if (sourceMethodInfo == null) {
                        return;
                    }
                    if (!sourceMethodInfo.isExecutable()) {
                        ProfilerDialogs.displayInfo((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_CannotAddAbstractNativeProfilingRoot"));
                        return;
                    }
                    Lookup.Provider provider = ProjectUtilities.getProject((FileObject)dataObject.getPrimaryFile());
                    ProfilingSettings profilingSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)provider).getProfilingSettings();
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings2 : profilingSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)profilingSettings2.getProfilingType())) continue;
                        arrayList.add(profilingSettings2);
                    }
                    ProfilingSettings profilingSettings3 = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                    if (profilingSettings3 == null) {
                        return;
                    }
                    profilingSettings3.addRootMethod(sourceMethodInfo.getClassName(), sourceMethodInfo.getVMName(), sourceMethodInfo.getSignature());
                    if (arrayList.contains(profilingSettings3)) {
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettings, (ProfilingSettings)profilingSettings3, (Lookup.Provider)provider);
                    } else {
                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[((ProfilingSettings)profilingSettings).length + 1];
                        System.arraycopy(profilingSettings, 0, profilingSettingsArray, 0, ((ProfilingSettings)profilingSettings).length);
                        profilingSettingsArray[((ProfilingSettings)profilingSettings).length] = profilingSettings3;
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings3, (Lookup.Provider)provider);
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.displayWarning((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_ProblemAddingRootMethod"));
                }
            }
        }.execute();
    }
}

