/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractIndexWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SingleIndexWriter
extends AbstractIndexWriter {
    public SingleIndexWriter(ConfigurationImpl configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename, indexbuilder);
        this.relativepathNoSlash = ".";
        this.relativePath = "./";
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        String filename = "index-all.html";
        try {
            SingleIndexWriter indexgen = new SingleIndexWriter(configuration, filename, indexbuilder);
            indexgen.generateIndexFile();
            indexgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile() throws IOException {
        String title = this.configuration.getText("doclet.Window_Single_Index");
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        this.addTop(body);
        this.addNavLinks(true, body);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(divTree);
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
        }
        this.addLinksForIndexes(divTree);
        ((Content)body).addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            String unicode = this.indexbuilder.elements()[i].toString();
            contentTree.addContent(this.getHyperLink("#_" + unicode + "_", new StringContent(unicode)));
            contentTree.addContent(this.getSpace());
        }
    }
}

