/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard.steps;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStepVisitor;

public class CompositeWizardStep
implements WizardStep {
    protected int currentIndex;
    private ConditionalFunctor condition;
    private List<WizardStep> steps;
    private String title;
    private WizardContext context;
    private WizardStep nullStep = new NullWizardStep();
    private boolean currentFlag;

    public CompositeWizardStep(String string) {
        this(null, string);
    }

    public CompositeWizardStep(WizardContext wizardContext, String string) {
        this(wizardContext, string, new TrueConditionalFunctor());
    }

    public CompositeWizardStep(WizardContext wizardContext, String string, ConditionalFunctor conditionalFunctor) {
        this.title = string;
        this.steps = new ArrayList<WizardStep>(50);
        this.condition = conditionalFunctor;
        this.currentIndex = 0;
        this.context = wizardContext;
    }

    @Override
    public WizardScreen getAttachedScreen() {
        return this.getCurrentStep().getAttachedScreen();
    }

    @Override
    public boolean isBegin() {
        return this.currentIndex == -1;
    }

    @Override
    public void setCurrent() {
    }

    @Override
    public boolean isCurrent() {
        return this.currentFlag;
    }

    @Override
    public boolean isEnd() {
        return this.currentIndex == this.steps.size();
    }

    @Override
    public void setFirst() {
        if (this.canHandle()) {
            int n;
            for (n = 0; n < this.steps.size(); ++n) {
                WizardStep wizardStep = this.getStepByIndex(n);
                wizardStep.setFirst();
                if (!wizardStep.isEnd()) break;
            }
            if (n < this.steps.size()) {
                this.currentFlag = true;
                this.currentIndex = n;
            } else {
                this.currentIndex = this.steps.size();
            }
        } else {
            this.currentIndex = this.steps.size();
        }
    }

    @Override
    public boolean isFirst() {
        boolean bl = this.getCurrentStep().isFirst();
        if (bl) {
            for (int i = this.currentIndex - 1; i >= 0; --i) {
                if (!this.getStepByIndex(i).canHandle()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setLast() {
        if (this.canHandle()) {
            int n;
            for (n = this.steps.size() - 1; n >= 0; --n) {
                WizardStep wizardStep = this.getStepByIndex(n);
                wizardStep.setLast();
                if (!wizardStep.isBegin()) break;
            }
            if (n >= 0) {
                this.currentFlag = true;
                this.currentIndex = n;
            } else {
                this.currentIndex = -1;
            }
        } else {
            this.currentIndex = -1;
        }
    }

    @Override
    public boolean isLast() {
        boolean bl = this.getCurrentStep().isLast();
        if (bl) {
            for (int i = this.currentIndex + 1; i < this.steps.size(); ++i) {
                if (!this.getStepByIndex(i).canHandle()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setNext() {
        this.getCurrentStep().setNext();
        if (this.getCurrentStep().isEnd()) {
            int n;
            for (n = this.currentIndex + 1; n < this.steps.size(); ++n) {
                WizardStep wizardStep = this.getStepByIndex(n);
                wizardStep.setFirst();
                if (!wizardStep.isEnd()) break;
            }
            if (n < this.steps.size()) {
                this.currentIndex = n;
            } else {
                this.currentFlag = false;
                this.currentIndex = this.steps.size();
            }
        }
    }

    @Override
    public void setPrevious() {
        this.getCurrentStep().setPrevious();
        if (this.getCurrentStep().isBegin()) {
            int n;
            for (n = this.currentIndex - 1; n >= 0; --n) {
                WizardStep wizardStep = this.getStepByIndex(n);
                wizardStep.setLast();
                if (!wizardStep.isBegin()) break;
            }
            if (n >= 0) {
                this.currentIndex = n;
            } else {
                this.currentFlag = false;
                this.currentIndex = -1;
            }
        }
    }

    @Override
    public int getStepIndex() {
        return this.currentIndex + this.getCurrentStep().getStepIndex();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setWizardContext(WizardContext wizardContext) {
        this.context = wizardContext;
        for (WizardStep wizardStep : this.steps) {
            wizardStep.setWizardContext(wizardContext);
        }
    }

    @Override
    public void accept(WizardStepVisitor wizardStepVisitor, WizardContext wizardContext, int n) {
        if (this.canHandle()) {
            for (WizardStep wizardStep : this.steps) {
                wizardStep.accept(wizardStepVisitor, wizardContext, n + 1);
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        for (WizardStep wizardStep : this.steps) {
            wizardStep.addChangeListener(changeListener);
        }
    }

    public WizardStep addStep(String string, WizardScreen wizardScreen) {
        return this.addStep(string, wizardScreen, new TrueConditionalFunctor());
    }

    public WizardStep addStep(String string, WizardScreen wizardScreen, ConditionalFunctor conditionalFunctor) {
        SimpleWizardStep simpleWizardStep = new SimpleWizardStep(this.context, string, wizardScreen, conditionalFunctor);
        this.steps.add(simpleWizardStep);
        return simpleWizardStep;
    }

    public void addStep(WizardStep wizardStep) {
        this.steps.add(wizardStep);
    }

    @Override
    public boolean canBack() {
        return this.getCurrentStep().canBack();
    }

    @Override
    public boolean canFinish() {
        return this.getCurrentStep().canFinish();
    }

    @Override
    public boolean canHandle() {
        if (this.context == null) {
            return false;
        }
        return this.condition.evaluate(this.context);
    }

    @Override
    public boolean canNext() {
        return this.getCurrentStep().canNext();
    }

    @Override
    public boolean onCancel() {
        return this.getCurrentStep().onCancel();
    }

    @Override
    public void onFinish() {
        this.getCurrentStep().onFinish();
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        for (WizardStep wizardStep : this.steps) {
            wizardStep.removeChangeListener(changeListener);
        }
    }

    protected WizardStep getCurrentStep() {
        if (this.currentIndex >= 0 && this.currentIndex < this.steps.size()) {
            return this.steps.get(this.currentIndex);
        }
        return this.nullStep;
    }

    private WizardStep getStepByIndex(int n) {
        n = n < 0 ? 0 : n;
        n = n > this.steps.size() ? this.steps.size() : n;
        return this.steps.get(n);
    }
}

