/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

final class OutputTab
extends AbstractOutputTab
implements IOContainer.CallBacks {
    private final NbIO io;
    private OutWriter outWriter;
    private boolean hasOutputListeners = false;
    boolean ignoreCaretChanges = false;
    int[] lastCaretListenerRange;
    private static String lastDir = null;
    FilteredOutput filtOut;
    AbstractOutputPane origPane;
    private static final ACTION[] popupItems = new ACTION[]{ACTION.COPY, ACTION.PASTE, null, ACTION.FIND, ACTION.FIND_NEXT, ACTION.FIND_PREVIOUS, ACTION.FILTER, null, ACTION.WRAP, ACTION.LARGER_FONT, ACTION.SMALLER_FONT, ACTION.FONT_TYPE, null, ACTION.SAVEAS, ACTION.CLEAR, ACTION.CLOSE};
    private static final ACTION[] actionsToInstall = new ACTION[]{ACTION.COPY, ACTION.SELECT_ALL, ACTION.FIND, ACTION.FIND_NEXT, ACTION.FIND_PREVIOUS, ACTION.WRAP, ACTION.LARGER_FONT, ACTION.SMALLER_FONT, ACTION.SAVEAS, ACTION.CLOSE, ACTION.COPY, ACTION.NAVTOLINE, ACTION.POSTMENU, ACTION.CLEAR, ACTION.FILTER};
    private final Map<ACTION, TabAction> actions = new EnumMap<ACTION, TabAction>(ACTION.class);

    OutputTab(NbIO nbIO) {
        this.io = nbIO;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + nbIO);
        }
        this.outWriter = ((NbWriter)nbIO.getOut()).out();
        this.createActions();
        OutputDocument outputDocument = new OutputDocument(this.outWriter);
        this.setDocument(outputDocument);
        this.installKBActions();
        this.getActionMap().put("jumpPrev", this.action(ACTION.PREV_ERROR));
        this.getActionMap().put("jumpNext", this.action(ACTION.NEXT_ERROR));
        this.getActionMap().put(FindAction.class.getName(), this.action(ACTION.FIND));
        this.getActionMap().put("copy-to-clipboard", this.action(ACTION.COPY));
    }

    private final TabAction action(ACTION aCTION) {
        return this.actions.get((Object)aCTION);
    }

    private void installKBActions() {
        for (ACTION aCTION : actionsToInstall) {
            this.installKeyboardAction(this.action(aCTION));
        }
    }

    @Override
    public void setDocument(Document document) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        assert (SwingUtilities.isEventDispatchThread());
        OutputDocument outputDocument = this.getDocument();
        this.hasOutputListeners = false;
        super.setDocument(document);
        if (outputDocument != null && outputDocument instanceof OutputDocument) {
            outputDocument.dispose();
        }
    }

    public void reset() {
        if (this.origPane != null) {
            this.setFilter(null, false, false);
        }
        this.outWriter = this.io.out();
        this.setDocument(new OutputDocument(this.outWriter));
    }

    public OutputDocument getDocument() {
        Document document = this.getOutputPane().getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    @Override
    protected AbstractOutputPane createOutputPane() {
        return new OutputPane(this);
    }

    @Override
    protected void inputSent(String string) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + string);
        }
        this.getOutputPane().lockScroll();
        NbIO.IOReader iOReader = this.io.in();
        if (iOReader != null) {
            if (Controller.LOG) {
                Controller.log("Sending input to " + iOReader);
            }
            iOReader.pushText(string + "\n");
            this.outWriter.println(string);
        }
    }

    @Override
    protected void inputEof() {
        NbIO.IOReader iOReader;
        if (Controller.LOG) {
            Controller.log("Input EOF");
        }
        if ((iOReader = this.io.in()) != null) {
            iOReader.eof();
        }
    }

    @Override
    public void hasSelectionChanged(boolean bl) {
        if (this.isShowing()) {
            this.actions.get((Object)ACTION.COPY).setEnabled(bl);
            this.actions.get((Object)ACTION.SELECT_ALL).setEnabled(!this.getOutputPane().isAllSelected());
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void requestActive() {
        this.io.getIOContainer().requestActive();
    }

    public void lineClicked(int n, int n2) {
        OutWriter outWriter = this.getOut();
        int[] nArray = new int[2];
        OutputListener outputListener = outWriter.getLines().getListener(n2, nArray);
        if (outputListener != null) {
            int n3 = outWriter.getLines().getCharCount();
            assert (nArray[1] < n3) : "Size: " + n3 + " range: " + nArray[0] + " " + nArray[1];
            Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, outWriter, n);
            outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            if (this.getOutputPane().getLength() >= nArray[1]) {
                this.getOutputPane().sendCaretToPos(nArray[0], nArray[1], true);
            }
        }
    }

    @Override
    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged(OutputPane outputPane) {
        if (this.filtOut != null && outputPane == this.origPane) {
            this.filtOut.readFrom(this.outWriter);
        }
        boolean bl = this.hasOutputListeners;
        boolean bl2 = this.hasOutputListeners = this.getOut() != null && (this.getOut().getLines().firstListenerLine() >= 0 || this.getOut().getLines().firstImportantListenerLine() >= 0);
        if (this.hasOutputListeners != bl) {
            this.hasOutputListenersChanged(this.hasOutputListeners);
        }
        IOContainer iOContainer = this.io.getIOContainer();
        if (this.io.isFocusTaken()) {
            iOContainer.open();
            iOContainer.select((JComponent)this);
            iOContainer.requestVisible();
        }
        Controller.getDefault().updateName(this);
        if (this == iOContainer.getSelected() && iOContainer.isActivated()) {
            this.updateActions();
        }
    }

    private void navigateToFirstErrorLine() {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int n = outWriter.getLines().firstImportantListenerLine();
            if (Controller.LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + n);
            }
            if (n >= 0) {
                this.getOutputPane().sendCaretToLine(n, false);
                if (this.isSDI()) {
                    this.requestActive();
                }
            }
        }
    }

    private boolean isSDI() {
        Container container = this.getTopLevelAncestor();
        return container != WindowManager.getDefault().getMainWindow();
    }

    void hasOutputListenersChanged(boolean bl) {
        if (bl && this.getOutputPane().isScrollLocked()) {
            this.navigateToFirstErrorLine();
        }
    }

    public void activated() {
        this.updateActions();
    }

    public void closed() {
        this.io.setClosed(true);
        this.io.setStreamClosed(true);
        Controller.getDefault().removeTab(this.io);
        NbWriter nbWriter = this.io.writer();
        if (nbWriter != null && nbWriter.isClosed()) {
            this.setDocument(null);
            this.io.dispose();
        } else if (nbWriter != null) {
            if (this.getOut() != null) {
                this.getOut().setDisposeOnClose(true);
            }
            this.getDocument().disposeQuietly();
            NbIOProvider.dispose(this.io);
        }
    }

    public void deactivated() {
    }

    public void selected() {
    }

    public boolean shouldRelock(int n) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null && !outWriter.isClosed()) {
            int n2 = Math.abs(outWriter.getLines().getCharCount() - n);
            return n2 < 100;
        }
        return false;
    }

    void caretPosChanged(int n) {
        if (!this.ignoreCaretChanges) {
            if (this.lastCaretListenerRange != null && n >= this.lastCaretListenerRange[0] && n < this.lastCaretListenerRange[1]) {
                return;
            }
            OutWriter outWriter = this.getOut();
            if (outWriter != null) {
                int[] nArray = new int[2];
                OutputListener outputListener = outWriter.getLines().getListener(n, nArray);
                if (outputListener != null) {
                    Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, outWriter.getLines().getLineAt(n));
                    outputListener.outputLineSelected((OutputEvent)controllerOutputEvent);
                    this.lastCaretListenerRange = nArray;
                } else {
                    this.lastCaretListenerRange = null;
                }
            }
        }
    }

    private void sendCaretToError(boolean bl) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            AbstractOutputPane abstractOutputPane = this.getOutputPane();
            int n = abstractOutputPane.getSelectionStart();
            int n2 = abstractOutputPane.getSelectionEnd();
            int n3 = abstractOutputPane.getCaretPos();
            if (n != n2 && n3 == n && outWriter.getLines().isListener(n, n2)) {
                n3 = bl ? n - 1 : n2 + 1;
            }
            int[] nArray = new int[2];
            OutputListener outputListener = outWriter.getLines().nearestListener(n3, bl, nArray);
            if (outputListener != null) {
                abstractOutputPane.sendCaretToPos(nArray[0], nArray[1], true);
                if (!this.io.getIOContainer().isActivated()) {
                    Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, outWriter.getLines().getLineAt(nArray[0]));
                    outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
                }
            }
        }
    }

    private boolean find(boolean bl) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            String string;
            int n;
            String string2 = FindDialogPanel.result();
            if (string2 == null) {
                return false;
            }
            int n2 = n = bl ? this.getOutputPane().getSelectionStart() : this.getOutputPane().getCaretPos();
            if (n > this.getOutputPane().getLength() || n < 0) {
                n = 0;
            }
            boolean bl2 = FindDialogPanel.regExp();
            boolean bl3 = FindDialogPanel.matchCase();
            int[] nArray = bl ? outWriter.getLines().rfind(n, string2, bl2, bl3) : outWriter.getLines().find(n, string2, bl2, bl3);
            String string3 = null;
            if (nArray == null) {
                int[] nArray2 = nArray = bl ? outWriter.getLines().rfind(outWriter.getLines().getCharCount(), string2, bl2, bl3) : outWriter.getLines().find(0, string2, bl2, bl3);
                if (nArray != null) {
                    string3 = NbBundle.getMessage(OutputTab.class, (String)(bl ? "MSG_SearchFromEnd" : "MSG_SearchFromBeg"));
                }
            }
            if (nArray != null) {
                this.getOutputPane().unlockScroll();
                this.getOutputPane().setSelection(nArray[0], nArray[1]);
                int n3 = outWriter.getLines().getLineAt(nArray[0]);
                int n4 = nArray[0] - outWriter.getLines().getLineStart(n3);
                string = NbBundle.getMessage(OutputTab.class, (String)"MSG_Found", (Object)string2, (Object)(n3 + 1), (Object)(n4 + 1));
                if (string3 != null) {
                    string = string + "; " + string3;
                }
            } else {
                string = NbBundle.getMessage(OutputTab.class, (String)"MSG_NotFound", (Object)string2);
            }
            StatusDisplayer.getDefault().setStatusText(string);
            return nArray != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAs() {
        OutWriter outWriter = this.getOut();
        if (outWriter == null) {
            return;
        }
        File file = OutputTab.showFileChooser(this);
        if (file != null) {
            try {
                OutWriter outWriter2 = outWriter;
                synchronized (outWriter2) {
                    outWriter.getLines().saveAs(file.getPath());
                }
            }
            catch (IOException iOException) {
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(OutputTab.class, (String)"MSG_SaveAsFailed", (Object)file.getPath()), NbBundle.getMessage(OutputTab.class, (String)"LBL_SaveAsFailedTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
        }
    }

    private static File showFileChooser(JComponent jComponent) {
        Object object;
        Object object2;
        File file = null;
        String string = NbBundle.getMessage(Controller.class, (String)"TITLE_SAVE_DLG");
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (bl) {
            String string2;
            object2 = jComponent.getTopLevelAncestor();
            object = object2 instanceof Frame ? new FileDialog((Frame)object2, string, 1) : new FileDialog((Dialog)object2, string, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                ((FileDialog)object).setDirectory(lastDir);
            }
            ((Dialog)object).setModal(true);
            ((Dialog)object).setVisible(true);
            if (((FileDialog)object).getFile() != null && ((FileDialog)object).getDirectory() != null && (file = new File(string2 = ((FileDialog)object).getDirectory() + ((FileDialog)object).getFile())).exists() && file.isDirectory()) {
                file = null;
            }
        } else {
            object2 = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && ((File)(object = new File(lastDir))).exists()) {
                ((JFileChooser)object2).setCurrentDirectory((File)object);
            }
            ((Component)object2).setName(string);
            ((JFileChooser)object2).setDialogTitle(string);
            if (((JFileChooser)object2).showSaveDialog(jComponent.getTopLevelAncestor()) == 0) {
                file = ((JFileChooser)object2).getSelectedFile();
            }
        }
        if (file != null && file.exists() && !bl) {
            object2 = NbBundle.getMessage(Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{file.getName()});
            object = NbBundle.getMessage(Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(jComponent.getTopLevelAncestor(), object2, (String)object, 2) != 0) {
                file = null;
            }
        }
        if (file != null) {
            lastDir = file.getParent();
        }
        return file;
    }

    private void openHyperlink() {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int n = this.getOutputPane().getCaretPos();
            int[] nArray = new int[2];
            OutputListener outputListener = outWriter.getLines().getListener(n, nArray);
            if (outputListener != null) {
                this.ignoreCaretChanges = true;
                this.getOutputPane().sendCaretToPos(nArray[0], nArray[1], true);
                this.ignoreCaretChanges = false;
                Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, outWriter.getLines().getLineAt(n));
                outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            }
        }
    }

    void postPopupMenu(Point point, Component component) {
        Object object;
        Serializable serializable;
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Action[] actionArray = this.getToolbarActions();
        if (actionArray.length > 0) {
            boolean bl = false;
            for (n = 0; n < actionArray.length; ++n) {
                if (actionArray[n].getValue("Name") == null) continue;
                jPopupMenu.add(new ProxyAction(actionArray[n]));
                bl = true;
            }
            if (bl) {
                jPopupMenu.add(new JSeparator());
            }
        }
        ArrayList<TabAction> arrayList = new ArrayList<TabAction>(popupItems.length);
        for (n = 0; n < popupItems.length; ++n) {
            if (popupItems[n] == null) {
                jPopupMenu.add(new JSeparator());
                continue;
            }
            serializable = this.action(popupItems[n]);
            if (popupItems[n] == ACTION.WRAP) {
                object = new JCheckBoxMenuItem((Action)((Object)serializable));
                ((AbstractButton)object).setSelected(this.getOutputPane().isWrapped());
                arrayList.add((TabAction)serializable);
                jPopupMenu.add((JMenuItem)object);
                continue;
            }
            if (popupItems[n] == ACTION.FILTER) {
                object = new JCheckBoxMenuItem((Action)((Object)serializable));
                ((AbstractButton)object).setSelected(this.origPane != null);
                arrayList.add((TabAction)serializable);
                jPopupMenu.add((JMenuItem)object);
                continue;
            }
            if (popupItems[n] == ACTION.CLOSE && !this.io.getIOContainer().isCloseable((JComponent)this) || popupItems[n] == ACTION.FONT_TYPE && this.getOutputPane().isWrapped()) continue;
            object = jPopupMenu.add((Action)((Object)serializable));
            arrayList.add((TabAction)serializable);
            if (popupItems[n] != ACTION.FIND) continue;
            ((AbstractButton)object).setMnemonic(70);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        serializable = this.getOutputPane().getTextView();
        object = ((JComponent)serializable).getInputMap().get(keyStroke);
        ((JComponent)serializable).getInputMap().remove(keyStroke);
        this.getInputMap(1).remove(keyStroke);
        jPopupMenu.addPopupMenuListener(new PMListener(arrayList, object));
        jPopupMenu.show(component, point.x, point.y);
    }

    void updateActions() {
        OutputPane outputPane = (OutputPane)this.getOutputPane();
        int n = outputPane.getLength();
        boolean bl = n > 0;
        OutWriter outWriter = this.getOut();
        this.action(ACTION.SAVEAS).setEnabled(bl);
        this.action(ACTION.SELECT_ALL).setEnabled(bl);
        this.action(ACTION.COPY).setEnabled(outputPane.hasSelection());
        boolean bl2 = outWriter == null ? false : outWriter.getLines().hasListeners();
        this.action(ACTION.NEXT_ERROR).setEnabled(bl2);
        this.action(ACTION.PREV_ERROR).setEnabled(bl2);
    }

    private void showFontChooser() {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
        if (propertyEditor != null) {
            propertyEditor.setValue(this.getOutputPane().getViewFont());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), NbBundle.getMessage(OutputTab.class, (String)"LBL_Font_Chooser_Title"));
            String string = NbBundle.getMessage(OutputTab.class, (String)"BTN_Defaul_Font");
            dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION, string, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                Font font = (Font)propertyEditor.getValue();
                Controller.getDefault().changeFont(font);
            } else if (dialogDescriptor.getValue() == string) {
                Controller.getDefault().changeFont(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilter(String string, boolean bl, boolean bl2) {
        if (string == null) {
            assert (this.origPane != null);
            this.setOutputPane(this.origPane);
            this.origPane = null;
            this.filtOut.dispose();
            this.filtOut = null;
        } else {
            assert (this.origPane == null);
            this.origPane = this.getOutputPane();
            this.filtOut = new FilteredOutput(string, bl, bl2);
            this.setOutputPane(this.filtOut.getPane());
            try {
                this.waitCursor(true);
                this.filtOut.readFrom(this.outWriter);
                this.installKBActions();
            }
            finally {
                this.waitCursor(false);
            }
        }
        this.validate();
        this.getOutputPane().repaint();
        this.requestFocus();
    }

    private void waitCursor(boolean bl) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        Cursor cursor = Cursor.getPredefinedCursor(bl ? 3 : 0);
        rootPaneContainer.getGlassPane().setCursor(cursor);
        rootPaneContainer.getGlassPane().setVisible(bl);
    }

    OutWriter getOut() {
        return this.origPane != null ? this.filtOut.getWriter() : this.outWriter;
    }

    private void disableHtmlName() {
        String string;
        Controller.getDefault().removeFromUpdater(this);
        try {
            string = XMLUtil.toAttributeValue((String)(this.io.getName() + " "));
        }
        catch (CharConversionException charConversionException) {
            string = this.io.getName() + " ";
        }
        this.io.getIOContainer().setTitle((JComponent)this, string.replace("&apos;", "'"));
    }

    private void createActions() {
        for (ACTION aCTION : ACTION.values()) {
            TabAction tabAction;
            switch (aCTION) {
                case COPY: 
                case PASTE: 
                case WRAP: 
                case SAVEAS: 
                case CLOSE: 
                case NEXT_ERROR: 
                case PREV_ERROR: 
                case SELECT_ALL: 
                case FIND: 
                case FIND_NEXT: 
                case FIND_PREVIOUS: 
                case FILTER: 
                case LARGER_FONT: 
                case SMALLER_FONT: 
                case FONT_TYPE: 
                case CLEAR: {
                    tabAction = new TabAction(aCTION, "ACTION_" + aCTION.name());
                    break;
                }
                case NAVTOLINE: {
                    tabAction = new TabAction(aCTION, "navToLine", KeyStroke.getKeyStroke(10, 0));
                    break;
                }
                case POSTMENU: {
                    tabAction = new TabAction(aCTION, "postMenu", KeyStroke.getKeyStroke(121, 64));
                    break;
                }
                case NEXTTAB: {
                    tabAction = new TabAction(aCTION, "NextViewAction", null);
                    break;
                }
                case PREVTAB: {
                    tabAction = new TabAction(aCTION, "PreviousViewAction", null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled action " + (Object)((Object)aCTION));
                }
            }
            this.actions.put(aCTION, tabAction);
        }
    }

    @Override
    public void setInputVisible(boolean bl) {
        super.setInputVisible(bl);
        this.action(ACTION.PASTE).setEnabled(bl);
    }

    private boolean validRegExp(String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), NbBundle.getMessage(OutputTab.class, (String)"FMT_Invalid_RegExp", (Object)string), NbBundle.getMessage(OutputTab.class, (String)"LBL_Invalid_RegExp"), 0);
            return false;
        }
    }

    private String getFindDlgResult(String string, String string2, String string3, String string4) {
        String string5 = FindDialogPanel.getResult(string, string2, string3, string4);
        while (string5 != null && FindDialogPanel.regExp() && !this.validRegExp(string5)) {
            string5 = FindDialogPanel.getResult(string5, string2, string3, string4);
        }
        return string5;
    }

    private class FilteredOutput {
        String pattern;
        OutWriter out;
        OutputPane pane;
        OutputDocument doc;
        int readCount;
        Pattern compPattern;
        boolean regExp;
        boolean matchCase;

        public FilteredOutput(String string, boolean bl, boolean bl2) {
            this.pattern = bl || bl2 ? string : string.toLowerCase();
            this.regExp = bl;
            this.matchCase = bl2;
            this.out = new OutWriter();
            this.pane = new OutputPane(OutputTab.this);
            this.doc = new OutputDocument(this.out);
            this.pane.setDocument(this.doc);
        }

        boolean passFilter(String string) {
            if (this.regExp) {
                if (this.compPattern == null) {
                    this.compPattern = this.matchCase ? Pattern.compile(this.pattern) : Pattern.compile(this.pattern, 2);
                }
                return this.compPattern.matcher(string).find();
            }
            return this.matchCase ? string.contains(this.pattern) : string.toLowerCase().contains(this.pattern);
        }

        OutputPane getPane() {
            return this.pane;
        }

        OutWriter getWriter() {
            return this.out;
        }

        synchronized void readFrom(OutWriter outWriter) {
            AbstractLines abstractLines = (AbstractLines)outWriter.getLines();
            while (this.readCount < abstractLines.getLineCount()) {
                try {
                    int n;
                    ++this.readCount;
                    String string = abstractLines.getLine(n);
                    if (!this.passFilter(string)) continue;
                    LineInfo lineInfo = abstractLines.getExistingLineInfo(n);
                    this.out.print(string, lineInfo, abstractLines.isImportantLine(n));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        void dispose() {
            this.out.dispose();
        }
    }

    private class PMListener
    implements PopupMenuListener {
        private List<TabAction> popupItems;
        private Object handle;

        PMListener(List<TabAction> list, Object object) {
            this.popupItems = list;
            this.handle = object;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            jPopupMenu.removeAll();
            jPopupMenu.setInvoker(null);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            JTextComponent jTextComponent = OutputTab.this.getOutputPane().getTextView();
            jTextComponent.getInputMap().put(keyStroke, this.handle);
            OutputTab.this.getInputMap(1).put(keyStroke, this.handle);
            jPopupMenu.removePopupMenuListener(this);
            for (TabAction tabAction : this.popupItems) {
                tabAction.clearListeners();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupMenuWillBecomeInvisible(popupMenuEvent);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action action) {
            this.orig = action;
        }

        @Override
        public Object getValue(String string) {
            if ("SmallIcon".equals(string)) {
                return null;
            }
            return this.orig.getValue(string);
        }

        @Override
        public void putValue(String string, Object object) {
            this.orig.putValue(string, object);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.orig.setEnabled(bl);
        }

        @Override
        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.orig.actionPerformed(actionEvent);
        }
    }

    class TabAction
    extends AbstractAction {
        private ACTION action;

        TabAction(ACTION aCTION, String string) {
            if (string != null) {
                String string2 = NbBundle.getMessage(OutputTab.class, (String)string);
                KeyStroke keyStroke = this.getAcceleratorFor(string);
                this.action = aCTION;
                this.putValue("Name", string2);
                this.putValue("AcceleratorKey", keyStroke);
            }
        }

        TabAction(ACTION aCTION, String string, KeyStroke keyStroke) {
            this.action = aCTION;
            this.putValue("Name", string);
            this.putValue("AcceleratorKey", keyStroke);
        }

        void clearListeners() {
            PropertyChangeListener[] propertyChangeListenerArray = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                this.removePropertyChangeListener(propertyChangeListenerArray[i]);
            }
        }

        private KeyStroke getAcceleratorFor(String string) {
            String string2 = string + ".accel";
            if (Utilities.isMac()) {
                string2 = string2 + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage(OutputTab.class, (String)string2));
        }

        public ACTION getAction() {
            return this.action;
        }

        @Override
        public boolean isEnabled() {
            if (OutputTab.this.getIO().isClosed()) {
                JComponent jComponent = OutputTab.this.getIO().getIOContainer().getSelected();
                if (OutputTab.this != jComponent && jComponent instanceof OutputTab) {
                    OutputTab outputTab = (OutputTab)jComponent;
                    return outputTab.action(this.action).isEnabled();
                }
                return false;
            }
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OutputTab.this.getIO().isClosed()) {
                JComponent jComponent = OutputTab.this.getIO().getIOContainer().getSelected();
                if (OutputTab.this != jComponent && jComponent instanceof OutputTab) {
                    OutputTab outputTab = (OutputTab)jComponent;
                    outputTab.action(this.action).actionPerformed(actionEvent);
                }
                return;
            }
            switch (this.getAction()) {
                case COPY: {
                    OutputTab.this.getOutputPane().copy();
                    break;
                }
                case PASTE: {
                    OutputTab.this.getOutputPane().paste();
                    break;
                }
                case WRAP: {
                    boolean bl = OutputTab.this.getOutputPane().isWrapped();
                    OutputTab.this.getOutputPane().setWrapped(!bl);
                    break;
                }
                case SAVEAS: {
                    OutputTab.this.saveAs();
                    break;
                }
                case CLOSE: {
                    OutputTab.this.io.getIOContainer().remove((JComponent)OutputTab.this);
                    break;
                }
                case NEXT_ERROR: {
                    OutputTab.this.sendCaretToError(false);
                    break;
                }
                case PREV_ERROR: {
                    OutputTab.this.sendCaretToError(true);
                    break;
                }
                case SELECT_ALL: {
                    OutputTab.this.getOutputPane().selectAll();
                    break;
                }
                case FIND: {
                    String string = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Find_Title", "LBL_Find_What", "BTN_Find");
                    if (string == null || !OutputTab.this.find(false)) break;
                    OutputTab.this.action(ACTION.FIND_NEXT).setEnabled(true);
                    OutputTab.this.action(ACTION.FIND_PREVIOUS).setEnabled(true);
                    OutputTab.this.requestFocus();
                    break;
                }
                case FIND_NEXT: {
                    OutputTab.this.find(false);
                    break;
                }
                case FIND_PREVIOUS: {
                    OutputTab.this.find(true);
                    break;
                }
                case NAVTOLINE: {
                    OutputTab.this.openHyperlink();
                    break;
                }
                case POSTMENU: {
                    OutputTab.this.postPopupMenu(new Point(0, 0), OutputTab.this);
                    break;
                }
                case CLEAR: {
                    NbWriter nbWriter = OutputTab.this.io.writer();
                    if (nbWriter == null) break;
                    try {
                        boolean bl = OutputTab.this.isInputVisible();
                        boolean bl2 = OutputTab.this.io.isStreamClosed();
                        nbWriter.reset();
                        OutputTab.this.setInputVisible(bl);
                        OutputTab.this.io.setStreamClosed(bl2);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    break;
                }
                case SMALLER_FONT: {
                    Controller.getDefault().changeFontSizeBy(-1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case LARGER_FONT: {
                    Controller.getDefault().changeFontSizeBy(1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case FONT_TYPE: {
                    OutputTab.this.showFontChooser();
                    break;
                }
                case FILTER: {
                    if (OutputTab.this.origPane != null) {
                        OutputTab.this.setFilter(null, false, false);
                        break;
                    }
                    String string = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Filter_Title", "LBL_Filter_What", "BTN_Filter");
                    if (string == null) break;
                    OutputTab.this.setFilter(string, FindDialogPanel.regExp(), FindDialogPanel.matchCase());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    static enum ACTION {
        COPY,
        WRAP,
        SAVEAS,
        CLOSE,
        NEXT_ERROR,
        PREV_ERROR,
        SELECT_ALL,
        FIND,
        FIND_NEXT,
        NAVTOLINE,
        POSTMENU,
        FIND_PREVIOUS,
        CLEAR,
        NEXTTAB,
        PREVTAB,
        LARGER_FONT,
        SMALLER_FONT,
        FONT_TYPE,
        FILTER,
        PASTE;

    }
}

