/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.WinAppBundler;
import com.sun.javafx.tools.resource.windows.WinResources;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinMsiBundler
extends Bundler {
    WinAppBundler appBundler = new WinAppBundler();
    BundleParams params;
    private File configRoot = null;
    File imageDir = null;
    private boolean menuShortcut = false;
    private boolean desktopShortcut = false;
    private boolean canUseWix36Features = false;
    private int id;
    private int compId;
    private static final String LAUNCHER_ID = "LauncherId";
    private static final String MSI_PROJECT_TEMPLATE = "template.wxs";
    private static final String MSI_PROJECT_CONTENT_FILE = "bundle.wxi";
    private static final String TOOL_CANDLE = "candle";
    private static final String TOOL_LIGHT = "light";

    public WinMsiBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "windows");
        this.configRoot.mkdirs();
        this.appBundler.setBuildRoot(dir);
    }

    public void setVerbose(boolean m) {
        super.setVerbose(m);
        this.appBundler.setVerbose(m);
    }

    private static double findTool(String toolName) {
        try {
            ProcessBuilder pb = new ProcessBuilder(toolName, "/?");
            VersionExtractor ve = new VersionExtractor();
            IOUtils.exec(pb, Log.isDebug(), true, ve);
            double version = ve.getVersion();
            Log.verbose("  Detected [" + toolName + "] version [" + version + "]");
            return version;
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            return 0.0;
        }
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.INSTALLER || p.bundleFormat != null && !"msi".equals(p.bundleFormat)) {
            return false;
        }
        this.appBundler.doValidate(p);
        double candleVersion = WinMsiBundler.findTool(TOOL_CANDLE);
        double lightVersion = WinMsiBundler.findTool(TOOL_LIGHT);
        double minVersion = 3.0;
        boolean bad = false;
        if (candleVersion < minVersion) {
            Log.verbose("Detected [candle] version " + candleVersion + " but version " + minVersion + " is required.");
            bad = true;
        }
        if (lightVersion < minVersion) {
            Log.verbose("Detected [light] version " + lightVersion + " but version " + minVersion + " is required.");
            bad = true;
        }
        if (bad) {
            throw new Bundler.ConfigException("Can not find WiX tools (light.exe, candle.exe).", "  Download WiX 3.0 or later from http://wix.sf.net and add it to the PATH.");
        }
        if (lightVersion >= (double)3.6f) {
            Log.verbose("WiX 3.6 detected. Enabling advanced cleanup action.");
            this.canUseWix36Features = true;
        }
        return true;
    }

    private boolean prepareProto() {
        File bundleRoot = this.getImageRootDir().getParentFile();
        return this.appBundler.doBundle(this.params, bundleRoot, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bundle(BundleParams p, File outdir) {
        boolean configScriptSrc2;
        block29: {
            boolean bl;
            block28: {
                this.imageDir = new File(this.imagesRoot, "win-msi");
                try {
                    try {
                        this.params = p;
                        this.imageDir.mkdirs();
                        this.menuShortcut = this.params.needMenu;
                        this.desktopShortcut = this.params.needShortcut;
                        if (!this.menuShortcut && !this.desktopShortcut) {
                            Log.verbose("At least one type of shortcut is required. Enabling menu shortcut.");
                            this.menuShortcut = true;
                        }
                        if (this.prepareProto() && this.prepareWiXConfig() && this.prepareBasicProjectConfig()) {
                            File configScriptSrc2 = this.getConfig_Script();
                            if (configScriptSrc2.exists()) {
                                File configScript = new File(this.imageDir, configScriptSrc2.getName());
                                IOUtils.copyFile(configScriptSrc2, configScript);
                                Log.info("Running WSH script on application image [" + configScript.getAbsolutePath() + "]");
                                IOUtils.run("wscript", configScript, this.verbose);
                            }
                            bl = this.buildMSI(outdir);
                            Object var6_9 = null;
                            break block28;
                        }
                        configScriptSrc2 = false;
                        break block29;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        boolean bl2 = false;
                        Object var6_11 = null;
                        try {
                            if (this.imageDir != null && !Log.isDebug()) {
                                IOUtils.deleteRecursive(this.imageDir);
                            } else if (this.imageDir != null) {
                                Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                            }
                            if (this.verbose) {
                                Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                                return bl2;
                            }
                            this.cleanupConfigFiles();
                            return bl2;
                        }
                        catch (FileNotFoundException ex2) {
                            return false;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    try {}
                    catch (FileNotFoundException ex2) {
                        return false;
                    }
                    if (this.imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(this.imageDir);
                    } else if (this.imageDir != null) {
                        Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                    }
                    if (this.verbose) {
                        Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                        throw throwable;
                    }
                    this.cleanupConfigFiles();
                    throw throwable;
                }
            }
            try {}
            catch (FileNotFoundException ex2) {
                return false;
            }
            if (this.imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(this.imageDir);
            } else if (this.imageDir != null) {
                Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
            }
            if (this.verbose) {
                Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                return bl;
            }
            this.cleanupConfigFiles();
            return bl;
        }
        Object var6_10 = null;
        try {}
        catch (FileNotFoundException ex2) {
            return false;
        }
        if (this.imageDir != null && !Log.isDebug()) {
            IOUtils.deleteRecursive(this.imageDir);
        } else if (this.imageDir != null) {
            Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
        }
        if (this.verbose) {
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
            return configScriptSrc2;
        }
        this.cleanupConfigFiles();
        return configScriptSrc2;
    }

    protected void cleanupConfigFiles() {
        if (this.getConfig_ProjectFile() != null) {
            this.getConfig_ProjectFile().delete();
        }
        if (this.getConfig_Script() != null) {
            this.getConfig_Script().delete();
        }
    }

    private File getConfig_Script() {
        return new File(this.configRoot, WinAppBundler.getAppName(this.params) + "-post-image.wsf");
    }

    public String toString() {
        return "MSI Bundler (WiX based)";
    }

    private boolean prepareBasicProjectConfig() throws IOException {
        this.fetchResource("package/windows/" + this.getConfig_Script().getName(), "script to run after application image is populated", (String)null, this.getConfig_Script());
        return true;
    }

    private String relativePath(File basedir, File file) {
        return file.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
    }

    private String getVendor() {
        if (this.params.vendor != null) {
            return this.params.vendor;
        }
        return "Unknown";
    }

    UUID getUpgradeGUID() {
        UUID uid = null;
        if (this.params.identifier != null) {
            try {
                uid = UUID.fromString(this.params.identifier);
            }
            catch (IllegalArgumentException iae) {
                Log.verbose("Can not use app identifier [" + this.params.identifier + "] as upgrade GUID for MSI. Wrong format.");
            }
        }
        if (uid == null) {
            uid = UUID.randomUUID();
            Log.verbose("Generated random upgrade GUID for MSI [" + uid.toString() + "]. To overwrite: specify GUID as id attribute of application tag.");
        }
        return uid;
    }

    private String getDescription() {
        if (this.params.description != null) {
            return this.params.description.replaceAll("\"", "'");
        }
        return "none";
    }

    private boolean isSystemWide() {
        return this.params.systemWide == null || this.params.systemWide != false;
    }

    private String getVersion() {
        return this.params.appVersion != null ? this.params.appVersion : "1.0";
    }

    private File getImageRootDir() {
        File root = WinAppBundler.getLauncher(this.imageDir, this.params).getParentFile();
        return root;
    }

    boolean prepareMainProjectFile() throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        UUID productGUID = UUID.randomUUID();
        Log.verbose("Generated product GUID: " + productGUID.toString());
        data.put("PRODUCT_GUID", productGUID.toString());
        data.put("PRODUCT_UPGRADE_GUID", this.getUpgradeGUID().toString());
        data.put("APPLICATION_NAME", WinAppBundler.getAppName(this.params));
        data.put("APPLICATION_DESCRIPTION", this.getDescription());
        data.put("APPLICATION_VENDOR", this.getVendor());
        data.put("APPLICATION_VERSION", this.getVersion());
        File launcher = WinAppBundler.getLauncher(this.getImageRootDir().getParentFile(), this.params);
        String launcherPath = this.relativePath(this.getImageRootDir(), launcher);
        data.put("APPLICATION_LAUNCHER", launcherPath);
        String iconPath = launcherPath.replace(".exe", ".ico");
        data.put("APPLICATION_ICON", iconPath);
        data.put("REGISTRY_ROOT", this.getRegistryRoot());
        data.put("WIX36_ONLY_START", this.canUseWix36Features ? "" : "<!--");
        data.put("WIX36_ONLY_END", this.canUseWix36Features ? "" : "-->");
        if (this.isSystemWide()) {
            data.put("INSTALL_SCOPE", "perMachine");
        } else {
            data.put("INSTALL_SCOPE", "perUser");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_ProjectFile()));
        w.write(this.preprocessTextResource("package/windows/" + this.getConfig_ProjectFile().getName(), "WiX config file", MSI_PROJECT_TEMPLATE, data));
        ((Writer)w).close();
        return true;
    }

    private void walkFileTree(File root, PrintStream out, String prefix) {
        boolean isLauncher;
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            throw new RuntimeException("Can not walk [" + root.getAbsolutePath() + "] - it is not a valid directory");
        }
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                dirs.add(f);
                continue;
            }
            files.add(f);
        }
        out.println(prefix + " <Component Id=\"comp" + this.compId++ + "\" DiskId=\"1\"" + " Guid=\"" + UUID.randomUUID().toString() + "\">");
        out.println("  <CreateFolder/>");
        out.println("  <RemoveFolder Id=\"RemoveDir" + this.id++ + "\" On=\"uninstall\" />");
        boolean needRegistryKey = !this.isSystemWide();
        File launcherFile = WinAppBundler.getLauncher(this.getImageRootDir().getParentFile(), this.params);
        for (File f : files) {
            isLauncher = f.equals(launcherFile);
            if (!isLauncher) continue;
            needRegistryKey = true;
        }
        if (needRegistryKey) {
            out.println(prefix + "    <RegistryKey Root=\"HKCU\" " + " Key=\"Software\\" + this.getVendor() + "\\" + WinAppBundler.getAppName(this.params) + "\"" + (this.canUseWix36Features ? ">" : " Action=\"createAndRemoveOnUninstall\">"));
            out.println(prefix + "     <RegistryValue Name=\"Version\" Value=\"" + this.getVersion() + "\" Type=\"string\" KeyPath=\"yes\"/>");
            out.println(prefix + "   </RegistryKey>");
        }
        for (File f : files) {
            isLauncher = f.equals(WinAppBundler.getLauncher(this.getImageRootDir().getParentFile(), this.params));
            boolean doShortcuts = isLauncher && (this.menuShortcut || this.desktopShortcut);
            out.println(prefix + "   <File Id=\"" + (isLauncher ? LAUNCHER_ID : "FileId" + this.id++) + "\"" + " Name=\"" + f.getName() + "\" " + " Source=\"" + this.relativePath(this.getImageRootDir(), f) + "\">");
            if (doShortcuts && this.desktopShortcut) {
                out.println(prefix + "  <Shortcut Id=\"desktopShortcut\" Directory=\"DesktopFolder\"" + " Name=\"" + WinAppBundler.getAppName(this.params) + "\" WorkingDirectory=\"INSTALLDIR\"" + " Advertise=\"no\" Icon=\"DesktopIcon.exe\" IconIndex=\"0\" />");
            }
            if (doShortcuts && this.menuShortcut) {
                out.println(prefix + "     <Shortcut Id=\"ExeShortcut\" Directory=\"ProgramMenuDir\"" + " Name=\"" + WinAppBundler.getAppName(this.params) + "\" Advertise=\"no\" Icon=\"StartMenuIcon.exe\" IconIndex=\"0\" />");
            }
            out.println(prefix + "   </File>");
        }
        out.println(prefix + " </Component>");
        for (File d : dirs) {
            out.println(prefix + " <Directory Id=\"dirid" + this.id++ + "\" Name=\"" + d.getName() + "\">");
            this.walkFileTree(d, out, prefix + " ");
            out.println(prefix + " </Directory>");
        }
    }

    String getRegistryRoot() {
        if (this.isSystemWide()) {
            return "HKLM";
        }
        return "HKCU";
    }

    boolean prepareContentList() throws FileNotFoundException {
        File f = new File(this.configRoot, MSI_PROJECT_CONTENT_FILE);
        PrintStream out = new PrintStream(f);
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<Include>");
        out.println(" <Directory Id=\"TARGETDIR\" Name=\"SourceDir\">");
        if (this.isSystemWide()) {
            out.println("  <Directory Id=\"ProgramFilesFolder\" Name=\"PFiles\">");
        } else {
            out.println("  <Directory Name=\"AppData\" Id=\"LocalAppDataFolder\">");
        }
        out.println("   <Directory Id=\"APPLICATIONFOLDER\" Name=\"" + WinAppBundler.getAppName(this.params) + "\">");
        this.id = 0;
        this.compId = 0;
        this.walkFileTree(this.getImageRootDir(), out, "    ");
        out.println("   </Directory>");
        out.println("  </Directory>");
        if (this.desktopShortcut) {
            out.println("  <Directory Id=\"DesktopFolder\" />");
        }
        if (this.menuShortcut) {
            out.println("  <Directory Id=\"ProgramMenuFolder\">");
            out.println("    <Directory Id=\"ProgramMenuDir\" Name=\"" + this.getVendor() + "\">");
            out.println("      <Component Id=\"comp" + this.compId++ + "\"" + " Guid=\"" + UUID.randomUUID().toString() + "\">");
            out.println("        <RemoveFolder Id=\"ProgramMenuDir\" On=\"uninstall\" />");
            out.println("         <RegistryValue Root=\"HKCU\" Key=\"Software\\" + this.getVendor() + "\\" + WinAppBundler.getAppName(this.params) + "\" Type=\"string\" Value=\"\" />");
            out.println("      </Component>");
            out.println("    </Directory>");
            out.println(" </Directory>");
        }
        out.println(" </Directory>");
        out.println(" <Feature Id=\"DefaultFeature\" Title=\"Main Feature\" Level=\"1\">");
        for (int j = 0; j < this.compId; ++j) {
            out.println("    <ComponentRef Id=\"comp" + j + "\" />");
        }
        out.println("    <ComponentRef Id=\"CleanupMainApplicationFolder\" />");
        out.println(" </Feature>");
        out.println("</Include>");
        out.close();
        return true;
    }

    private File getConfig_ProjectFile() {
        return new File(this.configRoot, WinAppBundler.getAppName(this.params) + ".wxs");
    }

    private boolean prepareWiXConfig() throws IOException {
        return this.prepareMainProjectFile() && this.prepareContentList();
    }

    private boolean buildMSI(File outdir) throws IOException {
        File tmpDir = new File(this.buildRoot, "tmp");
        File candleOut = new File(tmpDir, WinAppBundler.getAppName(this.params) + ".wixobj");
        File msiOut = new File(outdir, WinAppBundler.getAppName(this.params) + "-" + this.getVersion() + ".msi");
        Log.verbose("Preparing MSI config: " + msiOut.getAbsolutePath());
        msiOut.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_CANDLE, "-nologo", this.getConfig_ProjectFile().getAbsolutePath(), "-ext", "WixUtilExtension", "-out", candleOut.getAbsolutePath());
        pb = pb.directory(this.getImageRootDir());
        IOUtils.exec(pb, this.verbose);
        Log.verbose("Generating MSI: " + msiOut.getAbsolutePath());
        pb = new ProcessBuilder(TOOL_LIGHT, "-nologo", "-spdb", "-sice:60", candleOut.getAbsolutePath(), "-ext", "WixUtilExtension", "-out", msiOut.getAbsolutePath());
        pb = pb.directory(this.getImageRootDir());
        IOUtils.exec(pb, this.verbose);
        candleOut.delete();
        IOUtils.deleteRecursive(tmpDir);
        return true;
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String content = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("version (\\d+.\\d+)");
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String v = matcher.group(1);
                    this.version = new Double(v);
                }
            }
            return this.version;
        }
    }
}

