/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements Stamps.Updater {
    private static Splash splash;
    private static final boolean noBar;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Frame frame;
    private SplashPainter painter;
    private SplashComponent comp;
    private SplashScreen splashScreen;

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame frame, JComponent jComponent) {
        Splash.createAboutDialog(frame, jComponent).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame frame, JComponent jComponent) {
        SplashDialog splashDialog = new SplashDialog(frame, jComponent);
        return splashDialog;
    }

    private void initFrameIcons(Frame frame) {
        frame.setIconImages(Arrays.asList(ImageUtilities.loadImage((String)ICON_16, (boolean)true), ImageUtilities.loadImage((String)ICON_32, (boolean)true), ImageUtilities.loadImage((String)ICON_48, (boolean)true)));
    }

    private Splash() {
        Stamps stamps = Stamps.getModulesJARs();
        if (!CLIOptions.isNoSplash() && !GraphicsEnvironment.isHeadless()) {
            if (!stamps.exists("splash.png")) {
                stamps.scheduleSave((Stamps.Updater)this, "splash.png", false);
            } else {
                try {
                    this.splashScreen = SplashScreen.getSplashScreen();
                    if (this.splashScreen != null) {
                        Graphics2D graphics2D = this.splashScreen.createGraphics();
                        this.painter = new SplashPainter(graphics2D, null, false);
                    }
                }
                catch (RuntimeException runtimeException) {
                    Exceptions.printStackTrace((Throwable)runtimeException);
                }
            }
            if (this.painter == null) {
                this.comp = new SplashComponent(false);
                this.painter = this.comp.painter;
            }
        }
    }

    final int getMaxSteps() {
        return this.painter.maxSteps;
    }

    final int getProgress() {
        return this.painter.progress;
    }

    public void setRunning(boolean bl) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp == null) {
            return;
        }
        if (bl) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, (String)"LBL_splash_window_title"));
                this.initFrameIcons(this.frame);
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                this.frame.setResizable(false);
                int n = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH"));
                int n2 = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(n, n2));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.increment(n);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String string) {
        if (CLIOptions.isNoSplash() || this.painter == null) {
            return;
        }
        this.painter.setText(string);
    }

    public void addToMaxSteps(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.addToMaxSteps(n);
        }
    }

    static final void center(Window window) {
        window.pack();
        window.setBounds(Utilities.findCenterBounds((Dimension)window.getSize()));
    }

    public static Image loadContent(boolean bl) {
        Image image;
        if (bl && (image = ImageUtilities.loadImage((String)"org/netbeans/core/startup/about.png", (boolean)true)) != null) {
            return image;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/core/startup/splash.gif", (boolean)true);
    }

    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)Splash.loadContent(false)), "png", dataOutputStream);
    }

    public void cacheReady() {
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar") || !Boolean.parseBoolean(NbBundle.getMessage(Splash.class, (String)"SplashShowProgressBar"));
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window window, boolean bl) {
            this.splashWindow = window;
            this.visible = bl;
        }

        @Override
        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame frame, JComponent jComponent) {
            super(frame, true);
            JPanel jPanel = new JPanel();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"));
            jPanel.add(this.splashComponent);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"), jPanel);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Detail"), jComponent);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, (String)"ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashPainter {
        Rectangle view;
        Color color_text;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private int size = 12;
        private Rectangle dirty = new Rectangle();
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        private Image image;
        private String text;
        private FontMetrics fm;
        private Graphics graphics;
        private final JComponent comp;
        private final boolean about;
        long next;

        public SplashPainter(Graphics graphics, JComponent jComponent, boolean bl) {
            this.graphics = graphics;
            this.comp = jComponent;
            this.about = bl;
        }

        final void init() throws MissingResourceException, NumberFormatException {
            Object object;
            assert (SwingUtilities.isEventDispatchThread());
            if (this.maxSteps > 0) {
                return;
            }
            this.maxSteps = 140;
            ResourceBundle resourceBundle = NbBundle.getBundle(Splash.class);
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashRunningTextBounds"), " ,");
            this.view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                object = Integer.decode(resourceBundle.getString("SplashRunningTextColor"));
                this.color_text = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color((Integer)object);
            }
            catch (NumberFormatException numberFormatException) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, numberFormatException);
                this.color_text = Color.BLACK;
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            try {
                object = resourceBundle.getString("SplashRunningTextFontSize");
                this.size = Integer.parseInt((String)object);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.image = Splash.loadContent(this.about);
            object = new Font("Dialog", 0, this.size);
            if (this.comp != null) {
                this.comp.setFont((Font)object);
                this.fm = this.comp.getFontMetrics((Font)object);
            } else {
                this.graphics.setFont((Font)object);
                this.fm = this.graphics.getFontMetrics((Font)object);
            }
        }

        final void repaint(Rectangle rectangle) {
            if (this.comp != null) {
                this.comp.repaint(rectangle);
            } else if (this.next < System.currentTimeMillis()) {
                this.paint();
                try {
                    Splash splash = splash;
                    if (splash != null) {
                        splash.splashScreen.update();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.next = System.currentTimeMillis() + 200L;
            }
        }

        public void setText(final String string) {
            if (string != null && string.equals(this.text)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplashPainter.this.init();
                    if (string == null) {
                        SplashPainter.this.repaint(SplashPainter.this.dirty);
                        return;
                    }
                    if (SplashPainter.this.fm == null) {
                        return;
                    }
                    SplashPainter.this.adjustText(string);
                    SwingUtilities.layoutCompoundLabel(SplashPainter.this.fm, string, null, 3, 2, 3, 2, SplashPainter.this.view, new Rectangle(), SplashPainter.this.rect, 0);
                    SplashPainter.this.dirty = SplashPainter.this.dirty.union(SplashPainter.this.rect);
                    SplashPainter.this.repaint(SplashPainter.this.dirty);
                    SplashPainter.this.dirty = new Rectangle(SplashPainter.this.rect);
                }
            });
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int n = this.fm.stringWidth(string);
            if (n > this.view.width) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string2 == null ? string4 : string2 + " " + string4;
                    if (this.fm.stringWidth(string3 + "...") > this.view.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string3;
                }
                if (string2 == null) {
                    this.text = "";
                    string3 = "";
                    string2 = "";
                    for (int i = 0; i < string.length(); ++i) {
                        if (this.fm.stringWidth((string3 = string3 + string.charAt(i)) + "...") > this.view.width) {
                            this.text = string2 + "...";
                            break;
                        }
                        string2 = string3;
                    }
                }
            } else {
                this.text = string;
            }
        }

        public void increment(int n) {
            int n2;
            if (n <= 0) {
                return;
            }
            this.progress += n;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((n2 = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = n2;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplashPainter.this.init();
                        SplashPainter.this.repaint(SplashPainter.this.bar_inc);
                    }
                });
            }
        }

        final void addToMaxSteps(int n) {
            if (n == 0) {
                return;
            }
            if (this.maxSteps == 0) {
                int n2 = this.progress / n;
                this.maxSteps = n;
                this.progress = n2;
            } else {
                int n3 = this.maxSteps + n;
                int n4 = this.progress * n3 / this.maxSteps;
                this.maxSteps = n3;
                this.progress = n4;
            }
        }

        void paint() {
            this.graphics.setColor(this.color_text);
            this.graphics.drawImage(this.image, 0, 0, null);
            if (this.text != null) {
                if (this.fm == null) {
                    return;
                }
                SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
                Graphics2D graphics2D = (Graphics2D)this.graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this.graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            }
            if (!noBar && this.maxSteps > 0) {
                this.graphics.setColor(this.color_bar);
                this.graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                this.graphics.setColor(this.color_corner);
                this.graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                this.graphics.setColor(this.color_edge);
                this.graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        final SplashPainter painter;

        public SplashComponent(boolean bl) {
            this.painter = new SplashPainter((Graphics2D)this.getGraphics(), this, bl);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            this.painter.graphics = graphics;
            this.painter.paint();
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public String toString() {
            return "SplashComponent - progress: " + this.painter.progress + "/" + this.painter.maxSteps + " text: " + this.painter.text;
        }
    }
}

