/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.canvas;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.charts.canvas.BufferedCanvasComponent;

public abstract class TransformableCanvasComponent
extends BufferedCanvasComponent {
    private static final float SHIFT_ACCEL_LIMIT = 0.15f;
    private static final float DIAGONAL_SHIFT_ACCEL_LIMIT = 0.3f;
    private Insets viewInsets = new Insets(0, 0, 0, 0);
    private long dataOffsetX;
    private long pendingDataOffsetX;
    private long dataOffsetY;
    private long pendingDataOffsetY;
    private long dataWidth;
    private long pendingDataWidth;
    private long dataHeight;
    private long pendingDataHeight;
    private long contentsOffsetX;
    private long contentsOffsetY;
    private long contentsWidth;
    private long contentsHeight;
    private double scaleX = 1.0;
    private double lastScaleX;
    private double oldScaleX;
    private double scaleY = 1.0;
    private double lastScaleY;
    private double oldScaleY;
    private long offsetX;
    private long maxOffsetX;
    private long lastOffsetX;
    private long offsetY;
    private long maxOffsetY;
    private long lastOffsetY;
    private boolean rightBased;
    private boolean bottomBased;
    private boolean tracksDataOffsetX = true;
    private boolean tracksDataOffsetY;
    private boolean tracksDataWidth = true;
    private boolean tracksDataHeight;
    private boolean fitsWidth;
    private boolean fitsHeight;
    private long dx = 0L;
    private long dy = 0L;
    private int hOffsetAdjustingCounter = 0;
    private int vOffsetAdjustingCounter = 0;

    protected abstract void paintContents(Graphics var1, Rectangle var2);

    protected void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
    }

    protected void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
    }

    public final void setViewInsets(Insets insets) {
        this.viewInsets.set(insets.top, insets.left, insets.bottom, insets.right);
    }

    public final Insets getViewInsets() {
        return new Insets(this.viewInsets.top, this.viewInsets.left, this.viewInsets.bottom, this.viewInsets.right);
    }

    public final void setRightBased(boolean bl) {
        this.rightBased = bl;
    }

    public final boolean isRightBased() {
        return this.rightBased;
    }

    public final void setBottomBased(boolean bl) {
        this.bottomBased = bl;
    }

    public final boolean isBottomBased() {
        return this.bottomBased;
    }

    public final void setTracksDataOffsetX(boolean bl) {
        this.tracksDataOffsetX = bl;
    }

    public final boolean tracksDataOffsetX() {
        return this.tracksDataOffsetX;
    }

    public final void setTracksDataOffsetY(boolean bl) {
        this.tracksDataOffsetY = bl;
    }

    public final boolean tracksDataOffsetY() {
        return this.tracksDataOffsetY;
    }

    public final void setTracksDataWidth(boolean bl) {
        this.tracksDataWidth = bl;
    }

    public final boolean tracksDataWidth() {
        return this.tracksDataWidth;
    }

    public final boolean currentlyFollowingDataWidth() {
        return this.tracksDataWidth && !this.fitsWidth && this.offsetX == this.maxOffsetX;
    }

    public final void setTracksDataHeight(boolean bl) {
        this.tracksDataHeight = bl;
    }

    public final boolean tracksDataHeight() {
        return this.tracksDataHeight;
    }

    public final boolean currentlyFollowingDataHeight() {
        return this.tracksDataHeight && !this.fitsHeight && this.offsetY == this.maxOffsetY;
    }

    public final void setFitsWidth(boolean bl) {
        if (this.fitsWidth == bl) {
            return;
        }
        this.fitsWidth = bl;
        if (bl) {
            this.updateScale();
        } else {
            this.updateContentsWidths();
            this.updateMaxOffsets();
        }
    }

    public final boolean fitsWidth() {
        return this.fitsWidth;
    }

    public final void setFitsHeight(boolean bl) {
        if (this.fitsHeight == bl) {
            return;
        }
        this.fitsHeight = bl;
        if (bl) {
            this.updateScale();
        } else {
            this.updateContentsWidths();
            this.updateMaxOffsets();
        }
    }

    public final boolean fitsHeight() {
        return this.fitsHeight;
    }

    public final long getOffsetX() {
        return this.offsetX;
    }

    protected final long getMaxOffsetX() {
        return this.maxOffsetX;
    }

    public final long getOffsetY() {
        return this.offsetY;
    }

    protected final long getMaxOffsetY() {
        return this.maxOffsetY;
    }

    public final void setOffset(long l, long l2) {
        l = Math.max(Math.min(l, this.maxOffsetX), 0L);
        l2 = Math.max(Math.min(l2, this.maxOffsetY), 0L);
        if (this.offsetX == l && this.offsetY == l2) {
            return;
        }
        long l3 = this.offsetX;
        long l4 = this.offsetY;
        this.dx += this.offsetX - l;
        this.offsetX = l;
        this.dy += this.offsetY - l2;
        this.offsetY = l2;
        this.offsetChanged(l3, l4, l, l2);
    }

    protected void offsetChanged(long l, long l2, long l3, long l4) {
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final void setScale(double d, double d2) {
        if (this.scaleX == d && this.scaleY == d2) {
            return;
        }
        double d3 = this.scaleX;
        double d4 = this.scaleY;
        this.scaleX = d;
        this.scaleY = d2;
        this.updateContentsWidths();
        this.updateMaxOffsets();
        this.setOffset(this.offsetX, this.offsetY);
        this.scaleChanged(d3, d4, d, d2);
        this.invalidateImage();
    }

    protected void scaleChanged(double d, double d2, double d3, double d4) {
    }

    public final long getDataOffsetX() {
        return this.dataOffsetX;
    }

    public final long getDataOffsetY() {
        return this.dataOffsetY;
    }

    public final long getDataWidth() {
        return this.dataWidth;
    }

    public final long getDataHeight() {
        return this.dataHeight;
    }

    public final long getContentsWidth() {
        return this.contentsWidth;
    }

    public final long getContentsHeight() {
        return this.contentsHeight;
    }

    public final void setDataBounds(long l, long l2, long l3, long l4) {
        if (this.dataOffsetX == l && this.dataOffsetY == l2 && this.dataWidth == l3 && this.dataHeight == l4) {
            return;
        }
        if (this.isHOffsetAdjusting() && this.contentsWidth >= (long)this.getWidth() && this.dataWidth != l3 || this.isVOffsetAdjusting() && this.contentsHeight >= (long)this.getHeight() && this.dataHeight != l4) {
            this.pendingDataOffsetX = l;
            this.pendingDataOffsetY = l2;
            this.pendingDataWidth = l3;
            this.pendingDataHeight = l4;
        } else {
            long l5 = this.offsetX;
            long l6 = this.offsetY;
            long l7 = this.contentsOffsetX;
            long l8 = this.contentsOffsetY;
            long l9 = this.maxOffsetX;
            long l10 = this.maxOffsetY;
            long l11 = this.dataOffsetX;
            long l12 = this.dataOffsetY;
            long l13 = this.dataWidth;
            long l14 = this.dataHeight;
            this.dataOffsetX = l;
            this.dataOffsetY = l2;
            this.dataWidth = l3;
            this.dataHeight = l4;
            this.contentsOffsetX = (long)Math.ceil(this.getViewWidth(l));
            this.contentsOffsetY = (long)Math.ceil(this.getViewHeight(l2));
            this.updateScale();
            this.updateContentsWidths();
            this.updateMaxOffsets();
            long l15 = this.offsetX;
            long l16 = this.offsetY;
            if (!this.fitsWidth) {
                if (this.tracksDataWidth && this.offsetX == l9) {
                    l15 = this.maxOffsetX;
                } else if (!(this.oldScaleX != this.scaleX || this.tracksDataOffsetX && this.offsetX == 0L)) {
                    l15 = this.offsetX + l7 - this.contentsOffsetX;
                }
            }
            if (!this.fitsHeight) {
                if (this.tracksDataHeight && this.offsetY == l10) {
                    l16 = this.maxOffsetY;
                } else if (!(this.oldScaleY != this.scaleY || this.tracksDataOffsetY && this.offsetY == 0L)) {
                    l16 = this.offsetY + l8 - this.contentsOffsetY;
                }
            }
            long l17 = this.dx;
            long l18 = this.dy;
            this.setOffset(l15, l16);
            this.dataBoundsChanged(l, l2, l3, l4, l11, l12, l13, l14);
            this.dx = l17 + (l7 - this.contentsOffsetX) - (this.offsetX - l5);
            this.dy = l18 + (l8 - this.contentsOffsetY) - (this.offsetY - l6);
            this.oldScaleX = this.scaleX;
            this.oldScaleY = this.scaleY;
            this.pendingDataOffsetX = -1L;
            this.pendingDataOffsetY = -1L;
            this.pendingDataWidth = -1L;
            this.pendingDataHeight = -1L;
        }
    }

    protected void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
    }

    protected final void offsetAdjustingStarted() {
        ++this.hOffsetAdjustingCounter;
        ++this.vOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void offsetAdjustingFinished() {
        --this.hOffsetAdjustingCounter;
        --this.vOffsetAdjustingCounter;
        if (!(this.isOffsetAdjusting() || this.pendingDataWidth == -1L && this.pendingDataHeight == -1L)) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isOffsetAdjusting() {
        return this.isHOffsetAdjusting() || this.isVOffsetAdjusting();
    }

    protected final void hOffsetAdjustingStarted() {
        ++this.hOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void hOffsetAdjustingFinished() {
        --this.hOffsetAdjustingCounter;
        if (!this.isOffsetAdjusting() && this.pendingDataWidth != -1L) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isHOffsetAdjusting() {
        return this.hOffsetAdjustingCounter > 0;
    }

    protected final void vOffsetAdjustingStarted() {
        ++this.vOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void vOffsetAdjustingFinished() {
        --this.vOffsetAdjustingCounter;
        if (!this.isOffsetAdjusting() && this.pendingDataHeight != -1L) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isVOffsetAdjusting() {
        return this.vOffsetAdjustingCounter > 0;
    }

    protected final double getViewX(double d) {
        return this.getViewX(d, false);
    }

    protected final double getReversedViewX(double d) {
        return this.getViewX(d, true);
    }

    private double getViewX(double d, boolean bl) {
        if (this.rightBased && !bl || !this.rightBased && bl) {
            return ((double)this.dataOffsetX - d) * this.scaleX + (double)this.offsetX + (double)this.getWidth() - (double)this.viewInsets.right;
        }
        return (d - (double)this.dataOffsetX) * this.scaleX - (double)this.offsetX + (double)this.viewInsets.left;
    }

    protected final double getViewY(double d) {
        return this.getViewY(d, false);
    }

    protected final double getReversedViewY(double d) {
        return this.getViewY(d, true);
    }

    private double getViewY(double d, boolean bl) {
        if (this.bottomBased && !bl || !this.bottomBased && bl) {
            return ((double)this.dataOffsetY - d) * this.scaleY + (double)this.offsetY + (double)this.getHeight() - (double)this.viewInsets.bottom;
        }
        return (d - (double)this.dataOffsetY) * this.scaleY - (double)this.offsetY + (double)this.viewInsets.top;
    }

    protected final double getViewWidth(double d) {
        return d * this.scaleX;
    }

    protected final double getViewHeight(double d) {
        return d * this.scaleY;
    }

    protected final double getDataX(double d) {
        return this.getDataX(d, false);
    }

    protected final double getReversedDataX(double d) {
        return this.getDataX(d, true);
    }

    private double getDataX(double d, boolean bl) {
        if (this.rightBased && !bl || !this.rightBased && bl) {
            return (double)this.dataOffsetX - (d + (double)this.viewInsets.right - (double)this.offsetX - (double)this.getWidth()) / this.scaleX;
        }
        return (d + (double)this.offsetX - (double)this.viewInsets.left) / this.scaleX + (double)this.dataOffsetX;
    }

    protected final double getDataY(double d) {
        return this.getDataY(d, false);
    }

    protected final double getReversedDataY(double d) {
        return this.getDataY(d, true);
    }

    private double getDataY(double d, boolean bl) {
        if (this.bottomBased && !bl || !this.bottomBased && bl) {
            return (double)this.dataOffsetY - (d + (double)this.viewInsets.bottom - (double)this.offsetY - (double)this.getHeight()) / this.scaleY;
        }
        return (d + (double)this.offsetY - (double)this.viewInsets.top) / this.scaleY + (double)this.dataOffsetY;
    }

    protected final double getDataWidth(double d) {
        return d / this.scaleX;
    }

    protected final double getDataHeight(double d) {
        return d / this.scaleY;
    }

    @Override
    boolean isDirty() {
        if (this.translationPending()) {
            return true;
        }
        return super.isDirty();
    }

    private boolean translationPending() {
        if (this.lastScaleX != this.scaleX || this.lastScaleY != this.scaleY) {
            return false;
        }
        return this.dx != 0L || this.dy != 0L;
    }

    @Override
    protected void reshaped(Rectangle rectangle, Rectangle rectangle2) {
        super.reshaped(rectangle, rectangle2);
        boolean bl = this.currentlyFollowingDataWidth();
        boolean bl2 = this.currentlyFollowingDataHeight();
        this.updateScale();
        this.updateContentsWidths();
        this.updateMaxOffsets();
        this.setOffset(bl ? this.maxOffsetX : this.offsetX, bl2 ? this.maxOffsetY : this.offsetY);
    }

    @Override
    protected final void paintComponent(Graphics graphics, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        this.contentsWillBeUpdated(this.offsetX, this.offsetY, this.scaleX, this.scaleY, this.lastOffsetX, this.lastOffsetY, this.lastScaleX, this.lastScaleY);
        if (!this.translationPending()) {
            this.paintContents(graphics, rectangle);
        } else {
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            if (Math.abs(this.dx) >= (long)n3 || Math.abs(this.dy) >= (long)n4) {
                this.paintContents(graphics, new Rectangle(0, 0, n3, n4));
            } else {
                int n5 = this.rightBased ? -((int)this.dx) : (int)this.dx;
                int n6 = this.bottomBased ? -((int)this.dy) : (int)this.dy;
                int n7 = n3 * n4;
                int n8 = (n3 - Math.abs(n5)) * (n4 - Math.abs(n6));
                if (n5 != 0 && n6 != 0 && (float)n8 < (float)n7 * 0.3f) {
                    this.paintContents(graphics, new Rectangle(0, 0, n3, n4));
                } else {
                    Rectangle rectangle2 = new Rectangle(n5, n6, n3, n4);
                    Rectangle rectangle3 = rectangle2.intersection(new Rectangle(0, 0, n3, n4));
                    Rectangle rectangle4 = rectangle.intersection(rectangle3);
                    int n9 = rectangle4.isEmpty() ? 0 : rectangle4.width * rectangle4.height;
                    int n10 = n8 - n9;
                    if ((float)n10 < (float)n7 * 0.15f) {
                        this.paintContents(graphics, new Rectangle(0, 0, n3, n4));
                    } else {
                        this.shift(graphics, n5, n6, n3, n4);
                        if (n9 != 0) {
                            this.paintContents(graphics, rectangle4);
                        }
                        n = n5;
                        n2 = n6;
                    }
                }
            }
        }
        this.contentsUpdated(this.offsetX, this.offsetY, this.scaleX, this.scaleY, this.lastOffsetX, this.lastOffsetY, this.lastScaleX, this.lastScaleY, n, n2);
        this.dx = 0L;
        this.dy = 0L;
        this.lastOffsetX = this.offsetX;
        this.lastOffsetY = this.offsetY;
        this.lastScaleX = this.scaleX;
        this.lastScaleY = this.scaleY;
    }

    private void shift(Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        if (n == 0) {
            if (n2 > 0) {
                graphics.copyArea(0, 0, n3, n4 - n2, 0, n2);
                rectangle.setBounds(0, 0, n3, n2);
            } else {
                graphics.copyArea(0, -n2, n3, n4 + n2, 0, n2);
                rectangle.setBounds(0, n4 + n2, n3, -n2);
            }
        } else if (n2 == 0) {
            if (n > 0) {
                graphics.copyArea(0, 0, n3 - n, n4, n, 0);
                rectangle.setBounds(0, 0, n, n4);
            } else {
                graphics.copyArea(-n, 0, n3 + n, n4, n, 0);
                rectangle.setBounds(n3 + n, 0, -n, n4);
            }
        } else if (n > 0) {
            if (n2 > 0) {
                graphics.copyArea(0, 0, n3 - n, n4 - n2, n, n2);
                rectangle.setBounds(0, 0, n3, n2);
                this.paintContents(graphics, rectangle);
                rectangle.setBounds(0, n2, n, n4 - n2);
            } else {
                graphics.copyArea(0, -n2, n3 - n, n4 + n2, n, n2);
                rectangle.setBounds(0, n4 + n2, n3, -n2);
                this.paintContents(graphics, rectangle);
                rectangle.setBounds(0, 0, n, n4 + n2);
            }
        } else if (n2 > 0) {
            graphics.copyArea(-n, 0, n3 + n, n4 - n2, n, n2);
            rectangle.setBounds(0, 0, n3, n2);
            this.paintContents(graphics, rectangle);
            rectangle.setBounds(n3 + n, n2, -n, n4 - n2);
        } else {
            graphics.copyArea(-n, -n2, n3 + n, n4 + n2, n, n2);
            rectangle.setBounds(0, n4 + n2, n3, -n2);
            this.paintContents(graphics, rectangle);
            rectangle.setBounds(n3 + n, 0, -n, n4 + n2);
        }
        this.paintContents(graphics, rectangle);
    }

    private void updateScale() {
        if (!this.fitsWidth && !this.fitsHeight) {
            return;
        }
        double d = this.fitsWidth ? (double)(this.getWidth() - this.viewInsets.left - this.viewInsets.right) / (double)this.dataWidth : this.scaleX;
        double d2 = this.fitsHeight ? (double)(this.getHeight() - this.viewInsets.top - this.viewInsets.bottom) / (double)this.dataHeight : this.scaleY;
        this.setScale(d, d2);
    }

    private void updateContentsWidths() {
        this.contentsWidth = this.fitsWidth ? (long)this.getWidth() : (long)Math.floor(this.getViewWidth(this.dataWidth)) + (long)this.viewInsets.left + (long)this.viewInsets.right;
        this.contentsHeight = this.fitsHeight ? (long)this.getHeight() : (long)Math.floor(this.getViewHeight(this.dataHeight)) + (long)this.viewInsets.top + (long)this.viewInsets.bottom;
    }

    private void updateMaxOffsets() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.maxOffsetX = n == 0 ? 0L : Math.max(this.contentsWidth - (long)n, 0L);
        this.maxOffsetY = n2 == 0 ? 0L : Math.max(this.contentsHeight - (long)n2, 0L);
    }
}

