/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.ui.components.table.CustomSortableHeaderRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class SortableTableModel
extends AbstractTableModel {
    public static final boolean SORT_ORDER_DESC = false;
    public static final boolean SORT_ORDER_ASC = true;
    private CustomSortableHeaderRenderer headerRenderer;
    private HeaderListener headerListener;
    private ImageIcon sortAscIcon = Icons.getImageIcon((String)"GeneralIcons.SortAscending");
    private ImageIcon sortDescIcon = Icons.getImageIcon((String)"GeneralIcons.SortDescending");
    private JTableHeader tableHeader;
    private int lastFocusedColumn = -1;

    public SortableTableModel() {
        this.headerListener = new HeaderListener();
        this.headerRenderer = new CustomSortableHeaderRenderer(this.sortAscIcon, this.sortDescIcon);
    }

    public void setInitialSorting(int n, boolean bl) {
        if (this.headerRenderer != null) {
            this.headerRenderer.setSortingColumn(n);
            this.headerRenderer.setSortingOrder(bl);
        }
    }

    public abstract boolean getInitialSorting(int var1);

    public int getSortingColumn() {
        return this.headerRenderer.getSortingColumn();
    }

    public boolean getSortingOrder() {
        return this.headerRenderer.getSortingOrder();
    }

    public void setTable(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(this.headerRenderer);
        }
        if (this.tableHeader != jTable.getTableHeader()) {
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseListener(this.headerListener);
                this.tableHeader.removeMouseMotionListener(this.headerListener);
                this.lastFocusedColumn = -1;
            }
            this.tableHeader = jTable.getTableHeader();
            this.tableHeader.setReorderingAllowed(false);
            this.tableHeader.addMouseListener(this.headerListener);
            this.tableHeader.addMouseMotionListener(this.headerListener);
        }
    }

    public abstract void sortByColumn(int var1, boolean var2);

    public String getColumnToolTipText(int n) {
        return null;
    }

    private class HeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                int n;
                int n2 = SortableTableModel.this.tableHeader.columnAtPoint(mouseEvent.getPoint());
                if (n2 == (n = SortableTableModel.this.headerRenderer.getSortingColumn())) {
                    SortableTableModel.this.headerRenderer.reverseSortingOrder();
                } else {
                    SortableTableModel.this.headerRenderer.setSortingColumn(n2);
                    if (SortableTableModel.this.getInitialSorting(n2)) {
                        SortableTableModel.this.headerRenderer.setSortingOrder(true);
                    } else {
                        SortableTableModel.this.headerRenderer.setSortingOrder(false);
                    }
                }
                SortableTableModel.this.tableHeader.repaint();
                SortableTableModel.this.sortByColumn(n2, SortableTableModel.this.headerRenderer.getSortingOrder());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = SortableTableModel.this.tableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n != SortableTableModel.this.lastFocusedColumn && n != -1) {
                SortableTableModel.this.tableHeader.setToolTipText(SortableTableModel.this.getColumnToolTipText(n));
                SortableTableModel.this.lastFocusedColumn = n;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && SortableTableModel.this.tableHeader.getResizingColumn() == null) {
                SortableTableModel.this.headerRenderer.setPressedColumn(SortableTableModel.this.tableHeader.columnAtPoint(mouseEvent.getPoint()));
                SortableTableModel.this.tableHeader.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                SortableTableModel.this.headerRenderer.setPressedColumn(-1);
                SortableTableModel.this.tableHeader.repaint();
            }
        }
    }
}

