/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.JExtendedTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class JCheckTree
extends JExtendedTree {
    private PrivateComponentListener componentListener = new PrivateComponentListener();
    private Collection<CheckTreeListener> checkTreeListeners = new CopyOnWriteArraySet<CheckTreeListener>();

    public JCheckTree() {
        if (!UIUtils.isGTKLookAndFeel()) {
            this.setUI(new CheckTreeUI());
        }
        this.setCellRenderer(new CheckTreeCellRenderer());
        this.setModel(JCheckTree.getDefaultTreeModel());
        this.addMouseListener(this.componentListener);
        this.addKeyListener(this.componentListener);
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        if (this.getCellRenderer() instanceof TreeCellRendererPersistent) {
            return new Point(this.rendererRect.getLocation().x + CheckTreeCellRenderer.getCheckBoxDimension().width - 1, this.rendererRect.getLocation().y - 1);
        }
        return super.getCellTipLocation();
    }

    public void addCheckTreeListener(CheckTreeListener checkTreeListener) {
        if (checkTreeListener != null) {
            this.checkTreeListeners.add(checkTreeListener);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JCheckTreeTester");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JCheckTree jCheckTree = new JCheckTree();
        jCheckTree.addCheckTreeListener(new CheckTreeListener(){

            public void checkTreeChanged(Collection collection) {
                System.out.println(collection);
            }

            @Override
            public void checkNodeToggled(TreePath treePath, boolean bl) {
                System.out.println("Node toggled");
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(new JScrollPane(jCheckTree));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseWheelEvent) {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                container = this;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)mouseEvent, container);
            container.dispatchEvent((MouseWheelEvent)mouseEvent2);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void removeCheckTreeListener(CheckTreeListener checkTreeListener) {
        this.checkTreeListeners.remove(checkTreeListener);
    }

    protected static TreeModel getDefaultTreeModel() {
        CheckTreeNode checkTreeNode = new CheckTreeNode("JTree");
        CheckTreeNode checkTreeNode2 = new CheckTreeNode("colors");
        checkTreeNode.add(checkTreeNode2);
        checkTreeNode2.add(new CheckTreeNode("blue"));
        checkTreeNode2.add(new CheckTreeNode("violet"));
        checkTreeNode2.add(new CheckTreeNode("red"));
        checkTreeNode2.add(new CheckTreeNode("yellow"));
        checkTreeNode2 = new CheckTreeNode("sports");
        checkTreeNode.add(checkTreeNode2);
        checkTreeNode2.add(new CheckTreeNode("basketball"));
        checkTreeNode2.add(new CheckTreeNode("soccer"));
        checkTreeNode2.add(new CheckTreeNode("football"));
        checkTreeNode2.add(new CheckTreeNode("hockey"));
        checkTreeNode2 = new CheckTreeNode("food");
        checkTreeNode.add(checkTreeNode2);
        checkTreeNode2.add(new CheckTreeNode("hot dogs"));
        checkTreeNode2.add(new CheckTreeNode("pizza"));
        checkTreeNode2.add(new CheckTreeNode("ravioli"));
        checkTreeNode2.add(new CheckTreeNode("bananas"));
        return new DefaultTreeModel(checkTreeNode);
    }

    @Override
    protected void processCellTipMouseMove(MouseEvent mouseEvent) {
        TreePath treePath = null;
        try {
            treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (treePath == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            this.lastTreePath = treePath;
            return;
        }
        int n = this.getRowForPath(this.lastTreePath);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof TreeCellRendererPersistent)) {
            return;
        }
        Component component = treeCellRenderer.getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, this.isExpanded(n), this.getModel().isLeaf(treePath.getLastPathComponent()), n, false);
        Component component2 = ((TreeCellRendererPersistent)treeCellRenderer).getTreeCellRendererComponentPersistent(this, treePath.getLastPathComponent(), false, this.isExpanded(n), this.getModel().isLeaf(treePath.getLastPathComponent()), n, false);
        if (component == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            this.lastTreePath = treePath;
            return;
        }
        Point point = this.getPathBounds(treePath).getLocation();
        this.rendererRect = new Rectangle(point.x, point.y, component.getPreferredSize().width, component.getPreferredSize().height + 2);
        if (mouseEvent.getX() <= this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width) {
            this.lastTreePath = new TreePath(new Object());
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        if (treePath == this.lastTreePath) {
            return;
        }
        this.lastTreePath = treePath;
        if (!this.rendererRect.contains(mouseEvent.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        if (this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width >= rectangle.x && this.rendererRect.x + this.rendererRect.width <= rectangle.x + rectangle.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(component2, "Center");
        this.cellTip.setPreferredSize(new Dimension(component2.getPreferredSize().width + 2, this.getRowHeight() + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    protected boolean shouldShowCellTipAt(Point point) {
        if (this.rendererRect == null) {
            return false;
        }
        return point.x > this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width;
    }

    private boolean isOverCheckBox(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        return treePath != null && treePath.getPathCount() != 0 && treePath.getLastPathComponent() instanceof CheckTreeNode && n <= this.getPathBounds((TreePath)treePath).x + CheckTreeCellRenderer.getCheckBoxDimension().width;
    }

    private void fireCheckTreeChanged(Collection collection) {
        if (collection.size() > 0) {
            for (CheckTreeListener checkTreeListener : this.checkTreeListeners) {
                checkTreeListener.checkTreeChanged(collection);
            }
        }
    }

    private void fireNodeToggled(TreePath treePath, boolean bl) {
        for (CheckTreeListener checkTreeListener : this.checkTreeListeners) {
            checkTreeListener.checkNodeToggled(treePath, bl);
        }
    }

    private Collection togglePathState(TreePath treePath) {
        return ((CheckTreeNode)treePath.getLastPathComponent()).toggleState();
    }

    private class PrivateComponentListener
    implements MouseListener,
    KeyListener {
        private PrivateComponentListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            TreePath[] treePathArray;
            if (keyEvent.getKeyCode() == 32 && (treePathArray = JCheckTree.this.getSelectionPaths()) != null && treePathArray.length > 0) {
                LinkedList linkedList = new LinkedList();
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    if (treePath != null && treePath.getPathCount() > 0 && treePath.getLastPathComponent() instanceof CheckTreeNode && (((CheckTreeNode)treePath.getLastPathComponent()).isLeaf() || i == treePathArray.length - 1)) {
                        JCheckTree.this.fireNodeToggled(treePath, true);
                    }
                    linkedList.addAll(JCheckTree.this.togglePathState(treePath));
                    JCheckTree.this.fireNodeToggled(treePath, false);
                }
                JCheckTree.this.treeDidChange();
                JCheckTree.this.fireCheckTreeChanged(linkedList);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (JCheckTree.this.isOverCheckBox(mouseEvent.getX(), mouseEvent.getY())) {
                TreePath treePath = JCheckTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                JCheckTree.this.fireNodeToggled(treePath, true);
                Collection collection = JCheckTree.this.togglePathState(JCheckTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
                JCheckTree.this.treeDidChange();
                JCheckTree.this.fireNodeToggled(treePath, false);
                JCheckTree.this.fireCheckTreeChanged(collection);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class CheckTreeUI
    extends BasicTreeUI {
        private CheckTreeUI() {
        }

        @Override
        protected boolean isToggleEvent(MouseEvent mouseEvent) {
            if (JCheckTree.this.isOverCheckBox(mouseEvent.getX(), mouseEvent.getY())) {
                return false;
            }
            return super.isToggleEvent(mouseEvent);
        }
    }

    public static interface CheckTreeListener {
        public void checkNodeToggled(TreePath var1, boolean var2);

        public void checkTreeChanged(Collection<CheckTreeNode> var1);
    }
}

