/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.impl;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.HostsSupport;
import com.sun.tools.visualvm.jmx.CredentialsProvider;
import com.sun.tools.visualvm.jmx.EnvironmentProvider;
import com.sun.tools.visualvm.jmx.JmxApplicationException;
import com.sun.tools.visualvm.jmx.JmxApplicationsSupport;
import com.sun.tools.visualvm.jmx.impl.JmxApplication;
import com.sun.tools.visualvm.jmx.impl.JmxConnectionSupportImpl;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxApplicationProvider {
    private static final Logger LOGGER = Logger.getLogger(JmxApplicationProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.1";
    private static final String PROPERTY_CONNECTION_STRING = "prop_conn_string";
    private static final String PROPERTY_HOSTNAME = "prop_conn_hostname";
    private static final String PROPERTY_ENV_PROVIDER_ID = "prop_env_provider_id";
    private static final String PROPERTIES_FILE = "jmxapplication.properties";
    static final String JMX_SUFFIX = ".jmx";
    private boolean trackingNewHosts;
    private Map<String, Set<Storage>> persistedApplications = new HashMap<String, Set<Storage>>();

    private static boolean isLocalHost(String hostname) throws IOException {
        InetAddress remoteAddr = InetAddress.getByName(hostname);
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress localAddr = addrs.nextElement();
                if (!localAddr.equals(remoteAddr)) continue;
                return true;
            }
        }
        return false;
    }

    private Host getHost(String hostname, JMXServiceURL url) throws IOException {
        if (hostname != null) {
            if (hostname.isEmpty() || JmxApplicationProvider.isLocalHost(hostname)) {
                return Host.LOCALHOST;
            }
            return HostsSupport.getInstance().getOrCreateHost(hostname, false);
        }
        return Host.UNKNOWN_HOST;
    }

    public static String getConnectionString(JmxApplication application) {
        return application.getStorage().getCustomProperty(PROPERTY_CONNECTION_STRING);
    }

    public static String getSuggestedName(String displayName, String connectionString, String username) {
        if (displayName != null) {
            return displayName;
        }
        if (username == null) {
            username = "";
        }
        return (username.isEmpty() ? "" : username + "@") + connectionString;
    }

    public JmxApplication createJmxApplication(String connectionString, String displayName, String suggestedName, EnvironmentProvider provider, boolean persistent) throws JmxApplicationException {
        JMXServiceURL serviceURL;
        String normalizedConnectionName = this.normalizeConnectionName(connectionString);
        try {
            serviceURL = this.getServiceURL(normalizedConnectionName);
        }
        catch (MalformedURLException ex) {
            throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)normalizedConnectionName), ex);
        }
        String hostName = this.getHostName(serviceURL);
        hostName = hostName == null ? "" : hostName;
        Storage storage = null;
        if (persistent) {
            File storageDirectory = Utils.getUniqueFile((File)JmxApplicationsSupport.getStorageDirectory(), (String)("" + System.currentTimeMillis()), (String)JMX_SUFFIX);
            Utils.prepareDirectory((File)storageDirectory);
            storage = new Storage(storageDirectory, PROPERTIES_FILE);
            storage.setCustomProperty(SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        }
        return this.addJmxApplication(true, serviceURL, normalizedConnectionName, displayName, suggestedName, hostName, provider, storage);
    }

    private JmxApplication addJmxApplication(boolean newApp, JMXServiceURL serviceURL, String connectionName, String displayName, String suggestedName, String hostName, EnvironmentProvider provider, Storage storage) throws JmxApplicationException {
        Set jmxapps;
        if (serviceURL == null) {
            try {
                serviceURL = this.getServiceURL(connectionName);
            }
            catch (MalformedURLException ex) {
                File appStorage;
                if (storage != null && (appStorage = storage.getDirectory()).isDirectory()) {
                    Utils.delete((File)appStorage, (boolean)true);
                }
                throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)connectionName), ex);
            }
        }
        Set hosts = DataSourceRepository.sharedInstance().getDataSources(Host.class);
        Host host = null;
        try {
            host = this.getHost(hostName, serviceURL);
        }
        catch (Exception e) {
            File appStorage;
            if (storage != null && (appStorage = storage.getDirectory()).isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            this.cleanupCreatedHost(hosts, host);
            throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Cannot_resolve_host", (Object)hostName), e);
        }
        if (storage != null) {
            if (newApp) {
                storage.setCustomProperty(PROPERTY_HOSTNAME, host.getHostName());
                if (provider != null) {
                    storage.setCustomProperty(PROPERTY_ENV_PROVIDER_ID, provider.getId());
                    provider.saveEnvironment(storage);
                }
            } else if (provider != null) {
                provider.loadEnvironment(storage);
            }
        }
        final JmxApplication application = new JmxApplication(host, serviceURL, provider, storage);
        if (newApp) {
            Storage s = application.getStorage();
            String[] keys = new String[]{PROPERTY_CONNECTION_STRING, displayName != null ? "prop_name" : "prop_suggested_name"};
            String[] values = new String[]{connectionName, displayName != null ? displayName : suggestedName};
            s.setCustomProperties(keys, values);
            if (provider != null) {
                provider.saveEnvironment(s);
            }
        }
        if ((jmxapps = host.getRepository().getDataSources(JmxApplication.class)).contains((Object)application)) {
            File appStorage;
            if (storage != null && (appStorage = storage.getDirectory()).isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            JmxApplication tempapp = null;
            for (JmxApplication jmxapp : jmxapps) {
                if (!jmxapp.equals((Object)application)) continue;
                tempapp = jmxapp;
                break;
            }
            this.cleanupCreatedHost(hosts, host);
            throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_connection_already_exists", (Object[])new Object[]{application.getId(), DataSourceDescriptorFactory.getDescriptor((DataSource)tempapp).getName()}));
        }
        JmxModel model = JmxModelFactory.getJmxModelFor((Application)application);
        if (model == null || model.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            File appStorage;
            application.setStateImpl(0);
            if (storage != null && (appStorage = storage.getDirectory()).isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            this.cleanupCreatedHost(hosts, host);
            throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Cannot_connect_using", (Object[])new Object[]{displayName != null ? displayName : suggestedName, connectionName}));
        }
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == JmxModel.ConnectionState.CONNECTED) {
                    application.setStateImpl(1);
                } else {
                    application.setStateImpl(0);
                }
            }
        });
        application.jvm = JvmFactory.getJVMFor((Application)application);
        host.getRepository().addDataSource((DataSource)application);
        return application;
    }

    private void cleanupCreatedHost(Set<Host> hosts, Host host) {
        if (host != null && !Host.LOCALHOST.equals((Object)host) && !hosts.contains(host)) {
            host.getOwner().getRepository().removeDataSource((DataSource)host);
        }
    }

    private String normalizeConnectionName(String connectionName) {
        if (connectionName.startsWith("service:jmx:")) {
            return connectionName;
        }
        return "service:jmx:rmi:///jndi/rmi://" + connectionName + "/jmxrmi";
    }

    private String getHostName(JMXServiceURL serviceURL) {
        String hostname = serviceURL.getHost();
        if (hostname == null || hostname.isEmpty()) {
            hostname = null;
            if ("rmi".equals(serviceURL.getProtocol()) && serviceURL.getURLPath().startsWith("/jndi/rmi://")) {
                String urlPath = serviceURL.getURLPath().substring("/jndi/rmi://".length());
                if ('/' == urlPath.charAt(0)) {
                    hostname = "localhost";
                } else if ('[' == urlPath.charAt(0)) {
                    int closingSquareBracketIndex = urlPath.indexOf("]");
                    hostname = closingSquareBracketIndex == -1 ? null : urlPath.substring(0, closingSquareBracketIndex + 1);
                } else {
                    int slashIndex;
                    int colonIndex = urlPath.indexOf(":");
                    int min = Math.min(colonIndex, slashIndex = urlPath.indexOf("/"));
                    if (min == -1) {
                        min = 0;
                    }
                    if ((hostname = urlPath.substring(0, min)).isEmpty()) {
                        hostname = "localhost";
                    }
                }
            }
        }
        return hostname;
    }

    private JMXServiceURL getServiceURL(String connectionString) throws MalformedURLException {
        return new JMXServiceURL(connectionString);
    }

    private void initPersistedApplications() {
        File[] files;
        if (!JmxApplicationsSupport.storageDirectoryExists()) {
            return;
        }
        for (File file : files = JmxApplicationsSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(JmxApplicationProvider.JMX_SUFFIX);
            }
        })) {
            if (!file.isDirectory()) continue;
            Storage storage = new Storage(file, PROPERTIES_FILE);
            Set<Storage> storageSet = this.persistedApplications.get(storage.getCustomProperty(PROPERTY_HOSTNAME));
            if (storageSet == null) {
                storageSet = new HashSet<Storage>();
                this.persistedApplications.put(storage.getCustomProperty(PROPERTY_HOSTNAME), storageSet);
            }
            storageSet.add(storage);
        }
        DataChangeListener<Host> dataChangeListener = new DataChangeListener<Host>(){

            public synchronized void dataChanged(DataChangeEvent<Host> event) {
                Set hosts = event.getAdded();
                for (Host host : hosts) {
                    String hostName = host.getHostName();
                    Set storageSet = (Set)JmxApplicationProvider.this.persistedApplications.get(hostName);
                    if (storageSet == null) continue;
                    JmxApplicationProvider.this.persistedApplications.remove(hostName);
                    String[] keys = new String[]{JmxApplicationProvider.PROPERTY_CONNECTION_STRING, JmxApplicationProvider.PROPERTY_HOSTNAME, "prop_name", "prop_suggested_name", JmxApplicationProvider.PROPERTY_ENV_PROVIDER_ID};
                    for (final Storage storage : storageSet) {
                        final String[] values = storage.getCustomProperties(keys);
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    String sv;
                                    String epid = values[4];
                                    if (epid == null && "1.0".equals(sv = storage.getCustomProperty(JmxApplicationProvider.SNAPSHOT_VERSION))) {
                                        epid = CredentialsProvider.class.getName();
                                    }
                                    EnvironmentProvider ep = epid == null ? null : JmxConnectionSupportImpl.getProvider(epid);
                                    JmxApplicationProvider.this.addJmxApplication(false, null, values[0], values[2], values[3], values[1], ep, storage);
                                }
                                catch (JmxApplicationException e) {
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                                }
                            }
                        });
                    }
                }
                if (JmxApplicationProvider.this.trackingNewHosts && JmxApplicationProvider.this.persistedApplications.isEmpty()) {
                    JmxApplicationProvider.this.trackingNewHosts = false;
                    DataSourceRepository.sharedInstance().removeDataChangeListener((DataChangeListener)this);
                }
            }
        };
        if (!this.persistedApplications.isEmpty()) {
            this.trackingNewHosts = true;
            DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)dataChangeListener, Host.class);
        }
    }

    public void initialize() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JmxApplicationProvider.this.initPersistedApplications();
                    }
                });
            }
        });
    }
}

