/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.explorer.propertysheet.CustomEditorAccessorImpl;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;

public class PropertyEnv {
    public static final String PROP_STATE = "state";
    public static final Object STATE_VALID = "valid";
    public static final Object STATE_NEEDS_VALIDATION = "needs_validation";
    public static final Object STATE_INVALID = "invalid";
    static final String PROP_CHANGE_IMMEDIATE = "changeImmediate";
    static final FeatureDescriptor dummyDescriptor = new FeatureDescriptor();
    private FeatureDescriptor featureDescriptor = dummyDescriptor;
    private Object[] beans;
    private Object state = STATE_VALID;
    private VetoableChangeSupport support;
    private PropertyChangeSupport change;
    private boolean changeImmediate = true;
    InplaceEditor.Factory factory = null;
    boolean editable = true;
    private static final Logger LOG = Logger.getLogger(PropertyEnv.class.getName());

    PropertyEnv() {
    }

    public static PropertyEnv create(FeatureDescriptor featureDescriptor, Object ... objectArray) {
        PropertyEnv propertyEnv = new PropertyEnv();
        propertyEnv.setFeatureDescriptor(featureDescriptor);
        propertyEnv.setBeans(objectArray);
        return propertyEnv;
    }

    public Object[] getBeans() {
        return this.beans;
    }

    void setBeans(Object[] objectArray) {
        this.beans = objectArray;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.featureDescriptor;
    }

    void setFeatureDescriptor(FeatureDescriptor featureDescriptor) {
        Object object;
        if (featureDescriptor == null) {
            throw new IllegalArgumentException("Cannot set FeatureDescriptor to null.");
        }
        this.featureDescriptor = featureDescriptor;
        if (this.featureDescriptor != null && (object = this.featureDescriptor.getValue(PROP_CHANGE_IMMEDIATE)) instanceof Boolean) {
            this.setChangeImmediate((Boolean)object);
        }
    }

    public void setState(Object object) {
        if (this.getState().equals(object)) {
            return;
        }
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, this.getState(), object);
            this.state = object;
            this.getChange().firePropertyChange(PROP_STATE, null, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyDialogManager.notify(propertyVetoException);
        }
    }

    String silentlySetState(Object object, Object object2) {
        if (this.getState().equals(object)) {
            return null;
        }
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, this.getState(), object);
            this.state = object;
            this.getChange().firePropertyChange(PROP_STATE, null, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            LOG.log(Level.INFO, "Cannot change property: " + propertyVetoException.getPropertyChangeEvent().getPropertyName(), propertyVetoException);
            String string = this.getFeatureDescriptor() == null ? null : this.getFeatureDescriptor().getDisplayName();
            return PropUtils.findLocalizedMessage(propertyVetoException, object2, string);
        }
        return null;
    }

    public Object getState() {
        return this.state;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().addVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChange().addPropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChange().removePropertyChangeListener(propertyChangeListener);
    }

    boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    void setChangeImmediate(boolean bl) {
        this.changeImmediate = bl;
    }

    private synchronized VetoableChangeSupport getSupport() {
        if (this.support == null) {
            this.support = new VetoableChangeSupport(this);
        }
        return this.support;
    }

    private synchronized PropertyChangeSupport getChange() {
        if (this.change == null) {
            this.change = new PropertyChangeSupport(this);
        }
        return this.change;
    }

    public void registerInplaceEditorFactory(InplaceEditor.Factory factory) {
        this.factory = factory;
    }

    InplaceEditor getInplaceEditor() {
        InplaceEditor inplaceEditor = this.factory != null ? this.factory.getInplaceEditor() : null;
        return inplaceEditor;
    }

    void setEditable(boolean bl) {
        this.editable = bl;
    }

    boolean isEditable() {
        return this.editable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("@");
        stringBuilder.append(System.identityHashCode(this));
        stringBuilder.append("[state=");
        stringBuilder.append(this.state == STATE_NEEDS_VALIDATION ? "STATE_NEEDS_VALIDATION" : (this.state == STATE_INVALID ? "STATE_INVALID" : "STATE_VALID"));
        stringBuilder.append(", ");
        InplaceEditor.Factory factory = this.factory;
        if (factory != null) {
            stringBuilder.append("InplaceEditorFactory=").append(factory.getClass().getName());
            stringBuilder.append(", ");
        }
        stringBuilder.append("editable=");
        stringBuilder.append(this.editable);
        stringBuilder.append(", isChangeImmediate=");
        stringBuilder.append(this.isChangeImmediate());
        stringBuilder.append(", featureDescriptor=");
        FeatureDescriptor featureDescriptor = this.getFeatureDescriptor();
        if (featureDescriptor != null) {
            stringBuilder.append(featureDescriptor.getDisplayName());
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    static {
        CustomEditorAccessorImpl.register();
    }
}

