/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.FullScreenUtilities;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.WindowManager;

class NbApplicationAdapter
implements ApplicationListener {
    private static final String OPTIONS_ACTION = "Actions/Window/org-netbeans-modules-options-OptionsWindowAction.instance";
    private static final String ABOUT_ACTION = "Actions/Help/org-netbeans-core-actions-AboutAction.instance";
    private static final String EXIT_ACTION = "Actions/System/org-netbeans-core-actions-SystemExit.instance";
    private static ApplicationListener al = null;

    private NbApplicationAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install() {
        boolean bl = Beans.isDesignTime();
        try {
            Beans.setDesignTime(false);
            al = new NbApplicationAdapter();
            Application.getApplication().addApplicationListener(al);
            Application.getApplication().setEnabledAboutMenu(true);
            Application.getApplication().setEnabledPreferencesMenu(true);
        }
        finally {
            Beans.setDesignTime(bl);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FullScreenUtilities.setWindowCanFullScreen((Window)WindowManager.getDefault().getMainWindow(), (boolean)true);
                }
                catch (Exception exception) {
                    Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.FINE, "Error while setting up full screen support.", exception);
                }
            }
        });
    }

    static void uninstall() {
        if (al != null) {
            Application.getApplication().removeApplicationListener(al);
            al = null;
        }
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(this.performAction(ABOUT_ACTION));
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        FileObject fileObject;
        boolean bl = false;
        String string = applicationEvent.getFilename();
        File file = new File(string);
        if (file.exists() && !file.isDirectory() && (fileObject = FileUtil.toFileObject((File)file)) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                bl = openCookie != null;
                if (bl) {
                    openCookie.open();
                } else {
                    EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                    bl = editCookie != null;
                    if (bl) {
                        editCookie.edit();
                    } else {
                        ViewCookie viewCookie = (ViewCookie)dataObject.getLookup().lookup(ViewCookie.class);
                        bl = viewCookie != null;
                        if (bl) {
                            viewCookie.view();
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, string, dataObjectNotFoundException);
            }
        }
        applicationEvent.setHandled(bl);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(this.performAction(OPTIONS_ACTION));
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(!this.performAction(EXIT_ACTION));
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
    }

    private boolean performAction(String string) {
        return this.performAction(string, null);
    }

    private boolean performAction(String string, String string2) {
        Action action = this.findAction(string);
        if (action == null) {
            return false;
        }
        if (string2 == null) {
            string2 = "foo";
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string2);
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
            return false;
        }
    }

    private Action findAction(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                Object object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null && (object = instanceCookie.instanceCreate()) instanceof Action) {
                    return (Action)object;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
                return null;
            }
        }
        return null;
    }
}

