/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx;

import com.oracle.javafx.jmx.SGMXBean;
import com.oracle.javafx.jmx.json.JSONDocument;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.jmx.HighlightRegion;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class SGMXBeanImpl
implements SGMXBean,
MXNodeAlgorithm {
    private static final String SGMX_NOT_PAUSED_TEXT = "Scene-graph is not PAUSED.";
    private static final String SGMX_CALL_GETSGTREE_FIRST = "You need to call getSGTree() first.";
    private boolean paused = false;
    private Map<Integer, Window> windowMap = null;
    private JSONDocument jwindows = null;
    private Map<Integer, Node> nodeMap = null;
    private JSONDocument[] jsceneGraphs = null;
    private Map<Scene, BufferedImage> scene2Image = null;
    private List<MediaPlayer> playersToResume = null;

    @Override
    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.releaseAllStateObject();
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.pauseScenes();
        this.pauseMedia();
    }

    @Override
    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.releaseAllStateObject();
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.resumeScenes();
        this.resumeMedia();
    }

    @Override
    public void step() throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.releaseAllStateObject();
        Toolkit toolkit = Toolkit.getToolkit();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        toolkit.setLastTkPulseListener(new TKPulseListener(){

            public void pulse() {
                countDownLatch.countDown();
            }
        });
        toolkit.resumeScenes();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        toolkit.pauseScenes();
        toolkit.setLastTkPulseListener(null);
    }

    @Override
    public String getWindows() throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.importWindowsIfNeeded();
        return this.jwindows.toJSON();
    }

    @Override
    public String getSGTree(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.importWindowsIfNeeded();
        if (this.nodeMap == null) {
            this.nodeMap = new LinkedHashMap<Integer, Node>();
        }
        if (this.jsceneGraphs[n] == null) {
            Window window = this.windowMap.get(n);
            this.importSGTree((Node)window.getScene().getRoot(), n);
        }
        return this.jsceneGraphs[n].toJSON();
    }

    @Override
    public void addHighlightedNode(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        Toolkit.getToolkit().getHighlightedRegions().add(this.createHighlightRegion(n));
        this.getNode(n).getScene().impl_getPeer().markDirty();
    }

    @Override
    public void removeHighlightedNode(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        Toolkit.getToolkit().getHighlightedRegions().remove(this.createHighlightRegion(n));
        this.getNode(n).getScene().impl_getPeer().markDirty();
    }

    @Override
    public void addHighlightedRegion(int n, double d, double d2, double d3, double d4) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        TKScene tKScene = this.getScene(n).impl_getPeer();
        Toolkit.getToolkit().getHighlightedRegions().add(new HighlightRegion(tKScene, d, d2, d3, d4));
        tKScene.markDirty();
    }

    @Override
    public void removeHighlightedRegion(int n, double d, double d2, double d3, double d4) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        TKScene tKScene = this.getScene(n).impl_getPeer();
        Toolkit.getToolkit().getHighlightedRegions().remove(new HighlightRegion(tKScene, d, d2, d3, d4));
        tKScene.markDirty();
    }

    private Node getNode(int n) {
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(n);
        if (node == null) {
            throw new IllegalArgumentException("Wrong node id.");
        }
        return node;
    }

    private Scene getScene(int n) {
        if (this.windowMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Window window = this.windowMap.get(n);
        if (window == null) {
            throw new IllegalArgumentException("Wrong window id.");
        }
        return window.getScene();
    }

    private HighlightRegion createHighlightRegion(int n) {
        Node node = this.getNode(n);
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        return new HighlightRegion(node.getScene().impl_getPeer(), bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public String makeScreenShot(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(n);
        if (node == null) {
            return null;
        }
        Scene scene = node.getScene();
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        return this.getScreenShotPath(scene, bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public String makeScreenShot(int n, double d, double d2, double d3, double d4) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Scene scene = this.getScene(n);
        return this.getScreenShotPath(scene, d, d2, d3, d4);
    }

    private String getScreenShotPath(Scene scene, double d, double d2, double d3, double d4) {
        Object object;
        BufferedImage bufferedImage;
        if (this.scene2Image == null) {
            this.scene2Image = new LinkedHashMap<Scene, BufferedImage>();
        }
        if ((bufferedImage = this.scene2Image.get(scene)) == null) {
            object = scene.snapshot(null);
            bufferedImage = SwingFXUtils.fromFXImage((Image)object, null);
            this.scene2Image.put(scene, bufferedImage);
        }
        object = bufferedImage.getSubimage((int)d, (int)d2, (int)d3, (int)d4);
        File file = null;
        try {
            file = File.createTempFile("jfx", ".png");
            ImageIO.write((RenderedImage)object, "PNG", file);
            file.deleteOnExit();
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void releaseAllStateObject() {
        this.clearWindowMap();
        this.jwindows = null;
        this.clearNodeMap();
        this.jsceneGraphs = null;
        this.clearScene2Image();
    }

    private void clearWindowMap() {
        if (this.windowMap != null) {
            this.windowMap.clear();
            this.windowMap = null;
        }
    }

    private void clearNodeMap() {
        if (this.nodeMap != null) {
            this.nodeMap.clear();
            this.nodeMap = null;
        }
    }

    private void clearScene2Image() {
        if (this.scene2Image != null) {
            this.scene2Image.clear();
            this.scene2Image = null;
        }
    }

    private void importWindowsIfNeeded() {
        if (this.windowMap == null) {
            this.windowMap = new LinkedHashMap<Integer, Window>();
            this.importWindows();
        }
    }

    private void importWindows() {
        int n = 0;
        Iterator iterator = Window.impl_getWindows();
        this.jwindows = JSONDocument.createArray();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next();
            this.windowMap.put(n, window);
            JSONDocument jSONDocument = JSONDocument.createObject();
            jSONDocument.setNumber("id", (Number)n);
            jSONDocument.setString("type", window.impl_getMXWindowType());
            this.jwindows.array().add(jSONDocument);
            ++n;
        }
        this.jsceneGraphs = new JSONDocument[n];
    }

    private void importSGTree(Node node, int n) {
        if (node == null) {
            return;
        }
        this.jsceneGraphs[n] = (JSONDocument)node.impl_processMXNode((MXNodeAlgorithm)this, new MXNodeAlgorithmContext(this.nodeMap.size()));
    }

    @Override
    public String getCSSInfo(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(n);
        if (node == null) {
            return null;
        }
        JSONDocument jSONDocument = new JSONDocument(JSONDocument.Type.OBJECT);
        List list = StyleableProperty.getStyleables((Node)node);
        for (StyleableProperty styleableProperty : list) {
            SGMXBeanImpl.processStyleableProperty(styleableProperty, node, jSONDocument);
        }
        return jSONDocument.toJSON();
    }

    private static void processStyleableProperty(StyleableProperty styleableProperty, Node node, JSONDocument jSONDocument) {
        List list = styleableProperty.getSubProperties();
        if (list != null && !list.isEmpty()) {
            for (Object object : list) {
                SGMXBeanImpl.processStyleableProperty((StyleableProperty)object, node, jSONDocument);
            }
        }
        try {
            Object object;
            WritableValue writableValue = styleableProperty.getWritableValue(node);
            Object object2 = object = writableValue != null ? writableValue.getValue() : null;
            if (object != null) {
                jSONDocument.setString(styleableProperty.getProperty(), object.toString());
            } else {
                jSONDocument.setString(styleableProperty.getProperty(), "null");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private static String upcaseFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @Override
    public String getBounds(int n) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(n);
        if (node == null) {
            return null;
        }
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        JSONDocument jSONDocument = JSONDocument.createObject();
        jSONDocument.setNumber("x", (Number)bounds.getMinX());
        jSONDocument.setNumber("y", (Number)bounds.getMinY());
        jSONDocument.setNumber("w", (Number)bounds.getWidth());
        jSONDocument.setNumber("h", (Number)bounds.getHeight());
        return jSONDocument.toJSON();
    }

    public Object processLeafNode(Node node, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return this.createJSONDocument(node, mXNodeAlgorithmContext);
    }

    public Object processContainerNode(Parent parent, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        JSONDocument jSONDocument = this.createJSONDocument((Node)parent, mXNodeAlgorithmContext);
        ObservableList observableList = parent.getChildrenUnmodifiable();
        JSONDocument jSONDocument2 = JSONDocument.createArray(observableList.size());
        jSONDocument.set("children", jSONDocument2);
        for (int i = 0; i < observableList.size(); ++i) {
            jSONDocument2.set(i, (JSONDocument)((Node)observableList.get(i)).impl_processMXNode((MXNodeAlgorithm)this, mXNodeAlgorithmContext));
        }
        return jSONDocument;
    }

    private JSONDocument createJSONDocument(Node node, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        int n = mXNodeAlgorithmContext.getNextInt();
        this.nodeMap.put(n, node);
        JSONDocument jSONDocument = JSONDocument.createObject();
        jSONDocument.setNumber("id", (Number)n);
        jSONDocument.setString("class", node.getClass().getSimpleName());
        return jSONDocument;
    }

    private void pauseMedia() {
        AudioClip.stopAllClips();
        List list = MediaManager.getAllMediaPlayers();
        if (list == null) {
            return;
        }
        if (!list.isEmpty() && this.playersToResume == null) {
            this.playersToResume = new ArrayList<MediaPlayer>();
        }
        for (MediaPlayer mediaPlayer : list) {
            if (mediaPlayer.getState() != PlayerStateEvent.PlayerState.PLAYING) continue;
            mediaPlayer.pause();
            this.playersToResume.add(mediaPlayer);
        }
    }

    private void resumeMedia() {
        if (this.playersToResume == null) {
            return;
        }
        for (MediaPlayer mediaPlayer : this.playersToResume) {
            mediaPlayer.play();
        }
        this.playersToResume.clear();
    }
}

