/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.types.basic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.basic.VtblAccess;

public class BasicTypeDataBase
implements TypeDataBase {
    private MachineDescription machDesc;
    private VtblAccess vtblAccess;
    private Map nameToTypeMap = new HashMap();
    private Map nameToIntConstantMap = new HashMap();
    private Map nameToLongConstantMap = new HashMap();
    private Type jbooleanType;
    private Type jbyteType;
    private Type jcharType;
    private Type jdoubleType;
    private Type jfloatType;
    private Type jintType;
    private Type jlongType;
    private Type jshortType;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.types.basic.BasicTypeDataBase.DEBUG") != null;
    static HashMap typeToVtbl = new HashMap();

    public BasicTypeDataBase(MachineDescription machDesc, VtblAccess vtblAccess) {
        this.machDesc = machDesc;
        this.vtblAccess = vtblAccess;
    }

    @Override
    public Type lookupType(String cTypeName) {
        return this.lookupType(cTypeName, true);
    }

    @Override
    public Type lookupType(String cTypeName, boolean throwException) {
        Type type = (Type)this.nameToTypeMap.get(cTypeName);
        if (type == null && throwException) {
            throw new RuntimeException("No type named \"" + cTypeName + "\" in database");
        }
        return type;
    }

    @Override
    public Integer lookupIntConstant(String constantName) {
        return this.lookupIntConstant(constantName, true);
    }

    @Override
    public Integer lookupIntConstant(String constantName, boolean throwException) {
        Integer i = (Integer)this.nameToIntConstantMap.get(constantName);
        if (i == null && throwException) {
            throw new RuntimeException("No integer constant named \"" + constantName + "\" present in type database");
        }
        return i;
    }

    @Override
    public Long lookupLongConstant(String constantName) {
        return this.lookupLongConstant(constantName, true);
    }

    @Override
    public Long lookupLongConstant(String constantName, boolean throwException) {
        Long i = (Long)this.nameToLongConstantMap.get(constantName);
        if (i == null && throwException) {
            throw new RuntimeException("No long constant named \"" + constantName + "\" present in type database");
        }
        return i;
    }

    @Override
    public Type getJBooleanType() {
        return this.jbooleanType;
    }

    @Override
    public Type getJByteType() {
        return this.jbyteType;
    }

    @Override
    public Type getJCharType() {
        return this.jcharType;
    }

    @Override
    public Type getJDoubleType() {
        return this.jdoubleType;
    }

    @Override
    public Type getJFloatType() {
        return this.jfloatType;
    }

    @Override
    public Type getJIntType() {
        return this.jintType;
    }

    @Override
    public Type getJLongType() {
        return this.jlongType;
    }

    @Override
    public Type getJShortType() {
        return this.jshortType;
    }

    @Override
    public long getAddressSize() {
        return this.machDesc.getAddressSize();
    }

    @Override
    public long getOopSize() {
        return VM.getVM().getOopSize();
    }

    private Address vtblForType(Type type) {
        Address vtblAddr = (Address)typeToVtbl.get(type);
        if (vtblAddr == null && (vtblAddr = this.vtblAccess.getVtblForType(type)) != null) {
            typeToVtbl.put(type, vtblAddr);
        }
        return vtblAddr;
    }

    @Override
    public boolean addressTypeIsEqualToType(Address addr, Type type) {
        if (addr == null) {
            return false;
        }
        Address vtblAddr = this.vtblForType(type);
        if (vtblAddr == null) {
            if (DEBUG) {
                System.err.println("BasicTypeDataBase.addressTypeIsEqualToType: vtblAddr == null");
            }
            return false;
        }
        try {
            for (Type curType = type; curType != null; curType = curType.getSuperclass()) {
                if (((Object)vtblAddr).equals(addr.getAddressAt(0L))) {
                    return true;
                }
                long offset = curType.getSize();
                if ((offset -= offset % this.getAddressSize()) <= 0L) {
                    return false;
                }
                if (((Object)vtblAddr).equals(addr.getAddressAt(offset))) {
                    return true;
                }
                if ((offset -= this.getAddressSize()) <= 0L) {
                    return false;
                }
                if (!((Object)vtblAddr).equals(addr.getAddressAt(offset))) continue;
                return true;
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                System.err.println("BasicTypeDataBase.addressTypeIsEqualToType: exception occurred during lookup:");
                e.printStackTrace();
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("BasicTypeDataBase.addressTypeIsEqualToType: all vptr tests failed for type " + type.getName());
        }
        return false;
    }

    @Override
    public Type findDynamicTypeForAddress(Address addr, Type baseType) {
        long offset3;
        if (this.vtblForType(baseType) == null) {
            throw new InternalError(baseType + " does not appear to be polymorphic");
        }
        Address loc1 = addr.getAddressAt(0L);
        Address loc2 = null;
        Address loc3 = null;
        long offset2 = baseType.getSize();
        if ((offset2 = offset2 - offset2 % this.getAddressSize() - this.getAddressSize()) > 0L) {
            loc2 = addr.getAddressAt(offset2);
        }
        if ((offset3 = offset2 - this.getAddressSize()) > 0L) {
            loc3 = addr.getAddressAt(offset3);
        }
        Type loc2Match = null;
        Type loc3Match = null;
        Iterator iter = this.getTypes();
        while (iter.hasNext()) {
            Type type;
            Type superClass;
            for (superClass = type = (Type)iter.next(); superClass != baseType && superClass != null; superClass = superClass.getSuperclass()) {
            }
            if (superClass == null) continue;
            Address vtblAddr = this.vtblForType(type);
            if (vtblAddr == null) {
                if (!DEBUG) continue;
                System.err.println("null vtbl for " + type);
                continue;
            }
            if (((Object)vtblAddr).equals(loc1)) {
                return type;
            }
            if (loc2 != null && loc2Match == null && ((Object)vtblAddr).equals(loc2)) {
                loc2Match = type;
            }
            if (loc3 == null || loc3Match != null || !((Object)vtblAddr).equals(loc3)) continue;
            loc3Match = type;
        }
        if (loc2Match != null) {
            return loc2Match;
        }
        if (loc3Match != null) {
            return loc3Match;
        }
        return null;
    }

    @Override
    public Type guessTypeForAddress(Address addr) {
        Iterator iter = this.getTypes();
        while (iter.hasNext()) {
            Type t = (Type)iter.next();
            if (!this.addressTypeIsEqualToType(addr, t)) continue;
            return t;
        }
        return null;
    }

    public long cIntegerTypeMaxValue(long sizeInBytes, boolean isUnsigned) {
        return this.machDesc.cIntegerTypeMaxValue(sizeInBytes, isUnsigned);
    }

    public long cIntegerTypeMinValue(long sizeInBytes, boolean isUnsigned) {
        return this.machDesc.cIntegerTypeMinValue(sizeInBytes, isUnsigned);
    }

    @Override
    public Iterator getTypes() {
        return this.nameToTypeMap.values().iterator();
    }

    @Override
    public Iterator getIntConstants() {
        return this.nameToIntConstantMap.keySet().iterator();
    }

    @Override
    public Iterator getLongConstants() {
        return this.nameToLongConstantMap.keySet().iterator();
    }

    public void setJBooleanType(Type type) {
        this.jbooleanType = type;
    }

    public void setJByteType(Type type) {
        this.jbyteType = type;
    }

    public void setJCharType(Type type) {
        this.jcharType = type;
    }

    public void setJDoubleType(Type type) {
        this.jdoubleType = type;
    }

    public void setJFloatType(Type type) {
        this.jfloatType = type;
    }

    public void setJIntType(Type type) {
        this.jintType = type;
    }

    public void setJLongType(Type type) {
        this.jlongType = type;
    }

    public void setJShortType(Type type) {
        this.jshortType = type;
    }

    public void addType(Type type) {
        if (this.nameToTypeMap.get(type.getName()) != null) {
            throw new RuntimeException("type of name \"" + type.getName() + "\" already present");
        }
        this.nameToTypeMap.put(type.getName(), type);
    }

    public void removeType(Type type) {
        Type curType = (Type)this.nameToTypeMap.get(type.getName());
        if (curType == null) {
            throw new RuntimeException("type of name \"" + type.getName() + "\" not present");
        }
        if (!curType.equals(type)) {
            throw new RuntimeException("a different type of name \"" + type.getName() + "\" was present");
        }
        this.nameToTypeMap.remove(type.getName());
    }

    public void addIntConstant(String name, int value) {
        if (this.nameToIntConstantMap.get(name) != null) {
            throw new RuntimeException("int constant of name \"" + name + "\" already present");
        }
        this.nameToIntConstantMap.put(name, new Integer(value));
    }

    public void removeIntConstant(String name) {
        Integer curConstant = (Integer)this.nameToIntConstantMap.get(name);
        if (curConstant == null) {
            throw new RuntimeException("int constant of name \"" + name + "\" not present");
        }
        this.nameToIntConstantMap.remove(name);
    }

    public void addLongConstant(String name, long value) {
        if (this.nameToLongConstantMap.get(name) != null) {
            throw new RuntimeException("long constant of name \"" + name + "\" already present");
        }
        this.nameToLongConstantMap.put(name, new Long(value));
    }

    public void removeLongConstant(String name) {
        Long curConstant = (Long)this.nameToLongConstantMap.get(name);
        if (curConstant == null) {
            throw new RuntimeException("long constant of name \"" + name + "\" not present");
        }
        this.nameToLongConstantMap.remove(name);
    }
}

