/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.spi.project;

import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProfilingSettingsSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class ProfilingSettingsSupportProvider {
    public abstract float getProfilingOverhead(ProfilingSettings var1);

    public abstract ProfilingSettingsSupport.SettingsCustomizer getSettingsCustomizer();

    public abstract String getProjectOnlyFilterName();

    public abstract String getProjectSubprojectsFilterName();

    public static class Default
    extends Basic {
        @Override
        public String getProjectOnlyFilterName() {
            return NbBundle.getMessage(ProfilingSettingsSupportProvider.class, (String)"ProfilingSettingsSupportProvider_ProfileProjectClassesString");
        }

        @Override
        public String getProjectSubprojectsFilterName() {
            return !ProjectUtilities.hasSubprojects(this.getProject()) ? null : NbBundle.getMessage(ProfilingSettingsSupportProvider.class, (String)"ProfilingSettingsSupportProvider_ProfileProjectSubprojectClassesString");
        }

        public Default(Lookup.Provider provider) {
            super(provider);
        }
    }

    public static class Basic
    extends ProfilingSettingsSupportProvider {
        private final Lookup.Provider project;

        @Override
        public float getProfilingOverhead(ProfilingSettings profilingSettings) {
            float f = 0.0f;
            int n = profilingSettings.getProfilingType();
            if (!ProfilingSettings.isMonitorSettings((ProfilingSettings)profilingSettings)) {
                if (ProfilingSettings.isCPUSettings((ProfilingSettings)profilingSettings)) {
                    if (n == 64) {
                        f += 0.05f;
                    } else if (n == 8) {
                        f += this.project == null ? 0.85f : 0.5f;
                    } else if (n == 16) {
                        f += 0.2f;
                    }
                    if (FilterUtils.NONE_FILTER.equals(profilingSettings.getSelectedInstrumentationFilter()) && n != 64) {
                        f += 0.5f;
                    }
                } else if (ProfilingSettings.isMemorySettings((ProfilingSettings)profilingSettings)) {
                    if (n == 2) {
                        f += 0.5f;
                    } else if (n == 4) {
                        f += 0.7f;
                    }
                    if (profilingSettings.getAllocStackTraceLimit() != 0) {
                        f += 0.3f;
                    }
                }
            }
            return Math.min(f, 1.0f);
        }

        @Override
        public ProfilingSettingsSupport.SettingsCustomizer getSettingsCustomizer() {
            return null;
        }

        @Override
        public String getProjectOnlyFilterName() {
            return null;
        }

        @Override
        public String getProjectSubprojectsFilterName() {
            return null;
        }

        protected final Lookup.Provider getProject() {
            return this.project;
        }

        public Basic(Lookup.Provider provider) {
            this.project = provider;
        }
    }
}

