/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Exceptions;

final class FileAssociationsModel
extends MIMEResolver.UIHelpers {
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final Logger LOGGER = Logger.getLogger(FileAssociationsModel.class.getName());
    private HashMap<String, String> extensionToMimeAll = new HashMap();
    private HashMap<String, String> extensionToMimeSystem = new HashMap();
    private HashMap<String, String> extensionToMimeUser = new HashMap();
    private TreeSet<String> mimeTypes = new TreeSet();
    private HashMap<String, MimeItem> mimeToItem = new HashMap();
    private boolean initialized = false;
    private final FileChangeListener mimeResolversListener = new FileChangeAdapter(){

        public void fileDeleted(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileChanged(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }
    };

    FileAssociationsModel() {
        super(new MIMEResolver(){

            public String findMIMEType(FileObject fileObject) {
                return null;
            }
        });
        FileObject fileObject = FileUtil.getConfigFile((String)MIME_RESOLVERS_PATH);
        if (fileObject != null) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.mimeResolversListener, (Object)fileObject));
        }
    }

    boolean containsExtension(String string) {
        return this.extensionToMimeAll.containsKey(string);
    }

    String getAssociatedAlso(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.getExtensions()) {
            if (string3.equals(string) || !this.extensionToMimeAll.get(string3).equals(string2)) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    List<String> getExtensions() {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(this.extensionToMimeAll.keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    Set<String> getMimeTypes() {
        this.init();
        return this.mimeTypes;
    }

    private void readMimeTypesFromLoaders() {
        FileObject[] fileObjectArray = FileUtil.getConfigFile((String)"Loaders").getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject = fileObjectArray[i];
            String string = fileObject.getNameExt();
            FileObject[] fileObjectArray2 = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                FileObject fileObject2 = fileObjectArray2[j];
                FileObject fileObject3 = fileObject2.getFileObject("Factories");
                if (fileObject3 == null || fileObject3.getChildren().length <= 0) continue;
                this.mimeTypes.add(string + "/" + fileObject2.getNameExt());
            }
        }
        this.mimeTypes.remove("content/unknown");
    }

    String getMimeType(String string) {
        this.init();
        return this.extensionToMimeAll.get(string);
    }

    MimeItem getMimeItem(String string) {
        return this.mimeToItem.get(this.getMimeType(string));
    }

    void remove(String string) {
        this.extensionToMimeUser.remove(string);
        this.extensionToMimeAll.remove(string);
    }

    void setDefault(String string) {
        this.remove(string);
        this.extensionToMimeAll.put(string, this.extensionToMimeSystem.get(string));
    }

    boolean setMimeType(String string, String string2) {
        String string3 = this.getMimeType(string);
        if (!string2.equals(string3)) {
            LOGGER.fine("setMimeType - " + string + "=" + string2);
            this.extensionToMimeUser.put(string, string2);
            this.extensionToMimeAll.put(string, string2);
            return true;
        }
        return false;
    }

    boolean canBeRestored(String string) {
        return this.extensionToMimeUser.containsKey(string) && this.extensionToMimeSystem.containsKey(string);
    }

    boolean canBeRemoved(String string) {
        return !this.extensionToMimeSystem.containsKey(string);
    }

    private static String getLoaderDisplayName(String string) {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        FileObject fileObject = FileUtil.getConfigFile((String)("Loaders/" + string + "/Factories"));
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                String string2;
                String string3 = fileObject2.getNameExt();
                if (string3.equals(string2 = fileSystem.getStatus().annotateName(string3, Collections.singleton(fileObject2)))) continue;
                return string2;
            }
        }
        return null;
    }

    ArrayList<MimeItem> getMimeItems() {
        this.init();
        ArrayList<MimeItem> arrayList = new ArrayList<MimeItem>(this.mimeToItem.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    void store() {
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, String> entry : this.extensionToMimeUser.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(string2, hashSet);
            }
            hashSet.add(string);
        }
        this.storeUserDefinedResolver(hashMap);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        LOGGER.fine("FileAssociationsModel.init");
        this.initialized = true;
        for (FileObject object : this.getOrderedResolvers()) {
            boolean bl = this.isUserDefined(object);
            Map map = this.getMIMEToExtensions(object);
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                for (String string2 : set) {
                    if (string2.equalsIgnoreCase("xml") && !bl && "text/xml".equals(this.extensionToMimeAll.get(string2))) continue;
                    this.extensionToMimeAll.put(string2, string);
                    if (bl) {
                        this.extensionToMimeUser.put(string2, string);
                        continue;
                    }
                    this.extensionToMimeSystem.put(string2, string);
                }
                this.mimeTypes.add(string);
            }
        }
        this.readMimeTypesFromLoaders();
        for (String string : this.mimeTypes) {
            MimeItem mimeItem = new MimeItem(string, FileAssociationsModel.getLoaderDisplayName(string));
            this.mimeToItem.put(string, mimeItem);
        }
        LOGGER.fine("extensionToMimeSystem=" + this.extensionToMimeSystem);
        LOGGER.fine("extensionToMimeUser=" + this.extensionToMimeUser);
    }

    static final class MimeItem
    implements Comparable<MimeItem> {
        String mimeType;
        String displayName;

        MimeItem(String string, String string2) {
            this.mimeType = string;
            this.displayName = string2;
        }

        String getMimeType() {
            return this.mimeType;
        }

        public String toString() {
            return this.displayName == null ? this.mimeType : this.displayName + " (" + this.mimeType + ")";
        }

        @Override
        public int compareTo(MimeItem mimeItem) {
            return this.toString().compareToIgnoreCase(mimeItem.toString());
        }
    }
}

