/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.MainImpl;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public abstract class CLIHandler {
    private static final int KEY_LENGTH = 10;
    private static final byte[] VERSION = new byte[]{78, 66, 67, 76, 73, 0, 0, 0, 0, 1};
    private static final int REPLY_OK = 1;
    private static final int REPLY_EXIT = 2;
    private static final int REPLY_FAIL = 0;
    private static final int REPLY_DELAY = 3;
    private static final int REPLY_READ = 10;
    private static final int REPLY_WRITE = 11;
    private static final int REPLY_AVAILABLE = 12;
    private static final int REPLY_ERROR = 13;
    private static final int REPLY_VERSION = 14;
    public static final int WHEN_BOOT = 1;
    public static final int WHEN_INIT = 2;
    public static final int WHEN_EXTRA = 3;
    private static final RequestProcessor secureCLIPort = new RequestProcessor("Secure CLI Port");
    private static Server server;
    private static final Logger OUTPUT;
    private int when;
    private static List<Execute> doLater;

    protected CLIHandler(int n) {
        this.when = n;
    }

    protected abstract int cli(Args var1);

    protected static void showHelp(PrintWriter printWriter, Collection<? extends CLIHandler> collection, int n) {
        for (CLIHandler cLIHandler : collection) {
            if (n != -1 && n != cLIHandler.when) continue;
            cLIHandler.usage(printWriter);
        }
    }

    protected abstract void usage(PrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterState(int n, Integer n2) {
        Object object;
        if (OUTPUT.isLoggable(Level.FINEST)) {
            object = OUTPUT;
            synchronized (object) {
                OUTPUT.finest("state: " + n + " thread: " + Thread.currentThread());
            }
        }
        if (n2 == null) {
            return;
        }
        object = n2;
        synchronized (object) {
            if (n == n2) {
                if (OUTPUT.isLoggable(Level.FINEST)) {
                    OUTPUT.finest(n + " blocked");
                }
                n2.notifyAll();
                try {
                    n2.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException();
                }
            } else if (OUTPUT.isLoggable(Level.FINEST)) {
                OUTPUT.finest(n + " not blocked");
            }
        }
    }

    private static boolean checkHelp(Args args, Collection<? extends CLIHandler> collection) {
        String[] stringArray = args.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals("-?") && !stringArray[i].equals("--help") && !stringArray[i].equals("-help")) continue;
            Logger.getLogger("").setLevel(Level.OFF);
            PrintWriter printWriter = new PrintWriter(args.getOutputStream());
            CLIHandler.showHelp(printWriter, collection, -1);
            printWriter.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected static int notifyHandlers(Args args, Collection<? extends CLIHandler> collection, int n, boolean bl, boolean bl2) {
        try {
            int n2 = 0;
            for (CLIHandler cLIHandler : collection) {
                if (cLIHandler.when != n) continue;
                n2 = cLIHandler.cli(args);
                if (n2 == 0) continue;
                int printWriter = n2;
                return printWriter;
            }
            String[] stringArray = args.getArguments();
            if (bl) {
                void n5;
                stringArray = args.getArguments();
                boolean i = false;
                while (n5 < stringArray.length) {
                    if (stringArray[n5] != null) {
                        PrintWriter printWriter = new PrintWriter(args.getOutputStream());
                        printWriter.println("Ignored unknown option: " + stringArray[n5]);
                        printWriter.flush();
                        int n3 = 2;
                        return n3;
                    }
                    ++n5;
                }
            }
            int n4 = 0;
            return n4;
        }
        finally {
            args.reset(bl2);
        }
    }

    private static int processInitLevelCLI(final Args args, final Collection<? extends CLIHandler> collection, final boolean bl) {
        return CLIHandler.registerFinishInstallation(new Execute(){

            @Override
            public int exec() {
                return CLIHandler.notifyHandlers(args, collection, 2, bl, bl);
            }

            public String toString() {
                return collection.toString();
            }
        });
    }

    private static FileLock tryLock(RandomAccessFile randomAccessFile) throws IOException {
        try {
            return randomAccessFile.getChannel().tryLock(333L, 1L, false);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            OUTPUT.log(Level.INFO, "tryLock fails in the same VM", overlappingFileLockException);
            return null;
        }
    }

    static Status initialize(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, MainImpl.BootClassLoader bootClassLoader, boolean bl, boolean bl2, Runnable runnable) {
        String string = System.getProperty("netbeans.user.dir");
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        return CLIHandler.initialize(new Args(stringArray, inputStream, outputStream, outputStream2, string), null, bootClassLoader.allCLIs(), bl, bl2, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int registerFinishInstallation(Execute execute) {
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            boolean bl;
            if (doLater != null) {
                doLater.add(execute);
                bl = false;
            } else {
                bl = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                return execute.exec();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int finishInitialization(boolean bl) {
        OUTPUT.log(Level.FINER, "finishInitialization {0}", bl);
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            List<Execute> list = doLater;
            ArrayList arrayList = doLater = bl ? new ArrayList() : null;
            if (OUTPUT.isLoggable(Level.FINER)) {
                OUTPUT.finer("Notify: " + list);
            }
            if (!bl) {
                CLIHandler.class.notifyAll();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (list != null) {
                for (Execute execute : list) {
                    int n = execute.exec();
                    if (n == 0) continue;
                    return n;
                }
            }
            return 0;
        }
    }

    private static synchronized boolean waitFinishInstallationIsOver(int n) {
        if (doLater != null) {
            try {
                CLIHandler.class.wait((long)n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return doLater == null;
    }

    static void waitSecureCLIOver() {
        secureCLIPort.post((Runnable)Task.EMPTY).waitFinished();
    }

    public static synchronized void stopServer() {
        Server server = CLIHandler.server;
        if (server != null) {
            server.stopServer();
        }
    }

    private static InetAddress localHostAddress() throws IOException {
        NetworkInterface networkInterface = NetworkInterface.getByName("lo");
        if (networkInterface == null || !networkInterface.getInetAddresses().hasMoreElements()) {
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        }
        if (networkInterface == null || !networkInterface.getInetAddresses().hasMoreElements()) {
            return InetAddress.getLocalHost();
        }
        return networkInterface.getInetAddresses().nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Status initialize(Args args, final Integer n, Collection<? extends CLIHandler> collection, boolean bl, boolean bl2, Runnable runnable) {
        int n2 = CLIHandler.notifyHandlers(args, collection, 1, false, bl);
        if (n2 != 0) {
            return new Status(n2);
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            string = System.getProperty("user.home");
            System.setProperty("netbeans.user", string);
        }
        if ("memory".equals(string)) {
            int n3 = CLIHandler.processInitLevelCLI(args, collection, bl);
            return new Status(n3);
        }
        File file = new File(string, "lock");
        int n4 = 0;
        while (n4 < 5) {
            Object object;
            RandomAccessFile randomAccessFile = null;
            FileLock fileLock = null;
            try {
                if (file.isFile()) {
                    if (!bl2 && !file.canWrite()) {
                        return new Status(-254);
                    }
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    CLIHandler.enterState(2, n);
                    fileLock = CLIHandler.tryLock(randomAccessFile);
                    if (OUTPUT.isLoggable(Level.FINER)) {
                        OUTPUT.log(Level.FINER, "tryLock on {0} result: {1}", new Object[]{file, fileLock});
                    }
                    if (fileLock != null && fileLock.isValid()) {
                        CLIHandler.enterState(4, n);
                    } else {
                        CLIHandler.enterState(5, n);
                        if (runnable == null) throw new IOException("EXISTS");
                        runnable.run();
                        runnable = null;
                        throw new IOException("EXISTS");
                    }
                }
                if (n4 == 0 && CLIHandler.checkHelp(args, collection)) {
                    if (runnable == null) return new Status(2);
                    runnable.run();
                    return new Status(2);
                }
                if (fileLock == null) {
                    file.getParentFile().mkdirs();
                    try {
                        randomAccessFile = new RandomAccessFile(file, "rw");
                        fileLock = CLIHandler.tryLock(randomAccessFile);
                        OUTPUT.log(Level.FINER, "tryLock when null on {0} result: {1}", new Object[]{file, fileLock});
                        if (!bl2 && !file.canWrite()) {
                            return new Status(-254);
                        }
                    }
                    catch (IOException iOException) {
                        if (bl2) throw iOException;
                        if (file.getParentFile().canWrite()) throw iOException;
                        return new Status(-254);
                    }
                }
                file.deleteOnExit();
                if (runnable != null) {
                    runnable.run();
                    runnable = null;
                }
                CLIHandler.secureAccess(file);
                CLIHandler.enterState(10, n);
                final byte[] byArray = new byte[10];
                new Random().nextBytes(byArray);
                object = randomAccessFile;
                randomAccessFile.seek(0L);
                server = new Server(new FileAndLock((Closeable)object, fileLock), byArray, n, collection, bl);
                int n5 = server.getLocalPort();
                ((RandomAccessFile)object).writeInt(n5);
                ((RandomAccessFile)object).getChannel().force(true);
                CLIHandler.enterState(20, n);
                RequestProcessor.Task task = secureCLIPort.post(new Runnable((RandomAccessFile)object){
                    final /* synthetic */ RandomAccessFile val$os;
                    {
                        this.val$os = randomAccessFile;
                    }

                    @Override
                    public void run() {
                        SecureRandom secureRandom = null;
                        CLIHandler.enterState(95, n);
                        try {
                            secureRandom = SecureRandom.getInstance("SHA1PRNG");
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            try {
                                secureRandom = SecureRandom.getInstance("IBMSecureRandom");
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                                server.stopServer();
                            }
                        }
                        CLIHandler.enterState(96, n);
                        if (secureRandom != null) {
                            secureRandom.nextBytes(byArray);
                        }
                        CLIHandler.enterState(97, n);
                        try {
                            this.val$os.write(byArray);
                            this.val$os.getChannel().force(true);
                            CLIHandler.enterState(27, n);
                            byte[] byArray2 = InetAddress.getLocalHost().getAddress();
                            if (n != null && n == 667) {
                                throw new UnknownHostException("dhcppc0");
                            }
                            for (int i = 0; i < byArray2.length; ++i) {
                                this.val$os.write(byArray2[i]);
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (!"dhcppc0".equals(unknownHostException.getMessage())) {
                                unknownHostException.printStackTrace();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            this.val$os.getChannel().force(true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                int n6 = CLIHandler.processInitLevelCLI(args, collection, bl);
                CLIHandler.enterState(0, n);
                return new Status(file, server.getLocalPort(), n6, (Task)task);
            }
            catch (IOException iOException) {
                block89: {
                    int n7;
                    byte[] byArray;
                    block90: {
                        if (!"EXISTS".equals(iOException.getMessage())) {
                            iOException.printStackTrace();
                        }
                        object = null;
                        byArray = null;
                        n7 = -1;
                        RandomAccessFile randomAccessFile2 = null;
                        try {
                            CLIHandler.enterState(21, n);
                            if (OUTPUT.isLoggable(Level.FINER)) {
                                OUTPUT.log(Level.FINER, "Reading lock file {0}", file);
                            }
                            randomAccessFile2 = randomAccessFile;
                            n7 = randomAccessFile2.readInt();
                            CLIHandler.enterState(22, n);
                            object = new byte[10];
                            randomAccessFile2.readFully((byte[])object);
                            CLIHandler.enterState(23, n);
                            byte[] byArray2 = new byte[4];
                            randomAccessFile2.readFully(byArray2);
                            CLIHandler.enterState(24, n);
                            byArray = byArray2;
                        }
                        catch (EOFException eOFException) {
                            block88: {
                                if (n7 == -1) break block88;
                                CLIHandler.enterState(94, n);
                                try {
                                    Socket socket = new Socket(CLIHandler.localHostAddress(), n7);
                                    socket.close();
                                }
                                catch (Exception exception) {
                                    file.delete();
                                    if (randomAccessFile2 instanceof Closeable) {
                                        try {
                                            ((Closeable)randomAccessFile2).close();
                                        }
                                        catch (IOException iOException2) {
                                            // empty catch block
                                        }
                                    }
                                    CLIHandler.enterState(25, n);
                                }
                                try {
                                    Thread.sleep(2000L);
                                    break block89;
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                                break block89;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                            if (randomAccessFile2 instanceof Closeable) {
                                try {
                                    ((Closeable)randomAccessFile2).close();
                                }
                                catch (IOException iOException3) {
                                    // empty catch block
                                }
                            }
                            CLIHandler.enterState(25, n);
                            break block90;
                            catch (IOException iOException4) {
                                CLIHandler.enterState(26, n);
                                if (randomAccessFile2 instanceof Closeable) {
                                    try {
                                        ((Closeable)randomAccessFile2).close();
                                    }
                                    catch (IOException iOException5) {
                                        // empty catch block
                                    }
                                }
                                CLIHandler.enterState(25, n);
                                break block90;
                            }
                            finally {
                                if (randomAccessFile2 instanceof Closeable) {
                                    try {
                                        ((Closeable)randomAccessFile2).close();
                                    }
                                    catch (IOException iOException6) {}
                                }
                                CLIHandler.enterState(25, n);
                            }
                        }
                        if (randomAccessFile2 instanceof Closeable) {
                            try {
                                ((Closeable)randomAccessFile2).close();
                            }
                            catch (IOException iOException7) {
                                // empty catch block
                            }
                        }
                        CLIHandler.enterState(25, n);
                    }
                    if (object != null && n7 != -1) {
                        block91: {
                            int n8 = -1;
                            try {
                                block50: while (true) {
                                    CLIHandler.enterState(28, n);
                                    Socket socket = new Socket(CLIHandler.localHostAddress(), n7);
                                    socket.setSoTimeout(5000);
                                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                                    if (n8 == -1) {
                                        dataOutputStream.write(VERSION);
                                    } else {
                                        dataOutputStream.write((byte[])object);
                                    }
                                    assert (VERSION.length == ((Object)object).length);
                                    dataOutputStream.flush();
                                    CLIHandler.enterState(30, n);
                                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                                    byte[] byArray3 = new byte[4096];
                                    block51: while (true) {
                                        CLIHandler.enterState(32, n);
                                        int n9 = dataInputStream.read();
                                        CLIHandler.enterState(34, n);
                                        switch (n9) {
                                            case 14: {
                                                n8 = dataInputStream.readInt();
                                                dataOutputStream.write((byte[])object);
                                                dataOutputStream.flush();
                                                break;
                                            }
                                            case 0: {
                                                if (n8 == -1) {
                                                    dataOutputStream.close();
                                                    dataInputStream.close();
                                                    socket.close();
                                                    n8 = 0;
                                                    continue block50;
                                                }
                                                CLIHandler.enterState(36, n);
                                                break block91;
                                            }
                                            case 1: {
                                                int n10;
                                                CLIHandler.enterState(38, n);
                                                String[] stringArray = args.getArguments();
                                                dataOutputStream.writeInt(stringArray.length);
                                                for (n10 = 0; n10 < stringArray.length; ++n10) {
                                                    dataOutputStream.writeUTF(stringArray[n10]);
                                                }
                                                dataOutputStream.writeUTF(args.getCurrentDirectory().toString());
                                                dataOutputStream.flush();
                                                break;
                                            }
                                            case 2: {
                                                int n10 = dataInputStream.readInt();
                                                if (n10 == 0) {
                                                    n10 = -1;
                                                }
                                                dataOutputStream.close();
                                                dataInputStream.close();
                                                CLIHandler.enterState(0, n);
                                                return new Status(file, n7, n10, null);
                                            }
                                            case 10: {
                                                CLIHandler.enterState(42, n);
                                                int n11 = dataInputStream.readInt();
                                                if (n11 > byArray3.length) {
                                                    byArray3 = new byte[n11];
                                                }
                                                int n12 = args.getInputStream().read(byArray3, 0, n11);
                                                if (n8 >= 1) {
                                                    dataOutputStream.writeInt(n12);
                                                } else {
                                                    dataOutputStream.write(n12);
                                                }
                                                if (n12 > 0) {
                                                    dataOutputStream.write(byArray3, 0, n12);
                                                }
                                                dataOutputStream.flush();
                                                break;
                                            }
                                            case 11: {
                                                CLIHandler.enterState(44, n);
                                                int n11 = dataInputStream.readInt();
                                                if (n11 > byArray3.length) {
                                                    byArray3 = new byte[n11];
                                                }
                                                dataInputStream.read(byArray3, 0, n11);
                                                args.getOutputStream().write(byArray3, 0, n11);
                                                break;
                                            }
                                            case 13: {
                                                CLIHandler.enterState(45, n);
                                                int n11 = dataInputStream.readInt();
                                                if (n11 > byArray3.length) {
                                                    byArray3 = new byte[n11];
                                                }
                                                dataInputStream.read(byArray3, 0, n11);
                                                args.getErrorStream().write(byArray3, 0, n11);
                                                break;
                                            }
                                            case 12: {
                                                CLIHandler.enterState(46, n);
                                                dataOutputStream.writeInt(args.getInputStream().available());
                                                dataOutputStream.flush();
                                                break;
                                            }
                                            case 3: {
                                                CLIHandler.enterState(47, n);
                                                break;
                                            }
                                            case -1: {
                                                CLIHandler.enterState(48, n);
                                                break block91;
                                            }
                                            default: {
                                                CLIHandler.enterState(49, n);
                                                assert (false) : n9;
                                                continue block51;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                CLIHandler.enterState(33, n);
                            }
                            catch (ConnectException connectException) {
                                CLIHandler.enterState(33, n);
                            }
                            catch (IOException iOException8) {
                                iOException8.printStackTrace();
                                CLIHandler.enterState(33, n);
                            }
                        }
                        boolean bl3 = true;
                        if (byArray != null) {
                            try {
                                bl3 = Arrays.equals(InetAddress.getLocalHost().getAddress(), byArray);
                            }
                            catch (UnknownHostException unknownHostException) {
                                CLIHandler.enterState(999, n);
                            }
                        }
                        if (fileLock == null) {
                            return new Status(-255);
                        }
                        if (!bl2) {
                            if (!bl3) return new Status(-255);
                        }
                        file.delete();
                    }
                    try {
                        CLIHandler.enterState(83, n);
                        Thread.sleep((int)(Math.random() * 1000.0));
                        CLIHandler.enterState(85, n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
        }
        return new Status();
    }

    private static void secureAccess(File file) throws IOException {
        file.setReadable(false, false);
        file.setReadable(true, true);
    }

    static {
        OUTPUT = Logger.getLogger(CLIHandler.class.getName());
        doLater = new ArrayList<Execute>();
    }

    private static final class FileAndLock
    implements Closeable {
        private final Closeable file;
        private final FileLock lock;

        public FileAndLock(Closeable closeable, FileLock fileLock) {
            this.file = closeable;
            this.lock = fileLock;
        }

        @Override
        public void close() throws IOException {
            this.lock.release();
            this.file.close();
        }
    }

    private static final class Server
    extends Thread {
        private Closeable unlock;
        private byte[] key;
        private ServerSocket socket;
        private Integer block;
        private Collection<? extends CLIHandler> handlers;
        private Socket work;
        private static volatile int counter;
        private final boolean failOnUnknownOptions;
        private static long lastReply;
        private static long failDelay;

        public Server(Closeable closeable, byte[] byArray, Integer n, Collection<? extends CLIHandler> collection, boolean bl) throws IOException {
            super("CLI Requests Server");
            this.unlock = closeable;
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.failOnUnknownOptions = bl;
            this.socket = new ServerSocket(0, 50, CLIHandler.localHostAddress());
            this.start();
        }

        public Server(Socket socket, byte[] byArray, Integer n, Collection<? extends CLIHandler> collection, boolean bl) throws IOException {
            super("CLI Handler Thread Handler: " + ++counter);
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.work = socket;
            this.failOnUnknownOptions = bl;
            this.start();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        @Override
        public void run() {
            if (this.work != null) {
                try {
                    this.handleConnect(this.work);
                }
                catch (IOException iOException) {
                    OUTPUT.log(Level.INFO, null, iOException);
                }
                return;
            }
            ServerSocket serverSocket = this.socket;
            if (serverSocket == null) {
                return;
            }
            while (this.socket != null) {
                try {
                    CLIHandler.enterState(65, this.block);
                    Socket socket = this.socket.accept();
                    if (this.socket == null) {
                        CLIHandler.enterState(66, this.block);
                        socket.getOutputStream().write(0);
                        CLIHandler.enterState(67, this.block);
                        socket.close();
                        continue;
                    }
                    new Server(socket, this.key, this.block, this.handlers, this.failOnUnknownOptions);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.socket == null) continue;
                    interruptedIOException.printStackTrace();
                }
                catch (SocketException socketException) {
                    if (this.socket == null) continue;
                    socketException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        final void stopServer() {
            OUTPUT.log(Level.FINER, "stopServer, unlock: {0}", this.unlock);
            if (this.unlock != null) {
                try {
                    this.unlock.close();
                }
                catch (IOException iOException) {
                    OUTPUT.log(Level.WARNING, "Cannot unlock {0}", iOException.getMessage());
                }
            }
            this.socket = null;
            this.interrupt();
        }

        private void handleConnect(Socket socket) throws IOException {
            byte by;
            int n;
            byte[] byArray = new byte[this.key.length];
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            CLIHandler.enterState(70, this.block);
            dataInputStream.readFully(byArray);
            final DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            boolean bl = true;
            for (n = 0; n < VERSION.length - 1; ++n) {
                if (VERSION[n] == byArray[n]) continue;
                bl = false;
            }
            if (bl) {
                by = byArray[VERSION.length - 1];
                dataOutputStream.write(14);
                dataOutputStream.writeInt(VERSION[VERSION.length - 1]);
                dataOutputStream.flush();
                dataInputStream.readFully(byArray);
            } else {
                by = 0;
            }
            CLIHandler.enterState(90, this.block);
            if (Arrays.equals(byArray, this.key)) {
                while (!CLIHandler.waitFinishInstallationIsOver(2000)) {
                    dataOutputStream.write(3);
                    dataOutputStream.flush();
                }
                CLIHandler.enterState(93, this.block);
                dataOutputStream.write(1);
                dataOutputStream.flush();
                n = dataInputStream.readInt();
                String[] stringArray = new String[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                String string = dataInputStream.readUTF();
                final Args args = new Args(stringArray, new IS(dataInputStream, dataOutputStream, by), new OS(dataOutputStream, 11), new OS(dataOutputStream, 13), string);
                class ComputingAndNotifying
                extends Thread {
                    public int res;
                    public boolean finished;

                    public ComputingAndNotifying() {
                        super("Computes values in handlers");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.res = CLIHandler.checkHelp(args, Server.this.handlers) ? 2 : CLIHandler.notifyHandlers(args, Server.this.handlers, 2, Server.this.failOnUnknownOptions, false);
                            if (this.res == 0) {
                                CLIHandler.enterState(98, Server.this.block);
                            } else {
                                CLIHandler.enterState(99, Server.this.block);
                            }
                        }
                        finally {
                            ComputingAndNotifying computingAndNotifying = this;
                            synchronized (computingAndNotifying) {
                                this.finished = true;
                                this.notifyAll();
                            }
                        }
                    }

                    public synchronized void waitForResultAndNotifyOthers() {
                        this.start();
                        while (!this.finished) {
                            try {
                                this.wait(1000L);
                                dataOutputStream.write(3);
                                dataOutputStream.flush();
                            }
                            catch (SocketException socketException) {
                                if (Server.isClosedSocket(socketException)) {
                                    args.close();
                                    this.interrupt();
                                    continue;
                                }
                                socketException.printStackTrace();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
                ComputingAndNotifying computingAndNotifying = new ComputingAndNotifying();
                computingAndNotifying.waitForResultAndNotifyOthers();
                try {
                    dataOutputStream.write(2);
                    dataOutputStream.writeInt(computingAndNotifying.res);
                }
                catch (SocketException socketException) {
                    if (Server.isClosedSocket(socketException)) {
                        args.close();
                        computingAndNotifying.interrupt();
                    }
                    throw socketException;
                }
            } else {
                CLIHandler.enterState(103, this.block);
                long l = lastReply + failDelay - System.currentTimeMillis();
                if (l > 0L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    failDelay *= 2L;
                } else {
                    failDelay = 100L;
                }
                lastReply = System.currentTimeMillis();
                dataOutputStream.write(0);
            }
            CLIHandler.enterState(120, this.block);
            dataOutputStream.close();
            dataInputStream.close();
        }

        static final boolean isClosedSocket(SocketException socketException) {
            if (socketException.getMessage().equals("Broken pipe")) {
                return true;
            }
            return socketException.getMessage().startsWith("Connection reset by peer");
        }

        static {
            failDelay = 100L;
        }

        private static final class OS
        extends OutputStream {
            private DataOutputStream os;
            private int type;

            public OS(DataOutputStream dataOutputStream, int n) {
                this.os = dataOutputStream;
                this.type = n;
            }

            @Override
            public void write(int n) throws IOException {
                byte[] byArray = new byte[]{(byte)n};
                this.write(byArray);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.os.write(this.type);
                this.os.writeInt(n2);
                this.os.write(byArray, n, n2);
            }
        }

        private static final class IS
        extends InputStream {
            private final DataInputStream is;
            private final DataOutputStream os;
            private final int requestedVersion;

            public IS(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n) {
                this.is = dataInputStream;
                this.os = dataOutputStream;
                this.requestedVersion = n;
            }

            @Override
            public int read() throws IOException {
                byte[] byArray = new byte[1];
                if (this.read(byArray) == 1) {
                    return byArray[0];
                }
                return -1;
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public int available() throws IOException {
                this.os.write(12);
                this.os.flush();
                return this.is.readInt();
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                this.os.write(10);
                this.os.writeInt(n2);
                this.os.flush();
                int n4 = n3 = this.requestedVersion >= 1 ? this.is.readInt() : this.is.read();
                if (n3 > 0) {
                    return this.is.read(byArray, n, n3);
                }
                return n3;
            }
        }
    }

    public static final class Args {
        private String[] args;
        private final String[] argsBackup;
        private InputStream is;
        private OutputStream os;
        private OutputStream err;
        private File currentDir;
        private boolean closed;

        Args(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String string) {
            this.argsBackup = stringArray;
            this.reset(false);
            this.is = inputStream;
            this.os = outputStream;
            this.err = outputStream2;
            this.currentDir = new File(string);
        }

        void reset(boolean bl) {
            if (bl) {
                String[] stringArray = this.args;
                if (stringArray == null) {
                    stringArray = this.argsBackup;
                }
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList.removeAll(Collections.singleton(null));
                this.args = arrayList.toArray(new String[arrayList.size()]);
            } else {
                this.args = (String[])this.argsBackup.clone();
            }
        }

        final void close() {
            this.closed = true;
        }

        public String[] getArguments() {
            return this.args;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public OutputStream getErrorStream() {
            return this.err;
        }

        public File getCurrentDirectory() {
            return this.currentDir;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public boolean isOpen() {
            return !this.closed;
        }
    }

    static interface Execute {
        public int exec();
    }

    static final class Status {
        public static final int CANNOT_CONNECT = -255;
        public static final int CANNOT_WRITE = -254;
        private final File lockFile;
        private final int port;
        private int exitCode;
        private Task parael;

        Status() {
            this(0);
        }

        Status(int n) {
            this(null, 0, n, null);
        }

        Status(File file, int n, int n2, Task task) {
            this.lockFile = file;
            this.port = n;
            this.exitCode = n2;
            this.parael = task;
        }

        private void waitFinished() {
            if (this.parael != null) {
                this.parael.waitFinished();
            }
        }

        public File getLockFile() {
            this.waitFinished();
            return this.lockFile;
        }

        public int getServerPort() {
            return this.port;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

