/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class CPUSamplingDataFrameProcessor
extends AbstractDataFrameProcessor {
    private volatile int currentThreadId = -1;
    private String currentThreadName;
    private String currentThreadClassName;
    private StackTraceSnapshotBuilder.SampledThreadInfo currentThread;
    private long currentTimestamp;
    private Map<Integer, ThreadInfo> currentThreadsDump;
    private Map<Integer, ThreadInfo> lastThreadsDump;
    private List<ThreadDump> threadDumps = new ArrayList<ThreadDump>();
    private MethodNameFormatter formatter = MethodNameFormatterFactory.getDefault(new DefaultMethodNameFormatter(4)).getFormatter();
    private StackTraceSnapshotBuilder builder;

    @Override
    public void doProcessDataFrame(byte[] byArray) {
        int n = 0;
        JMethodIdTable jMethodIdTable = JMethodIdTable.getDefault();
        this.threadDumps = new ArrayList<ThreadDump>();
        while (n < byArray.length) {
            byte by = byArray[n++];
            switch (by) {
                case 28: {
                    this.currentThreadsDump = new HashMap<Integer, ThreadInfo>();
                    this.currentTimestamp = ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread dump start: Timestamps:" + this.currentTimestamp);
                    break;
                }
                case 11: {
                    char c = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    String string = new String(byArray, n, n2);
                    n += n2;
                    n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    Object object = new String(byArray, n, n2);
                    n += n2;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread: tId=" + c + " name=" + string);
                    }
                    this.currentThreadId = c;
                    this.currentThreadName = string;
                    this.currentThreadClassName = object;
                    break;
                }
                case 30: {
                    char c = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    Integer n3 = c;
                    ThreadInfo threadInfo = this.lastThreadsDump.get(n3);
                    assert (threadInfo != null);
                    this.currentThreadsDump.put(n3, threadInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread info identical: tId:" + c);
                    break;
                }
                case 31: {
                    char c = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    byte by2 = byArray[n++];
                    int n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    Object object = new int[n4];
                    for (int i = 0; i < n4; ++i) {
                        object[i] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                        jMethodIdTable.checkMethodId(object[i]);
                    }
                    ThreadInfo threadInfo = this.currentThreadId == c ? new ThreadInfo(this.currentThreadName, c, by2, (int[])object) : new ThreadInfo(null, c, by2, (int[])object);
                    this.currentThreadsDump.put(Integer.valueOf(c), threadInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread info: tId:" + c + " state:" + by2 + " mIds:" + Arrays.toString(object));
                    break;
                }
                case 29: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Thread dump end");
                    }
                    this.lastThreadsDump = this.currentThreadsDump;
                    this.threadDumps.add(new ThreadDump(this.currentTimestamp, this.currentThreadsDump));
                    break;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    this.builder.reset();
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CallGraphBuilder: {0} at {1}", new Object[]{(int)by, n});
                }
            }
            try {
                jMethodIdTable.getNamesForMethodIds(this.client);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                targetAppOrVMTerminated.printStackTrace();
                return;
            }
            this.processCollectedDumps(jMethodIdTable, this.threadDumps);
            this.threadDumps.clear();
        }
    }

    @Override
    public void startup(ProfilerClient profilerClient) {
        final CPUCallGraphBuilder[] cPUCallGraphBuilderArray = new CPUCallGraphBuilder[1];
        super.startup(profilerClient);
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                cPUCallGraphBuilderArray[0] = (CPUCallGraphBuilder)profilingResultListener;
            }
        });
        this.builder = new StackTraceSnapshotBuilder(cPUCallGraphBuilderArray[0], profilerClient.getSettings().getInstrumentationFilter(), profilerClient.getStatus());
    }

    private static Thread.State getThreadState(int n) {
        switch (n) {
            case -1: {
                return Thread.State.TERMINATED;
            }
            case 0: {
                return Thread.State.TERMINATED;
            }
            case 1: {
                return Thread.State.RUNNABLE;
            }
            case 2: {
                return Thread.State.TIMED_WAITING;
            }
            case 3: {
                return Thread.State.BLOCKED;
            }
            case 4: {
                return Thread.State.WAITING;
            }
        }
        return Thread.State.TERMINATED;
    }

    private void processCollectedDumps(JMethodIdTable jMethodIdTable, List<ThreadDump> list) {
        HashMap<Integer, StackTraceElement> hashMap = new HashMap<Integer, StackTraceElement>();
        InstrumentationFilter instrumentationFilter = this.builder.getFilter();
        for (ThreadDump threadDump : list) {
            StackTraceSnapshotBuilder.SampledThreadInfo[] sampledThreadInfoArray = new StackTraceSnapshotBuilder.SampledThreadInfo[threadDump.threadDumps.length];
            int n = 0;
            for (ThreadInfo threadInfo : threadDump.threadDumps) {
                int[] nArray = threadInfo.methodsIds;
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i];
                    StackTraceElement stackTraceElement = (StackTraceElement)hashMap.get(n2);
                    if (stackTraceElement == null) {
                        JMethodIdTable.JMethodIdTableEntry jMethodIdTableEntry = jMethodIdTable.getEntry(n2);
                        String string = this.formatter.formatMethodName(jMethodIdTableEntry.className, jMethodIdTableEntry.methodName, jMethodIdTableEntry.methodSig).toFormatted();
                        String string2 = jMethodIdTableEntry.className.replace('/', '.');
                        stackTraceElement = new StackTraceElement(string2, string, jMethodIdTableEntry.methodSig, -1);
                        hashMap.put(n2, stackTraceElement);
                    }
                    stackTraceElementArray[i] = stackTraceElement;
                }
                sampledThreadInfoArray[n++] = new StackTraceSnapshotBuilder.SampledThreadInfo(threadInfo.threadName, threadInfo.threadId, threadInfo.state, stackTraceElementArray, instrumentationFilter);
            }
            this.builder.addStacktrace(sampledThreadInfoArray, threadDump.timestamp);
        }
    }

    private static final class ThreadDump {
        private long timestamp;
        private ThreadInfo[] threadDumps;

        ThreadDump(long l, Map<Integer, ThreadInfo> map) {
            this.timestamp = l;
            this.threadDumps = map.values().toArray(new ThreadInfo[map.size()]);
        }
    }

    private static final class ThreadInfo {
        private int[] methodsIds;
        private Thread.State state;
        private String threadName;
        private long threadId;

        ThreadInfo(String string, long l, byte by, int[] nArray) {
            this.threadName = string;
            this.threadId = l;
            this.state = CPUSamplingDataFrameProcessor.getThreadState(by);
            this.methodsIds = nArray;
        }
    }
}

