/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassRewriter {
    public static byte[] rewriteClassFile(DynamicClassInfo dynamicClassInfo, byte[][] byArray, int n, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            byArray3 = dynamicClassInfo.getClassFileBytes();
        }
        catch (IOException iOException) {
            MiscUtils.internalError("ClassRewriter: can't get original class file bytes for class " + dynamicClassInfo.getName() + "\nIOException message = " + iOException.getMessage());
        }
        int n2 = byArray3.length;
        n2 += byArray2.length;
        int n3 = dynamicClassInfo.getMethodNames().length;
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == null) continue;
            n2 += byArray[i].length - dynamicClassInfo.getOrigMethodInfoLength(i);
        }
        byte[] byArray4 = new byte[n2];
        int n4 = 0;
        System.arraycopy(byArray3, 0, byArray4, n4, dynamicClassInfo.getOrigIntermediateDataStartOfs());
        System.arraycopy(byArray2, 0, byArray4, n4 += dynamicClassInfo.getOrigIntermediateDataStartOfs(), byArray2.length);
        n4 += byArray2.length;
        int n5 = dynamicClassInfo.getOrigCPoolCount() + n;
        int n6 = dynamicClassInfo.getOrigCPoolStartOfs();
        byArray4[n6] = (byte)(n5 >> 8 & 0xFF);
        byArray4[n6 + 1] = (byte)(n5 & 0xFF);
        int n7 = dynamicClassInfo.getOrigMethodsStartOfs() - dynamicClassInfo.getOrigIntermediateDataStartOfs();
        System.arraycopy(byArray3, dynamicClassInfo.getOrigIntermediateDataStartOfs(), byArray4, n4, n7);
        byArray4[n4 += n7] = (byte)(n3 >> 8 & 0xFF);
        byArray4[n4 + 1] = (byte)(n3 & 0xFF);
        n4 += 2;
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] != null) {
                System.arraycopy(byArray[i], 0, byArray4, n4, byArray[i].length);
                n4 += byArray[i].length;
                continue;
            }
            byte[] byArray5 = dynamicClassInfo.getOrigMethodInfo(i);
            System.arraycopy(byArray5, 0, byArray4, n4, byArray5.length);
            n4 += byArray5.length;
        }
        n7 = byArray3.length - dynamicClassInfo.getOrigAttrsStartOfs();
        System.arraycopy(byArray3, dynamicClassInfo.getOrigAttrsStartOfs(), byArray4, n4, n7);
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToDisk(String string, byte[] byArray) {
        if (Platform.getJDKVersionNumber() == 5) {
            return;
        }
        string = string.replace('/', '_');
        try {
            System.err.print("*** Gonna save bytecode " + string + " to disk... ");
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string + ".class"));
            try {
                ((OutputStream)fileOutputStream).write(byArray);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            System.err.println("done");
        }
        catch (Exception exception) {
            System.err.println("*** In RecursiveMethodInstrumentor.saveClassFileToDisk caught ex = " + exception);
        }
    }

    private static void saveClassFileToDisk(DynamicClassInfo dynamicClassInfo, byte[] byArray) {
        ClassRewriter.saveToDisk(dynamicClassInfo.getName(), byArray);
    }
}

