/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.DataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;

public abstract class AbstractDataFrameProcessor
implements DataFrameProcessor {
    protected static final Logger LOGGER = Logger.getLogger(DataFrameProcessor.class.getName());
    protected volatile ProfilerClient client = null;
    private final Set listeners = new CopyOnWriteArraySet();
    private boolean processorLives = false;

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDataFrame(byte[] byArray) {
        ProfilerClient profilerClient = this.client;
        synchronized (profilerClient) {
            AbstractDataFrameProcessor abstractDataFrameProcessor = this;
            synchronized (abstractDataFrameProcessor) {
                if (!this.processorLives) {
                    return;
                }
                try {
                    this.fireBatchStart();
                    this.doProcessDataFrame(byArray);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Error while processing data frame", exception);
                }
                finally {
                    this.fireBatchStop();
                }
            }
        }
    }

    public void removeAllListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ProfilingResultListener)iterator.next()).shutdown();
        }
        this.listeners.clear();
    }

    @Override
    public void reset() {
        this.fireReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = false;
            this.fireShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(ProfilerClient profilerClient) {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = true;
            this.client = profilerClient;
        }
    }

    protected void addListener(ProfilingResultListener profilingResultListener) {
        this.listeners.add(profilingResultListener);
    }

    protected abstract void doProcessDataFrame(byte[] var1);

    protected void fireProfilingPoint(final int n, final int n2, final long l) {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.profilingPoint(n, n2, l);
            }
        });
    }

    protected void fireReset() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.reset();
            }
        });
    }

    protected void foreachListener(ListenerFunctor listenerFunctor) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            listenerFunctor.execute((ProfilingResultListener)iterator.next());
        }
    }

    protected void removeListener(ProfilingResultListener profilingResultListener) {
        if (this.listeners.remove(profilingResultListener)) {
            profilingResultListener.shutdown();
        }
    }

    private void fireBatchStart() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.onBatchStart();
            }
        });
    }

    private void fireBatchStop() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.onBatchStop();
            }
        });
    }

    private void fireShutdown() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.shutdown();
            }
        });
    }

    protected static interface ListenerFunctor {
        public void execute(ProfilingResultListener var1);
    }
}

