/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class LivenessResultsPanel
extends MemoryResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String FILTER_MENU_ITEM_NAME = messages.getString("LivenessResultsPanel_FilterMenuItemName");
    private static final String CLASS_COLUMN_NAME = messages.getString("LivenessResultsPanel_ClassColumnName");
    private static final String LIVE_BYTES_REL_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveBytesRelColumnName");
    private static final String LIVE_BYTES_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveBytesColumnName");
    private static final String LIVE_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveObjectsColumnName");
    private static final String ALLOC_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_AllocObjectsColumnName");
    private static final String AVG_AGE_COLUMN_NAME = messages.getString("LivenessResultsPanel_AvgAgeColumnName");
    private static final String SURVGEN_COLUMN_NAME = messages.getString("LivenessResultsPanel_SurvGenColumnName");
    private static final String TOTAL_ALLOC_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_TotalAllocObjectsColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_ClassColumnToolTip");
    private static final String LIVE_BYTES_REL_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveBytesRelColumnToolTip");
    private static final String LIVE_BYTES_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveBytesColumnToolTip");
    private static final String LIVE_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveObjectsColumnToolTip");
    private static final String ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_AllocObjectsColumnToolTip");
    private static final String AVG_AGE_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_AvgAgeColumnToolTip");
    private static final String SURVGEN_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_SurvGenColumnToolTip");
    private static final String TOTAL_ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_TotalAllocObjectsColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("LivenessResultsPanel_TableAccessName");
    protected float[] avgObjectAge;
    protected int[] maxSurvGen;
    protected int[] nTotalAllocObjects;
    protected long[] nTrackedAllocObjects;
    protected int[] nTrackedLiveObjects;
    protected long[] trackedLiveObjectsSize;
    protected int nInstrClasses;
    protected int trackedAllocObjects;
    protected int trackedLiveObjects;
    protected long nTotalTracked;
    protected long nTotalTrackedBytes;
    private int initialSortingColumn;
    private int minNamesColumnWidth;

    public LivenessResultsPanel(MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(memoryResUserActionsHandler);
        this.setDefaultSorting();
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = n;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = bl;
        }
    }

    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new CustomBarCellRenderer(0L, this.maxValue);
    }

    protected void getResultsSortedByAllocObj() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTrackedAllocObjects, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize}, (float[][])new float[][]{this.avgObjectAge}, 0, n, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByAvgAge() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.avgObjectAge, new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, 0, n, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByClassName(boolean bl) {
        this.nInfoLines = this.sortResultsByClassName(new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, new float[][]{this.avgObjectAge}, this.nTrackedItems, this.truncateZeroItems());
        if (!bl) {
            this.totalAllocations = 0L;
            this.trackedAllocObjects = 0;
            this.trackedLiveObjects = 0;
            for (int i = 0; i < this.nInfoLines; ++i) {
                this.trackedLiveObjects += this.nTrackedLiveObjects[i];
                this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
                this.totalAllocations += (long)this.nTotalAllocObjects[i];
            }
        }
    }

    protected void getResultsSortedByLiveObjNumber() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTrackedLiveObjects, (int[][])new int[][]{this.nTotalAllocObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, n, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByLiveObjSize() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.trackedLiveObjectsSize, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, n, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedBySurvGen() {
        int n;
        this.getResultsSortedByClassName(true);
        int n2 = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.maxSurvGen, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, n2, false);
        int n3 = this.maxSurvGen[0];
        int n4 = 0;
        while (n3 > 0) {
            for (n = n4; this.maxSurvGen[n] == n3 && n < this.nInfoLines; ++n) {
            }
            if (n <= n4) continue;
            this.sortResults(this.trackedLiveObjectsSize, (int[][])new int[][]{this.nTrackedLiveObjects, this.nTotalAllocObjects, this.maxSurvGen}, (long[][])new long[][]{this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, n4, n - n4, false);
            n4 = n;
            n3 = this.maxSurvGen[n];
        }
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (n = 0; n < this.nInfoLines; ++n) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[n];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[n]);
            this.totalAllocations += (long)this.nTotalAllocObjects[n];
        }
    }

    protected void getResultsSortedByTotalAllocObj() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTotalAllocObjects, (int[][])new int[][]{this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, n, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    @Override
    protected JExtendedTable getResultsTable() {
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        this.totalAllocations = 0L;
        this.sortResults();
        if (this.resTable == null) {
            this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

                @Override
                public String getColumnName(int n) {
                    return LivenessResultsPanel.this.columnNames[n];
                }

                @Override
                public int getRowCount() {
                    return LivenessResultsPanel.this.nDisplayedItems;
                }

                @Override
                public int getColumnCount() {
                    return LivenessResultsPanel.this.columnNames.length;
                }

                public Class getColumnClass(int n) {
                    return LivenessResultsPanel.this.columnTypes[n];
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return LivenessResultsPanel.this.computeValueAt(n, n2);
                }

                @Override
                public String getColumnToolTipText(int n) {
                    return LivenessResultsPanel.this.columnToolTips[n];
                }

                @Override
                public void sortByColumn(int n, boolean bl) {
                    LivenessResultsPanel.this.sortBy = LivenessResultsPanel.this.getSortBy(n);
                    LivenessResultsPanel.this.sortOrder = bl;
                    int n2 = LivenessResultsPanel.this.resTable.getSelectedRow();
                    String string = null;
                    if (n2 != -1) {
                        string = (String)LivenessResultsPanel.this.resTable.getValueAt(n2, 0);
                    }
                    LivenessResultsPanel.this.prepareResults();
                    if (string != null) {
                        LivenessResultsPanel.this.resTable.selectRowByContents(string, 0, true);
                    }
                }

                @Override
                public boolean getInitialSorting(int n) {
                    switch (n) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.resTableModel.setRealColumnVisibility(7, false);
            this.resTableModel.setRealColumnVisibility(4, false);
            this.resTableModel.setRealColumnVisibility(5, false);
            this.resTable = new JExtendedTable(this.resTableModel){

                @Override
                public void doLayout() {
                    int n = 0;
                    int n2 = -1;
                    for (int i = 0; i < LivenessResultsPanel.this.resTableModel.getColumnCount(); ++i) {
                        int n3 = LivenessResultsPanel.this.resTableModel.getRealColumn(i);
                        if (n3 == 0) {
                            n2 = i;
                            continue;
                        }
                        n += this.getColumnModel().getColumn(i).getPreferredWidth();
                    }
                    if (n2 != -1) {
                        this.getColumnModel().getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, LivenessResultsPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
            this.resTableModel.setTable(this.resTable);
            this.resTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
            this.resTable.setRowSelectionAllowed(true);
            this.resTable.setSelectionMode(0);
            this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.resTable.setShowHorizontalLines(false);
            this.resTable.setShowVerticalLines(true);
            this.resTable.setRowMargin(0);
            this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
            hashSet.add(KeyStroke.getKeyStroke(9, 0));
            this.resTable.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
            hashSet.add(KeyStroke.getKeyStroke(9, 1));
            this.resTable.setFocusTraversalKeys(1, hashSet);
            this.setColumnsData();
        }
        return this.resTable;
    }

    protected Object computeValueAt(int n, int n2) {
        int n3 = (Integer)this.filteredToFullIndexes.get(n);
        switch (n2) {
            case 0: {
                return this.sortedClassNames[n3];
            }
            case 1: {
                return new Long(this.trackedLiveObjectsSize[n3]);
            }
            case 2: {
                return this.intFormat.format(this.trackedLiveObjectsSize[n3]) + " B (" + (this.nTotalTrackedBytes == 0L ? "-%" : this.percentFormat.format((float)this.trackedLiveObjectsSize[n3] / (float)this.nTotalTrackedBytes)) + ")";
            }
            case 3: {
                return this.intFormat.format(this.nTrackedLiveObjects[n3]) + " (" + (this.nTotalTracked == 0L ? "-%" : this.percentFormat.format((float)this.nTrackedLiveObjects[n3] / (float)this.nTotalTracked)) + ")";
            }
            case 4: {
                return this.intFormat.format(this.nTrackedAllocObjects[n3]);
            }
            case 5: {
                return StringUtils.floatPerCentToString((float)this.avgObjectAge[n3]);
            }
            case 6: {
                return this.intFormat.format(this.maxSurvGen[n3]);
            }
            case 7: {
                return this.intFormat.format(this.nTotalAllocObjects[n3]);
            }
        }
        return null;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnNames.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.resTable != null) {
                jCheckBoxMenuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.headerPopup.add(jCheckBoxMenuItem);
        }
        this.headerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_MENU_ITEM_NAME);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.isVisible());
        }
        this.headerPopup.add(jCheckBoxMenuItem);
        this.headerPopup.pack();
    }

    protected void initColumnsData() {
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 10;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{CLASS_COLUMN_NAME, LIVE_BYTES_REL_COLUMN_NAME, LIVE_BYTES_COLUMN_NAME, LIVE_OBJECTS_COLUMN_NAME, ALLOC_OBJECTS_COLUMN_NAME, AVG_AGE_COLUMN_NAME, SURVGEN_COLUMN_NAME, TOTAL_ALLOC_OBJECTS_COLUMN_NAME};
        this.columnToolTips = new String[]{CLASS_COLUMN_TOOLTIP, LIVE_BYTES_REL_COLUMN_TOOLTIP, LIVE_BYTES_COLUMN_TOOLTIP, LIVE_OBJECTS_COLUMN_TOOLTIP, ALLOC_OBJECTS_COLUMN_TOOLTIP, AVG_AGE_COLUMN_TOOLTIP, SURVGEN_COLUMN_TOOLTIP, TOTAL_ALLOC_OBJECTS_COLUMN_TOOLTIP};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class, String.class, Number.class, Number.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer};
        this.columnWidths = new int[]{n, n, n, n, n, n, n, n};
    }

    @Override
    protected boolean passesValueFilter(int n) {
        return (double)this.trackedLiveObjectsSize[n] / (double)this.nTotalTrackedBytes * 100.0 >= this.valueFilterValue;
    }

    private void setColumnsData() {
        this.barRenderer = this.getBarCellRenderer();
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            if (n == 1) {
                tableColumnModel.getColumn(i).setCellRenderer(this.barRenderer);
                continue;
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private int getSortBy(int n) {
        switch (n) {
            case 0: {
                return 6;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
        }
        return 1;
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    LivenessResultsPanel.this.filterComponent.setVisible(!LivenessResultsPanel.this.filterComponent.isVisible());
                    return;
                }
                LivenessResultsPanel.this.saveColumnsData();
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = LivenessResultsPanel.this.resTableModel.getSortingColumn();
                int n3 = LivenessResultsPanel.this.resTableModel.getRealColumn(n2);
                boolean bl2 = LivenessResultsPanel.this.resTableModel.isRealColumnVisible(n);
                if (bl2 && n == n3) {
                    n2 = n2 + 1 == LivenessResultsPanel.this.resTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = LivenessResultsPanel.this.resTableModel.getRealColumn(n2);
                    bl = true;
                }
                LivenessResultsPanel.this.resTableModel.setRealColumnVisibility(n, !bl2);
                LivenessResultsPanel.this.resTable.createDefaultColumnsFromModel();
                LivenessResultsPanel.this.resTableModel.setTable(LivenessResultsPanel.this.resTable);
                n2 = LivenessResultsPanel.this.resTableModel.getVirtualColumn(n3);
                if (bl) {
                    LivenessResultsPanel.this.sortOrder = LivenessResultsPanel.this.resTableModel.getInitialSorting(n2);
                    LivenessResultsPanel.this.sortBy = LivenessResultsPanel.this.getSortBy(n3);
                    LivenessResultsPanel.this.sortResults();
                    LivenessResultsPanel.this.resTable.repaint();
                }
                LivenessResultsPanel.this.resTableModel.setInitialSorting(n2, LivenessResultsPanel.this.sortOrder);
                LivenessResultsPanel.this.resTable.getTableHeader().repaint();
                LivenessResultsPanel.this.setColumnsData();
            }
        });
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void sortResults() {
        switch (this.sortBy) {
            case 6: {
                this.getResultsSortedByClassName(false);
                break;
            }
            case 1: {
                this.getResultsSortedByLiveObjSize();
                break;
            }
            case 2: {
                this.getResultsSortedByLiveObjNumber();
                break;
            }
            case 3: {
                this.getResultsSortedByAllocObj();
                break;
            }
            case 4: {
                this.getResultsSortedByAvgAge();
                break;
            }
            case 5: {
                this.getResultsSortedBySurvGen();
                break;
            }
            case 7: {
                this.getResultsSortedByTotalAllocObj();
            }
        }
        this.createFilteredIndexes();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.intFormat.setMaximumFractionDigits(2);
        this.intFormat.setMinimumFractionDigits(2);
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
        this.intFormat.setMaximumFractionDigits(1);
        this.intFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append("<th>" + this.columnNames[n] + "</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[n]) + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.trackedLiveObjectsSize[n] + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.nTrackedLiveObjects[n] + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.nTrackedAllocObjects[n] + "</td>");
            stringBuffer.append("<td align=\"char\" char=\".\">" + this.intFormat.format(this.avgObjectAge[n]) + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.maxSurvGen[n] + "</td></tr>");
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\">" + string2);
        stringBuffer.append(" <TableData NumRows=\"" + this.nTrackedItems + "\" NumColumns=\"6\">" + string2);
        stringBuffer.append("<TableHeader>");
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append("  <TableColumn><![CDATA[" + this.columnNames[n] + "]]></TableColumn>" + string2);
        }
        stringBuffer.append("</TableHeader>");
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("  <TableRow>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.sortedClassNames[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.trackedLiveObjectsSize[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.nTrackedLiveObjects[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.nTrackedAllocObjects[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.intFormat.format(this.avgObjectAge[n]) + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.maxSurvGen[n] + "]]></TableColumn>" + string2 + "  </TableRow>" + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append(string3 + this.columnNames[n] + string3 + string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3 + this.sortedClassNames[n] + string3 + string);
            stringBuffer.append(string3 + this.trackedLiveObjectsSize[n] + string3 + string);
            stringBuffer.append(string3 + this.nTrackedLiveObjects[n] + string3 + string);
            stringBuffer.append(string3 + this.nTrackedAllocObjects[n] + string3 + string);
            stringBuffer.append(string3 + this.intFormat.format(this.avgObjectAge[n]) + string3 + string);
            stringBuffer.append(string3 + this.maxSurvGen[n] + string3 + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

