/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class SnippetPanel
extends JPanel
implements MouseListener,
KeyListener,
FocusListener {
    private static Color lineColor;
    private static Color backgroundColor;
    private static Color focusedBackgroundColor;
    private JComponent content;
    private String snippetName;
    private Title title;
    private boolean collapsed = false;

    public SnippetPanel(String string, JComponent jComponent) {
        this.snippetName = string;
        this.content = jComponent;
        this.setLayout(new BorderLayout());
        this.title = new Title(string){

            @Override
            public AccessibleContext getAccessibleContext() {
                return SnippetPanel.this.getAccessibleContext();
            }
        };
        this.title.setFocusable(true);
        this.title.addKeyListener(this);
        this.title.addMouseListener(this);
        this.title.addFocusListener(this);
        this.title.setToolTipText(jComponent.getToolTipText());
        jComponent.setToolTipText(null);
        this.add((Component)this.title, "North");
        this.add((Component)jComponent, "Center");
        this.getAccessibleContext().setAccessibleName(string);
    }

    private static void initColors() {
        boolean bl;
        Color color = UIUtils.getProfilerResultsBackground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        boolean bl2 = bl = n < 41 || n2 < 32 || n3 < 25;
        if (bl) {
            lineColor = UIUtils.getSafeColor(n + 41, n2 + 32, n3 + 8);
            backgroundColor = UIUtils.getSafeColor(n + 7, n2 + 7, n3 + 7);
            focusedBackgroundColor = UIUtils.getSafeColor(n + 25, n2 + 25, n3 + 25);
        } else {
            lineColor = UIUtils.getSafeColor(n - 41, n2 - 32, n3 - 8);
            backgroundColor = UIUtils.getSafeColor(n - 7, n2 - 7, n3 - 7);
            focusedBackgroundColor = UIUtils.getSafeColor(n - 25, n2 - 25, n3 - 25);
        }
    }

    public void setCollapsed(boolean bl) {
        if (this.collapsed == bl) {
            return;
        }
        this.collapsed = bl;
        if (bl) {
            this.title.collapse();
        } else {
            this.title.expand();
        }
        this.content.setVisible(!bl);
        this.revalidate();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setSnippetName(String string) {
        this.snippetName = string;
    }

    public String getSnippetName() {
        return this.snippetName;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.title.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.title.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.setCollapsed(!this.isCollapsed());
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.title.setCursor(Cursor.getPredefinedCursor(12));
        this.title.setRollOver(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.title.setCursor(Cursor.getPredefinedCursor(0));
        this.title.setRollOver(false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setCollapsed(!this.collapsed);
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void requestFocus() {
        if (this.title != null) {
            this.title.requestFocus();
        }
    }

    static {
        SnippetPanel.initColors();
    }

    private static class TitleUI
    extends ComponentUI {
        private final int TITLE_X_OFFSET = 5;
        private final int TITLE_Y_OFFSET = 2;
        private final ImageIcon collapsedIcon = Icons.getImageIcon((String)"GeneralIcons.CollapsedSnippet");
        private final ImageIcon expandedIcon = Icons.getImageIcon((String)"GeneralIcons.ExpandedSnippet");
        private final JLabel plainPainter = new JLabel();
        private final JLabel boldPainter = new JLabel();
        private final Font plainFont = this.plainPainter.getFont().deriveFont(0);
        private final Font boldFont = this.boldPainter.getFont().deriveFont(1);
        private Dimension preferredSize;

        private TitleUI() {
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return this.preferredSize;
        }

        @Override
        public void installUI(JComponent jComponent) {
            this.plainPainter.setText(((Title)jComponent).name);
            this.plainPainter.setIcon(this.collapsedIcon);
            this.plainPainter.setFont(this.plainFont);
            this.plainPainter.setIconTextGap(5);
            this.boldPainter.setText(((Title)jComponent).name);
            this.boldPainter.setIcon(this.expandedIcon);
            this.boldPainter.setFont(this.boldFont);
            this.boldPainter.setIconTextGap(5);
            this.plainPainter.setSize(this.plainPainter.getPreferredSize());
            Dimension dimension = this.boldPainter.getPreferredSize();
            this.boldPainter.setSize(dimension);
            this.preferredSize = new Dimension(5 + dimension.width, dimension.height + 4);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Title title = (Title)jComponent;
            graphics.setColor(lineColor);
            graphics.drawLine(0, 0, jComponent.getWidth(), 0);
            if (title.collapsed) {
                if (title.rollOver || title.isFocusOwner()) {
                    graphics.setColor(focusedBackgroundColor);
                } else {
                    graphics.setColor(backgroundColor);
                }
            }
            graphics.drawLine(0, 1 + this.plainPainter.getHeight() + 2, jComponent.getWidth(), 1 + this.plainPainter.getHeight() + 2);
            if (title.rollOver || title.isFocusOwner()) {
                graphics.setColor(focusedBackgroundColor);
            } else {
                graphics.setColor(backgroundColor);
            }
            graphics.fillRect(0, 1, jComponent.getWidth(), this.plainPainter.getHeight() + 2);
            graphics.translate(5, 2);
            if (title.collapsed) {
                this.plainPainter.paint(graphics);
            } else {
                this.boldPainter.paint(graphics);
            }
            graphics.translate(-5, -2);
        }
    }

    private static class Title
    extends JComponent
    implements Accessible {
        String name;
        private boolean collapsed;
        private boolean rollOver;

        private Title(String string) {
            this.name = string;
            this.setUI(new TitleUI());
        }

        public void setRollOver(boolean bl) {
            if (bl == this.rollOver) {
                return;
            }
            this.rollOver = bl;
            this.repaint();
        }

        public void collapse() {
            this.collapsed = true;
            this.repaint();
        }

        public void expand() {
            this.collapsed = false;
            this.repaint();
        }
    }

    public static class Padding
    extends JPanel {
        public Padding() {
            this.setBackground(UIUtils.getProfilerResultsBackground());
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(lineColor);
            graphics.drawLine(0, 0, this.getWidth(), 0);
        }
    }
}

