/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.fallback;

import java.awt.GraphicsEnvironment;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.keyring.fallback.MasterPasswordPanel;
import org.netbeans.modules.keyring.impl.Utils;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.openide.util.Mutex;
import org.openide.util.NbPreferences;

public class MasterPasswordEncryption
implements EncryptionProvider {
    private static final Logger LOG = Logger.getLogger(MasterPasswordEncryption.class.getName());
    private static final String ENCRYPTION_ALGORITHM = "PBEWithSHA1AndDESede";
    private SecretKeyFactory KEY_FACTORY;
    private AlgorithmParameterSpec PARAM_SPEC;
    private Cipher encrypt;
    private Cipher decrypt;
    private boolean unlocked;
    private Callable<Void> encryptionChanging;
    private char[] newMasterPassword;
    private boolean fresh;

    @Override
    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.master")) {
            LOG.fine("master password encryption disabled");
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            LOG.fine("disabling master password encryption in headless mode");
            return false;
        }
        try {
            this.KEY_FACTORY = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            this.encrypt = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            this.decrypt = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            Preferences preferences = NbPreferences.forModule(Keyring.class);
            Utils.goMinusR(preferences);
            String string = "salt";
            byte[] byArray = preferences.getByteArray(string, null);
            if (byArray == null) {
                byArray = UUID.randomUUID().toString().getBytes();
                preferences.putByteArray(string, byArray);
            }
            this.PARAM_SPEC = new PBEParameterSpec(byArray, 20);
            LOG.warning("Falling back to master password encryption; add -J-Dorg.netbeans.modules.keyring.level=0 to netbeans.conf to see why native keyrings could not be loaded");
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Cannot initialize security using PBEWithSHA1AndDESede", exception);
            return false;
        }
    }

    @Override
    public String id() {
        return "general";
    }

    @Override
    public byte[] encrypt(char[] cArray) throws Exception {
        if (!this.unlockIfNecessary()) {
            throw new Exception("cannot unlock");
        }
        try {
            return this.doEncrypt(cArray);
        }
        catch (Exception exception) {
            this.unlocked = false;
            throw exception;
        }
    }

    @Override
    public char[] decrypt(byte[] byArray) throws Exception {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        if (!this.unlockIfNecessary(atomicBoolean)) {
            throw new Exception("cannot unlock");
        }
        try {
            char[] cArray = this.doDecrypt(byArray);
            return cArray;
        }
        catch (Exception exception) {
            this.unlocked = false;
            throw exception;
        }
        finally {
            if (atomicBoolean.get()) {
                try {
                    this.encryptionChanging.call();
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "failed to change encryption", exception);
                }
            }
        }
    }

    private boolean unlockIfNecessary() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = this.unlockIfNecessary(atomicBoolean);
        if (atomicBoolean.get()) {
            try {
                this.encryptionChanging.call();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "failed to change encryption", exception);
            }
        }
        return bl;
    }

    private boolean unlockIfNecessary(AtomicBoolean atomicBoolean) {
        if (this.unlocked) {
            return true;
        }
        char[][] cArray = (char[][])Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<char[][]>(){

            public char[][] run() {
                return new MasterPasswordPanel().display(MasterPasswordEncryption.this.fresh);
            }
        });
        if (cArray == null) {
            LOG.fine("cancelled master password dialog");
            return false;
        }
        try {
            this.unlock(cArray[0]);
            Arrays.fill(cArray[0], '\u0000');
            if (cArray.length == 2) {
                this.newMasterPassword = cArray[1];
                LOG.fine("will set new master password");
                atomicBoolean.set(true);
            }
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "failed to initialize ciphers", exception);
            return false;
        }
    }

    void unlock(char[] cArray) throws Exception {
        LOG.fine("switching to new master password");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKey secretKey = this.KEY_FACTORY.generateSecret(pBEKeySpec);
        this.encrypt.init(1, (Key)secretKey, this.PARAM_SPEC);
        this.decrypt.init(2, (Key)secretKey, this.PARAM_SPEC);
        this.unlocked = true;
    }

    byte[] doEncrypt(char[] cArray) throws Exception {
        assert (this.unlocked);
        byte[] byArray = Utils.chars2Bytes(cArray);
        byte[] byArray2 = this.encrypt.doFinal(byArray);
        Arrays.fill(byArray, (byte)0);
        return byArray2;
    }

    char[] doDecrypt(byte[] byArray) throws Exception {
        assert (this.unlocked);
        byte[] byArray2 = this.decrypt.doFinal(byArray);
        char[] cArray = Utils.bytes2Chars(byArray2);
        Arrays.fill(byArray2, (byte)0);
        return cArray;
    }

    @Override
    public boolean decryptionFailed() {
        this.unlocked = false;
        return this.unlockIfNecessary();
    }

    @Override
    public void encryptionChangingCallback(Callable<Void> callable) {
        this.encryptionChanging = callable;
    }

    @Override
    public void encryptionChanged() {
        assert (this.newMasterPassword != null);
        LOG.fine("encryption changed");
        try {
            this.unlock(this.newMasterPassword);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "failed to initialize ciphers", exception);
        }
        Arrays.fill(this.newMasterPassword, '\u0000');
        this.newMasterPassword = null;
    }

    @Override
    public void freshKeyring(boolean bl) {
        this.fresh = bl;
    }
}

