/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.uitoolkit.impl.fx.ui.CertificateDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.UITextArea;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

class MoreInfoDialog
extends FXDialog {
    private Hyperlink details;
    private String[] alerts;
    private String[] infos;
    private int securityInfoCount;
    private Certificate[] certs;
    private int start;
    private int end;
    private boolean sandboxApp = false;
    private final String WARNING_ICON = "warning16.image";
    private final String INFO_ICON = "info16.image";
    private final int VERTICAL_STRUT = 18;
    private final int HORIZONTAL_STRUT = 12;
    private final int TEXT_WIDTH = 326;

    MoreInfoDialog(Stage parent, String[] alerts, String[] infos, int securityInfoCount, Certificate[] certs, int start, int end, boolean sandboxApp) {
        super(ResourceManager.getMessage("security.more.info.title"), parent, true);
        this.alerts = alerts;
        this.infos = infos;
        this.securityInfoCount = securityInfoCount;
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.sandboxApp = sandboxApp;
        this.initComponents(null, null);
        this.setResizable(false);
    }

    MoreInfoDialog(Stage parent, Pane detailPanel, Throwable throwable, Certificate[] certs) {
        super(ResourceManager.getMessage("security.more.info.title"));
        this.certs = certs;
        this.start = 0;
        this.end = certs == null ? 0 : certs.length;
        this.initComponents(detailPanel, throwable);
    }

    private void initComponents(Pane detailPanel, Throwable throwable) {
        VBox contentPanel = new VBox();
        contentPanel.setId("more-info-dialog");
        if (detailPanel != null) {
            VBox.setVgrow(detailPanel, Priority.ALWAYS);
            contentPanel.getChildren().add(detailPanel);
        } else if (throwable != null) {
            BorderPane labelPanel = new BorderPane();
            Label label = new Label(ResourceManager.getString("exception.details.label"));
            labelPanel.setLeft(label);
            contentPanel.getChildren().add(labelPanel);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            TextArea text = new TextArea(sw.toString());
            text.setEditable(false);
            text.setWrapText(true);
            text.setPrefWidth(480.0);
            text.setPrefHeight(240.0);
            ScrollPane sp = new ScrollPane();
            sp.setContent(text);
            sp.setFitToWidth(true);
            VBox.setVgrow(sp, Priority.ALWAYS);
            contentPanel.getChildren().add(sp);
            if (this.certs != null) {
                contentPanel.getChildren().add(this.getLinkPanel());
            }
        } else {
            Pane securityPanel = this.getSecurityPanel();
            if (securityPanel.getChildren().size() > 0) {
                VBox.setVgrow(securityPanel, Priority.ALWAYS);
                contentPanel.getChildren().add(securityPanel);
            }
            if (this.certs != null) {
                contentPanel.getChildren().add(this.getLinkPanel());
            }
            contentPanel.getChildren().add(this.getIntegrationPanel());
        }
        contentPanel.getChildren().add(this.getBtnPanel());
        this.setContentPane(contentPanel);
    }

    private Pane getSecurityPanel() {
        int end;
        VBox securityPanel = new VBox();
        boolean showall = this.certs == null;
        int start = showall || this.alerts == null ? 0 : 1;
        int n = end = this.alerts == null ? 0 : this.alerts.length;
        if (end > start) {
            securityPanel.getChildren().add(this.blockPanel("warning16.image", this.alerts, start, end));
        }
        if ((end = this.securityInfoCount) > (start = showall || this.alerts != null ? 0 : 1)) {
            start = start == 1 && this.sandboxApp ? 0 : start;
            securityPanel.getChildren().add(this.blockPanel("info16.image", this.infos, start, end));
        }
        return securityPanel;
    }

    private Pane getLinkPanel() {
        HBox linkPanel = new HBox();
        String key = this.sandboxApp ? "sandbox.security.more.info.details" : "security.more.info.details";
        this.details = new Hyperlink(ResourceManager.getMessage(key));
        this.details.setMnemonicParsing(true);
        this.details.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                MoreInfoDialog.this.showCertDetails();
            }
        });
        linkPanel.getChildren().add(this.details);
        return linkPanel;
    }

    private Pane getIntegrationPanel() {
        int start = this.securityInfoCount;
        int end = this.infos == null ? 0 : this.infos.length;
        return this.blockPanel("info16.image", this.infos, start, end);
    }

    private Pane getBtnPanel() {
        HBox btnPanel = new HBox();
        btnPanel.setId("more-info-dialog-button-panel");
        Button dismissBtn = new Button(ResourceManager.getMessage("common.close_btn"));
        dismissBtn.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                MoreInfoDialog.this.dismissAction();
            }
        });
        dismissBtn.setDefaultButton(true);
        btnPanel.getChildren().add(dismissBtn);
        return btnPanel;
    }

    private Pane blockPanel(String iconLblStr, String[] strs, int start, int end) {
        VBox panel = new VBox(5.0);
        if (strs != null) {
            for (int i = start; i < end; ++i) {
                HBox p = new HBox(12.0);
                p.setAlignment(Pos.TOP_LEFT);
                ImageView iconLbl = ResourceManager.getIcon(iconLblStr);
                UITextArea text = new UITextArea(326.0);
                text.setWrapText(true);
                text.setId("more-info-text-block");
                text.setText(strs[i]);
                p.getChildren().add(iconLbl);
                p.getChildren().add(text);
                panel.getChildren().add(p);
                if (i >= end - 1) continue;
                panel.getChildren().add(new Separator());
            }
        }
        return panel;
    }

    private void showCertDetails() {
        CertificateDialog.showCertificates(this, this.certs, this.start, this.end);
    }

    private void dismissAction() {
        this.hide();
    }
}

