/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.TCRefParser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ModeParser {
    public static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Mode Properties 1.0//EN";
    public static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Mode Properties 1.1//EN";
    public static final String INSTANCE_DTD_ID_1_2 = "-//NetBeans//DTD Mode Properties 1.2//EN";
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Mode Properties 2.0//EN";
    public static final String INSTANCE_DTD_ID_2_1 = "-//NetBeans//DTD Mode Properties 2.1//EN";
    public static final String INSTANCE_DTD_ID_2_2 = "-//NetBeans//DTD Mode Properties 2.2//EN";
    public static final String INSTANCE_DTD_ID_2_3 = "-//NetBeans//DTD Mode Properties 2.3//EN";
    public static final String INSTANCE_DTD_ID_2_4 = "-//NetBeans//DTD Mode Properties 2.4//EN";
    private static final String EA_ORDER = "WinSys-TCRef-Order";
    private static final boolean DEBUG = Debug.isLoggable(ModeParser.class);
    private FileObject moduleParentFolder;
    private FileObject localParentFolder;
    private InternalConfig internalConfig;
    private Map<String, TCRefParser> tcRefParserMap = new HashMap<String, TCRefParser>(19);
    private Map<String, Integer> tcRefOrder;
    private String modeName;
    private boolean inModuleFolder;
    private boolean inLocalFolder;
    private Set maskSet;

    public ModeParser(String string, Set set) {
        this.modeName = string;
        this.maskSet = set;
    }

    ModeConfig load() throws IOException {
        ModeConfig modeConfig = new ModeConfig();
        this.readProperties(modeConfig);
        if (modeConfig.kind == 2 && modeConfig.side != null && !modeConfig.permanent) {
            modeConfig.permanent = true;
        }
        this.readTCRefs(modeConfig);
        return modeConfig;
    }

    void save(ModeConfig modeConfig) throws IOException {
        this.writeProperties(modeConfig);
        this.writeTCRefs(modeConfig);
    }

    private void readProperties(ModeConfig modeConfig) throws IOException {
        if (DEBUG) {
            Debug.log(ModeParser.class, "readProperties ENTER mo:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        internalConfig.clear();
        propertyHandler.readData(modeConfig, internalConfig);
        if (DEBUG) {
            Debug.log(ModeParser.class, "readProperties LEAVE mo:" + this.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readTCRefs(ModeConfig modeConfig) throws IOException {
        void var6_19;
        void var6_17;
        Object object;
        Object object222;
        int n2;
        Object object3;
        if (DEBUG) {
            Debug.log(ModeParser.class, "readTCRefs ENTER mo:" + this.getName());
        }
        Object object4 = this.tcRefParserMap.keySet().iterator();
        while (object4.hasNext()) {
            object3 = this.tcRefParserMap.get(object4.next());
            ((TCRefParser)object3).setInModuleFolder(false);
            ((TCRefParser)object3).setInLocalFolder(false);
        }
        if (this.isInModuleFolder() && (object4 = this.moduleParentFolder.getFileObject(this.modeName)) != null) {
            object3 = object4.getChildren();
            for (n2 = 0; n2 < ((FileObject[])object3).length; ++n2) {
                if (object3[n2].isFolder() || !"wstcref".equals(object3[n2].getExt())) continue;
                if (this.tcRefParserMap.containsKey(object3[n2].getName())) {
                    object222 = this.tcRefParserMap.get(object3[n2].getName());
                } else {
                    object222 = new TCRefParser(object3[n2].getName());
                    this.tcRefParserMap.put(object3[n2].getName(), (TCRefParser)object222);
                }
                ((TCRefParser)object222).setInModuleFolder(true);
                ((TCRefParser)object222).setModuleParentFolder((FileObject)object4);
            }
        }
        if (this.isInLocalFolder() && (object4 = this.localParentFolder.getFileObject(this.modeName)) != null) {
            object3 = object4.getChildren();
            for (n2 = 0; n2 < ((FileObject[])object3).length; ++n2) {
                if (object3[n2].isFolder() || !"wstcref".equals(object3[n2].getExt())) continue;
                object222 = this.tcRefParserMap.get(object3[n2].getName());
                if (object222 == null) {
                    object222 = new TCRefParser(object3[n2].getName());
                    this.tcRefParserMap.put(object3[n2].getName(), (TCRefParser)object222);
                }
                ((TCRefParser)object222).setInLocalFolder(true);
                ((TCRefParser)object222).setLocalParentFolder((FileObject)object4);
            }
        }
        this.readOrder();
        object4 = new ArrayList(10);
        object3 = new HashMap<String, TCRefParser>(this.tcRefParserMap);
        if (this.tcRefOrder != null) {
            TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
            for (Map.Entry object5 : this.tcRefOrder.entrySet()) {
                TCRefParser tCRefParser;
                object = (String)object5.getKey();
                int n = (Integer)object5.getValue();
                tCRefParserArray[n] = tCRefParser = (TCRefParser)object3.remove(object);
            }
            for (int i = 0; i < tCRefParserArray.length; ++i) {
                if (tCRefParserArray[i] == null) continue;
                object4.add(tCRefParserArray[i]);
            }
            for (String persistenceManager : object3.keySet()) {
                object = (TCRefParser)object3.get(persistenceManager);
                object4.add(object);
            }
        } else {
            for (Object object222 : object3.keySet()) {
                TCRefParser tCRefParser = (TCRefParser)object3.get(object222);
                object4.add(tCRefParser);
            }
            object4 = this.carefullySort((List<TCRefParser>)object4);
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap<String, Integer>(19);
            }
            this.tcRefOrder.clear();
            for (int i = 0; i < object4.size(); ++i) {
                object222 = (TCRefParser)object4.get(i);
                this.tcRefOrder.put(((TCRefParser)object222).getName(), i);
            }
            this.writeOrder();
        }
        ArrayList<TCRefConfig> arrayList = new ArrayList<TCRefConfig>(object4.size());
        object222 = new ArrayList<Object>(object4.size());
        boolean bl = false;
        while (var6_17 < object4.size()) {
            block30: {
                object = (TCRefParser)object4.get((int)var6_17);
                if (this.maskSet.contains(((TCRefParser)object).getName()) && ((TCRefParser)object).isInModuleFolder() && !((TCRefParser)object).isInLocalFolder()) {
                    object222.add(object);
                } else {
                    TCRefConfig tCRefConfig;
                    try {
                        tCRefConfig = ((TCRefParser)object).load();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ModeParser.class.getName()).log(Level.INFO, null, iOException);
                        break block30;
                    }
                    boolean bl2 = this.acceptTCRef((TCRefParser)object, tCRefConfig);
                    if (bl2) {
                        arrayList.add(tCRefConfig);
                    } else {
                        object222.add(object);
                        this.deleteLocalTCRef(((TCRefParser)object).getName());
                    }
                }
            }
            ++var6_17;
        }
        boolean bl3 = false;
        while (var6_19 < object222.size()) {
            object = (TCRefParser)object222.get((int)var6_19);
            object4.remove(object);
            this.tcRefParserMap.remove(((TCRefParser)object).getName());
            ++var6_19;
        }
        if (object222.size() > 0) {
            void var6_21;
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap<String, Integer>(19);
            }
            this.tcRefOrder.clear();
            boolean bl4 = false;
            while (var6_21 < object4.size()) {
                object = (TCRefParser)object4.get((int)var6_21);
                this.tcRefOrder.put(((TCRefParser)object).getName(), (int)var6_21);
                ++var6_21;
            }
            this.writeOrder();
        }
        modeConfig.tcRefConfigs = arrayList.toArray(new TCRefConfig[arrayList.size()]);
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            persistenceManager.addUsedTCId(modeConfig.tcRefConfigs[i].tc_id);
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "readTCRefs LEAVE mo:" + this.getName());
        }
    }

    private boolean acceptTCRef(TCRefParser tCRefParser, TCRefConfig tCRefConfig) {
        InternalConfig internalConfig = tCRefParser.getInternalConfig();
        if (internalConfig.moduleCodeNameBase != null) {
            ModuleInfo moduleInfo = PersistenceManager.findModule(internalConfig.moduleCodeNameBase, internalConfig.moduleCodeNameRelease, internalConfig.moduleSpecificationVersion);
            if (moduleInfo == null) {
                PersistenceManager.LOG.fine("Cannot find module '" + internalConfig.moduleCodeNameBase + " " + internalConfig.moduleCodeNameRelease + " " + internalConfig.moduleSpecificationVersion + "' for tcref with id '" + tCRefConfig.tc_id + "'");
            }
            return moduleInfo != null && moduleInfo.isEnabled();
        }
        return true;
    }

    private void writeProperties(ModeConfig modeConfig) throws IOException {
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeProperties ENTER mo:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        propertyHandler.writeData(modeConfig, internalConfig);
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeProperties LEAVE mo:" + this.getName());
        }
    }

    private void writeTCRefs(ModeConfig modeConfig) throws IOException {
        int n;
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeTCRefs ENTER mo:" + this.getName());
        }
        if (modeConfig.tcRefConfigs.length > 0) {
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap<String, Integer>(19);
            }
            this.tcRefOrder.clear();
            for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
                this.tcRefOrder.put(modeConfig.tcRefConfigs[i].tc_id, i);
            }
        } else {
            this.tcRefOrder = null;
        }
        this.writeOrder();
        HashMap<String, TCRefConfig> hashMap = new HashMap<String, TCRefConfig>(19);
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            hashMap.put(modeConfig.tcRefConfigs[i].tc_id, modeConfig.tcRefConfigs[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (String object2 : this.tcRefParserMap.keySet()) {
            TCRefParser tCRefParser = this.tcRefParserMap.get(object2);
            if (hashMap.containsKey(tCRefParser.getName())) continue;
            arrayList.add(tCRefParser.getName());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.tcRefParserMap.remove(arrayList.get(n));
            this.deleteLocalTCRef((String)arrayList.get(n));
        }
        for (n = 0; n < modeConfig.tcRefConfigs.length; ++n) {
            if (this.tcRefParserMap.containsKey(modeConfig.tcRefConfigs[n].tc_id)) continue;
            TCRefParser tCRefParser = new TCRefParser(modeConfig.tcRefConfigs[n].tc_id);
            this.tcRefParserMap.put(modeConfig.tcRefConfigs[n].tc_id, tCRefParser);
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.getName());
        if (fileObject == null && this.tcRefParserMap.size() > 0) {
            fileObject = FileUtil.createFolder((FileObject)this.localParentFolder, (String)this.getName());
        }
        Iterator<String> iterator = this.tcRefParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            TCRefParser tCRefParser = this.tcRefParserMap.get(iterator.next());
            tCRefParser.setLocalParentFolder(fileObject);
            tCRefParser.setInLocalFolder(true);
            tCRefParser.save((TCRefConfig)hashMap.get(tCRefParser.getName()));
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeTCRefs LEAVE mo:" + this.getName());
        }
    }

    private void deleteLocalTCRef(String string) {
        if (DEBUG) {
            Debug.log(ModeParser.class, "deleteLocalTCRef tcRefName:" + string);
        }
        if (this.localParentFolder == null) {
            return;
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.modeName);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(string, "wstcref");
        if (fileObject2 != null) {
            PersistenceManager.deleteOneFO(fileObject2);
        }
    }

    private void readOrder() {
        FileObject fileObject;
        if (this.localParentFolder == null) {
            try {
                this.localParentFolder = PersistenceManager.getDefault().getModesLocalFolder();
            }
            catch (IOException iOException) {
                Logger.getLogger(ModeParser.class.getName()).log(Level.INFO, "Cannot get access to lcoal modes folder", iOException);
                return;
            }
        }
        if ((fileObject = this.localParentFolder.getFileObject(this.modeName)) == null) {
            this.tcRefOrder = null;
            return;
        }
        Object object = fileObject.getAttribute(EA_ORDER);
        if (object == null) {
            this.tcRefOrder = null;
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(19);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                hashMap.put(string2, n);
                ++n;
            }
            this.tcRefOrder = hashMap;
            return;
        }
        this.tcRefOrder = null;
    }

    private void writeOrder() throws IOException {
        FileObject fileObject;
        if (this.localParentFolder == null) {
            this.localParentFolder = PersistenceManager.getDefault().getModesLocalFolder();
        }
        if ((fileObject = this.localParentFolder.getFileObject(this.modeName)) == null) {
            fileObject = FileUtil.createFolder((FileObject)this.localParentFolder, (String)this.modeName);
        }
        if (this.tcRefOrder == null) {
            fileObject.setAttribute(EA_ORDER, null);
        } else {
            String[] stringArray = new String[this.tcRefOrder.size()];
            for (Map.Entry<String, Integer> entry : this.tcRefOrder.entrySet()) {
                String string = entry.getKey();
                int n = entry.getValue();
                stringArray[n] = string;
            }
            StringBuilder stringBuilder = new StringBuilder(255);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(stringArray[i]);
            }
            fileObject.setAttribute(EA_ORDER, (Object)stringBuilder.toString());
        }
    }

    private List<TCRefParser> carefullySort(List<TCRefParser> list) {
        FileObject fileObject;
        if (this.tcRefOrder != null && !this.tcRefOrder.isEmpty()) {
            return list;
        }
        if (this.moduleParentFolder == null) {
            return list;
        }
        FileObject fileObject2 = this.moduleParentFolder.getFileObject(this.modeName);
        if (fileObject2 == null) {
            return list;
        }
        LinkedHashMap<FileObject, TCRefParser> linkedHashMap = new LinkedHashMap<FileObject, TCRefParser>();
        for (TCRefParser object2 : list) {
            fileObject = fileObject2.getFileObject(object2.getName() + '.' + "wstcref");
            if (fileObject == null) {
                return list;
            }
            linkedHashMap.put(fileObject, object2);
        }
        List list2 = FileUtil.getOrder(linkedHashMap.keySet(), (boolean)true);
        ArrayList<TCRefParser> arrayList = new ArrayList<TCRefParser>(linkedHashMap.size());
        fileObject = list2.iterator();
        while (fileObject.hasNext()) {
            FileObject fileObject3 = (FileObject)fileObject.next();
            arrayList.add((TCRefParser)linkedHashMap.get(fileObject3));
        }
        return arrayList;
    }

    void removeTCRef(String string) {
        int n;
        if (DEBUG) {
            Debug.log(ModeParser.class, "removeTCRef ENTER tcRef:" + string);
        }
        ArrayList<TCRefParser> arrayList = new ArrayList<TCRefParser>(10);
        Map map = (Map)((HashMap)this.tcRefParserMap).clone();
        this.tcRefParserMap.remove(string);
        TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
        for (Map.Entry<String, Integer> object2 : this.tcRefOrder.entrySet()) {
            TCRefParser tCRefParser;
            String string2 = object2.getKey();
            int n2 = object2.getValue();
            tCRefParserArray[n2] = tCRefParser = (TCRefParser)map.remove(string2);
        }
        for (int i = 0; i < tCRefParserArray.length; ++i) {
            arrayList.add(tCRefParserArray[i]);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            TCRefParser tCRefParser = (TCRefParser)map.get(iterator.next());
            arrayList.add(tCRefParser);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            TCRefParser tCRefParser = (TCRefParser)arrayList.get(n);
            if (!string.equals(tCRefParser.getName())) continue;
            arrayList.remove(n);
            break;
        }
        if (null == this.tcRefOrder) {
            this.tcRefOrder = new HashMap<String, Integer>(19);
        }
        this.tcRefOrder.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            TCRefParser tCRefParser = (TCRefParser)arrayList.get(n);
            this.tcRefOrder.put(tCRefParser.getName(), n);
        }
        try {
            this.writeOrder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.removeTCRef] Warning: Cannot write order of mode: " + this.getName(), iOException);
        }
        this.deleteLocalTCRef(string);
        if (DEBUG) {
            Debug.log(ModeParser.class, "removeTCRef LEAVE tcRef:" + string);
        }
    }

    TCRefConfig addTCRef(String string, List<String> list) {
        TCRefParser tCRefParser;
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRef ENTER mo:" + this.getName() + " tcRef:" + string);
        }
        if ((tCRefParser = this.tcRefParserMap.get(string)) != null) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". TCRefParser " + string + " exists but it should not.");
            this.tcRefParserMap.remove(string);
        }
        tCRefParser = new TCRefParser(string);
        FileObject fileObject = this.moduleParentFolder.getFileObject(this.modeName);
        tCRefParser.setModuleParentFolder(fileObject);
        tCRefParser.setInModuleFolder(true);
        this.tcRefParserMap.put(string, tCRefParser);
        TCRefConfig tCRefConfig = null;
        try {
            tCRefConfig = tCRefParser.load();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". Cannot load tcRef " + string, iOException);
        }
        List<TCRefParser> list2 = new ArrayList<TCRefParser>(10);
        Map map = (Map)((HashMap)this.tcRefParserMap).clone();
        TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
        for (Map.Entry<String, Integer> object : this.tcRefOrder.entrySet()) {
            String string2 = object.getKey();
            int n = object.getValue();
            tCRefParser = (TCRefParser)map.remove(string2);
            assert (tCRefParser != null) : "No parser for " + string2 + " in " + tCRefParser;
            tCRefParserArray[n] = tCRefParser;
        }
        for (int i = 0; i < tCRefParserArray.length; ++i) {
            list2.add(tCRefParserArray[i]);
        }
        for (String string3 : map.keySet()) {
            tCRefParser = (TCRefParser)map.get(string3);
            assert (tCRefParser != null) : "No parser for " + string3;
            list2.add(tCRefParser);
        }
        list2 = this.carefullySort(list2);
        if (null == this.tcRefOrder) {
            this.tcRefOrder = new HashMap<String, Integer>(19);
        }
        this.tcRefOrder.clear();
        for (int i = 0; i < list2.size(); ++i) {
            tCRefParser = list2.get(i);
            this.tcRefOrder.put(tCRefParser.getName(), i);
        }
        try {
            this.writeOrder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.addTCRef] Warning: Cannot write order of mode: " + this.getName(), iOException);
        }
        list.clear();
        for (int i = 0; i < list2.size(); ++i) {
            tCRefParser = list2.get(i);
            list.add(tCRefParser.getName());
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRef LEAVE mo:" + this.getName() + " tcRef:" + string);
        }
        return tCRefConfig;
    }

    void addTCRefImport(String string, InternalConfig internalConfig) {
        TCRefParser tCRefParser;
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRefImport ENTER mo:" + this.getName() + " tcRef:" + string);
        }
        if ((tCRefParser = this.tcRefParserMap.get(string)) != null) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". TCRefParser " + string + " exists but it should not.");
            this.tcRefParserMap.remove(string);
        }
        tCRefParser = new TCRefParser(string);
        FileObject fileObject = this.localParentFolder.getFileObject(this.modeName);
        tCRefParser.setLocalParentFolder(fileObject);
        tCRefParser.setInternalConfig(internalConfig);
        this.tcRefParserMap.put(string, tCRefParser);
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRefImport LEAVE mo:" + this.getName() + " tcRef:" + string);
        }
    }

    TCRefParser findTCRefParser(String string) {
        return this.tcRefParserMap.get(string);
    }

    InternalConfig getInternalConfig() {
        if (this.internalConfig == null) {
            this.internalConfig = new InternalConfig();
        }
        return this.internalConfig;
    }

    void setModuleParentFolder(FileObject fileObject) {
        this.moduleParentFolder = fileObject;
    }

    void setLocalParentFolder(FileObject fileObject) {
        this.localParentFolder = fileObject;
    }

    String getName() {
        return this.modeName;
    }

    boolean isInModuleFolder() {
        return this.inModuleFolder;
    }

    void setInModuleFolder(boolean bl) {
        this.inModuleFolder = bl;
    }

    boolean isInLocalFolder() {
        return this.inLocalFolder;
    }

    void setInLocalFolder(boolean bl) {
        this.inLocalFolder = bl;
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private ModeConfig modeConfig = null;
        private InternalConfig internalConfig = null;
        private List<SplitConstraint> itemList = new ArrayList<SplitConstraint>(10);
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() {
            FileObject fileObject = ModeParser.this.isInLocalFolder() ? ModeParser.this.localParentFolder.getFileObject(ModeParser.this.getName(), "wsmode") : (ModeParser.this.isInModuleFolder() ? ModeParser.this.moduleParentFolder.getFileObject(ModeParser.this.getName(), "wsmode") : null);
            return fileObject;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = ModeParser.this.localParentFolder.getFileObject(ModeParser.this.getName(), "wsmode");
            if (fileObject != null) {
                return fileObject;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ModeParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wsmode");
            fileObject = FileUtil.createData((FileObject)ModeParser.this.localParentFolder, (String)stringBuffer.toString());
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readData(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            this.modeConfig = modeConfig;
            this.internalConfig = internalConfig;
            this.itemList.clear();
            FileObject fileObject = this.getConfigFOInput();
            if (fileObject == null) {
                throw new FileNotFoundException("[WinSys] Missing Mode configuration file:" + ModeParser.this.getName());
            }
            InputStream inputStream = null;
            try {
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
            }
            catch (SAXException sAXException) {
                String string = NbBundle.getMessage(ModeParser.class, (String)"EXC_ModeParse", (Object)fileObject);
                throw (IOException)new IOException(string).initCause(sAXException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(ModeParser.class.getName()).log(Level.INFO, null, iOException);
                }
            }
            this.modeConfig.constraints = this.itemList.toArray(new SplitConstraint[this.itemList.size()]);
            modeConfig = this.modeConfig;
            internalConfig = this.internalConfig;
            this.modeConfig = null;
            this.internalConfig = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("mode".equals(string3)) {
                this.handleMode(attributes);
            } else if (this.internalConfig.specVersion != null && this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) >= 0) {
                if ("module".equals(string3)) {
                    this.handleModule(attributes);
                } else if ("name".equals(string3)) {
                    this.handleName(attributes);
                } else if ("kind".equals(string3)) {
                    this.handleKind(attributes);
                } else if ("slidingSide".equals(string3)) {
                    this.handleSlidingSide(attributes);
                } else if ("slide-in-size".equals(string3)) {
                    this.handleSlideInSize(attributes);
                } else if ("state".equals(string3)) {
                    this.handleState(attributes);
                } else if ("constraints".equals(string3)) {
                    this.handleConstraints(attributes);
                } else if ("path".equals(string3)) {
                    this.handlePath(attributes);
                } else if ("bounds".equals(string3)) {
                    this.handleBounds(attributes);
                } else if ("relative-bounds".equals(string3)) {
                    this.handleRelativeBounds(attributes);
                } else if ("frame".equals(string3)) {
                    this.handleFrame(attributes);
                } else if ("active-tc".equals(string3)) {
                    this.handleActiveTC(attributes);
                } else if ("empty-behavior".equals(string3)) {
                    this.handleEmptyBehavior(attributes);
                }
            } else if (DEBUG) {
                Debug.log(ModeParser.class, "-- ModeParser.startElement PARSING OLD");
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleMode(Attributes attributes) {
            String string = attributes.getValue("version");
            if (string != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string);
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleMode] Warning: Missing attribute \"version\" of element \"mode\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.internalConfig.moduleCodeNameBase = null;
            this.internalConfig.moduleCodeNameRelease = null;
            this.internalConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.internalConfig.moduleCodeNameBase = string.substring(0, n);
                    this.internalConfig.moduleCodeNameRelease = string.substring(n + 1);
                    this.checkReleaseCode(this.internalConfig);
                } else {
                    this.internalConfig.moduleCodeNameBase = string;
                }
                this.internalConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private void checkReleaseCode(InternalConfig internalConfig) {
            if ("null".equals(internalConfig.moduleCodeNameRelease)) {
                Logger.getLogger(ModeParser.class.getName()).log(Level.INFO, null, new IllegalStateException("Module release code was saved as null string for module " + internalConfig.moduleCodeNameBase + "! Repairing."));
                internalConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleName(Attributes attributes) throws SAXException {
            String string = attributes.getValue("unique");
            if (string != null) {
                this.modeConfig.name = string;
                if (!string.equals(ModeParser.this.getName())) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleName] Error: Value of attribute \"unique\" of element \"name\" and configuration file name must be the same.");
                    throw new SAXException("Invalid attribute value");
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleName] Error: Missing required attribute \"unique\" of element \"name\".");
                throw new SAXException("Missing required attribute");
            }
            String string2 = attributes.getValue("includes");
            if (string2 != null) {
                String[] stringArray = string2.split(",");
                HashSet<String> hashSet = new HashSet<String>(stringArray.length);
                for (String string3 : stringArray) {
                    if ((string3 = string3.trim()).isEmpty()) continue;
                    hashSet.add(string3);
                }
                if (hashSet.isEmpty()) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleName] Error: Attribute \"includes\" of element \"name\" is present but does not contain any valid mode names.");
                    throw new SAXException("Invalid attribute value");
                }
                this.modeConfig.otherNames = hashSet;
            }
        }

        private void handleKind(Attributes attributes) throws SAXException {
            String string = attributes.getValue("type");
            if (string != null) {
                if ("editor".equals(string)) {
                    this.modeConfig.kind = 1;
                } else if ("view".equals(string)) {
                    this.modeConfig.kind = 0;
                } else if ("sliding".equals(string)) {
                    this.modeConfig.kind = 2;
                    if (null != this.modeConfig.otherNames && !this.modeConfig.otherNames.isEmpty()) {
                        PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleName] Error: Sliding modes are not allowed to have additional names.");
                        throw new SAXException("Invalid attribute value");
                    }
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleKind] Warning: Invalid value of attribute \"type\".");
                    this.modeConfig.kind = 0;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleKind] Error: Missing required attribute \"type\" of element \"kind\".");
                this.modeConfig.kind = 0;
            }
        }

        private void handleSlidingSide(Attributes attributes) {
            String string = attributes.getValue("side");
            if (string != null) {
                if ("left".equals(string) || "right".equals(string) || "top".equals(string) || "bottom".equals(string)) {
                    this.modeConfig.side = string;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleSlidingSide] Warning: Wrong value \"" + string + "\" of attribute \"side\" for sliding mode");
                    this.modeConfig.side = "left";
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleSlidingSide] Warning: Missing value of attribute \"side\" for sliding mode.");
                this.modeConfig.side = "left";
            }
        }

        private void handleSlideInSize(Attributes attributes) {
            String string = attributes.getValue("tc-id");
            String string2 = attributes.getValue("size");
            if (string != null && string2 != null) {
                try {
                    Integer n = Integer.valueOf(string2);
                    if (null == this.modeConfig.slideInSizes) {
                        this.modeConfig.slideInSizes = new HashMap<String, Integer>(5);
                    }
                    this.modeConfig.slideInSizes.put(string, n);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleSlideInSize] Warning: Invalid attributes for preferred slide-in size.");
        }

        private void handleState(Attributes attributes) throws SAXException {
            String string = attributes.getValue("type");
            if (string != null) {
                if ("joined".equals(string)) {
                    this.modeConfig.state = 0;
                } else if ("separated".equals(string)) {
                    this.modeConfig.state = 1;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleState] Warning: Invalid value of attribute \"type\" of element \"state\".");
                    this.modeConfig.state = 0;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleState] Error: Missing required attribute \"type\" of element \"state\".");
                this.modeConfig.state = 0;
            }
            String string2 = attributes.getValue("minimized");
            if (string2 != null) {
                if ("true".equals(string2)) {
                    if (this.modeConfig.kind == 2) {
                        PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleState] Error: Sliding mode cannot be minimized.");
                        throw new SAXException("Invalid attribute value");
                    }
                    this.modeConfig.minimized = true;
                } else if ("false".equals(string2)) {
                    this.modeConfig.minimized = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleState] Warning: Invalid value of attribute \"minimized\" of element \"state\".");
                    this.modeConfig.minimized = false;
                }
            }
        }

        private void handleConstraints(Attributes attributes) {
        }

        private void handlePath(Attributes attributes) {
            double d;
            int n;
            int n2;
            String string = attributes.getValue("orientation");
            if ("horizontal".equals(string)) {
                n2 = 1;
            } else if ("vertical".equals(string)) {
                n2 = 0;
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handlePath] Warning: Invalid or missing value of attribute \"orientation\".");
                n2 = 0;
            }
            try {
                string = attributes.getValue("number");
                if (string != null) {
                    n = Integer.parseInt(string);
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handlePath] Warning: Missing value of attribute \"number\".");
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handlePath] Warning: Cannot read element \"path\", attribute \"number\"", numberFormatException);
                n = 0;
            }
            try {
                string = attributes.getValue("weight");
                d = string != null ? Double.parseDouble(string) : 0.5;
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handlePath] Warning: Cannot read element \"path\", attribute \"weight\".", numberFormatException);
                d = 0.5;
            }
            SplitConstraint splitConstraint = new SplitConstraint(n2, n, d);
            this.itemList.add(splitConstraint);
        }

        private void handleBounds(Attributes attributes) {
            try {
                this.modeConfig.bounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"x\" of element \"bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"y\" of element \"bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"width\" of element \"bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"height\" of element \"bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.modeConfig.bounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleBounds] Warning: Cannot read element \"bounds\".", numberFormatException);
            }
        }

        private void handleRelativeBounds(Attributes attributes) {
            try {
                this.modeConfig.relativeBounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"x\" of element \"relative-bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"y\" of element \"relative-bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"width\" of element \"relative-bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"height\" of element \"relative-bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.modeConfig.relativeBounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleRelativeBounds] Warning: Cannot read element \"relative-bounds\".", numberFormatException);
            }
        }

        private void handleFrame(Attributes attributes) {
            String string = attributes.getValue("state");
            if (string != null) {
                try {
                    this.modeConfig.frameState = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleFrame] Warning: Cannot read attribute \"state\" of element \"frame\".", numberFormatException);
                    this.modeConfig.frameState = 0;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleFrame] Warning: Missing value of attribute \"state\" of element \"frame\".");
                this.modeConfig.frameState = 0;
            }
        }

        private void handleActiveTC(Attributes attributes) {
            String string = attributes.getValue("id");
            this.modeConfig.selectedTopComponentID = string != null ? string : "";
            String string2 = attributes.getValue("prev-id");
            this.modeConfig.previousSelectedTopComponentID = string2 != null ? string2 : "";
        }

        private void handleEmptyBehavior(Attributes attributes) {
            String string = attributes.getValue("permanent");
            if ("true".equals(string)) {
                this.modeConfig.permanent = true;
            } else if ("false".equals(string)) {
                this.modeConfig.permanent = false;
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.ModeParser.handleEmptyBehavior] Warning: Invalid value of attribute \"permanent\".");
                this.modeConfig.permanent = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(modeConfig, internalConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ModeParser.class.getName()).log(Level.INFO, null, iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private StringBuffer fillBuffer(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n").append("<mode version=\"2.4\">\n");
            this.appendModule(internalConfig, stringBuffer);
            this.appendName(modeConfig, stringBuffer);
            this.appendKind(modeConfig, stringBuffer);
            if (modeConfig.kind == 2) {
                this.appendSlidingSide(modeConfig, stringBuffer);
                if (null != modeConfig.slideInSizes) {
                    this.appendSlideInSize(modeConfig, stringBuffer);
                }
            }
            this.appendState(modeConfig, stringBuffer);
            this.appendConstraints(modeConfig, stringBuffer);
            if (modeConfig.bounds != null) {
                this.appendBounds(modeConfig, stringBuffer);
            } else if (modeConfig.relativeBounds != null) {
                this.appendRelativeBounds(modeConfig, stringBuffer);
            }
            this.appendFrame(modeConfig, stringBuffer);
            this.appendActiveTC(modeConfig, stringBuffer);
            this.appendEmptyBehavior(modeConfig, stringBuffer);
            stringBuffer.append("</mode>\n");
            return stringBuffer;
        }

        private void appendModule(InternalConfig internalConfig, StringBuffer stringBuffer) {
            if (internalConfig == null) {
                return;
            }
            if (internalConfig.moduleCodeNameBase != null) {
                stringBuffer.append("    <module name=\"");
                stringBuffer.append(internalConfig.moduleCodeNameBase);
                if (internalConfig.moduleCodeNameRelease != null) {
                    stringBuffer.append("/").append(internalConfig.moduleCodeNameRelease);
                }
                if (internalConfig.moduleSpecificationVersion != null) {
                    stringBuffer.append("\" spec=\"");
                    stringBuffer.append(internalConfig.moduleSpecificationVersion);
                }
                stringBuffer.append("\" />\n");
            }
        }

        private void appendName(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <name unique=\"");
            stringBuffer.append(modeConfig.name);
            stringBuffer.append("\" ");
            if (null != modeConfig.otherNames && !modeConfig.otherNames.isEmpty()) {
                stringBuffer.append(" includes=\"");
                boolean bl = false;
                for (String string : modeConfig.otherNames) {
                    if (bl) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(string);
                    bl = true;
                }
                stringBuffer.append("\" ");
            }
            stringBuffer.append(" />\n");
        }

        private void appendKind(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <kind type=\"");
            if (modeConfig.kind == 1) {
                stringBuffer.append("editor");
            } else if (modeConfig.kind == 0) {
                stringBuffer.append("view");
            } else if (modeConfig.kind == 2) {
                stringBuffer.append("sliding");
            }
            stringBuffer.append("\" />\n");
        }

        private void appendSlidingSide(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <slidingSide side=\"");
            stringBuffer.append(modeConfig.side);
            stringBuffer.append("\" ");
            stringBuffer.append("/>\n");
        }

        private void appendSlideInSize(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (null != modeConfig.slideInSizes) {
                for (String string : modeConfig.slideInSizes.keySet()) {
                    Integer n = modeConfig.slideInSizes.get(string);
                    stringBuffer.append("  <slide-in-size tc-id=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\" size=\"");
                    stringBuffer.append(n);
                    stringBuffer.append("\" />\n");
                }
            }
        }

        private void appendState(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <state type=\"");
            if (modeConfig.state == 0) {
                stringBuffer.append("joined");
            } else if (modeConfig.state == 1) {
                stringBuffer.append("separated");
            }
            stringBuffer.append("\" ");
            if (modeConfig.minimized) {
                stringBuffer.append(" minimized=\"true\" ");
            }
            stringBuffer.append(" />\n");
        }

        private void appendConstraints(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.constraints.length == 0) {
                return;
            }
            stringBuffer.append("  <constraints>\n");
            for (int i = 0; i < modeConfig.constraints.length; ++i) {
                SplitConstraint splitConstraint = modeConfig.constraints[i];
                stringBuffer.append("    <path orientation=\"");
                if (splitConstraint.orientation == 1) {
                    stringBuffer.append("horizontal");
                } else {
                    stringBuffer.append("vertical");
                }
                stringBuffer.append("\" number=\"").append(splitConstraint.index).append("\" weight=\"").append(splitConstraint.splitWeight).append("\"/>\n");
            }
            stringBuffer.append("  </constraints>\n");
        }

        private void appendBounds(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.bounds == null) {
                return;
            }
            stringBuffer.append("  <bounds x=\"").append(modeConfig.bounds.x).append("\" y=\"").append(modeConfig.bounds.y).append("\" width=\"").append(modeConfig.bounds.width).append("\" height=\"").append(modeConfig.bounds.height).append("\" />\n");
        }

        private void appendRelativeBounds(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.relativeBounds == null) {
                return;
            }
            stringBuffer.append("  <relative-bounds x=\"").append(modeConfig.relativeBounds.x).append("\" y=\"").append(modeConfig.relativeBounds.y).append("\" width=\"").append(modeConfig.relativeBounds.width).append("\" height=\"").append(modeConfig.relativeBounds.height).append("\" />\n");
        }

        private void appendFrame(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <frame state=\"").append(modeConfig.frameState).append("\"/>\n");
        }

        private void appendActiveTC(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.selectedTopComponentID != null && !"".equals(modeConfig.selectedTopComponentID) || modeConfig.previousSelectedTopComponentID != null && !"".equals(modeConfig.previousSelectedTopComponentID)) {
                String string;
                stringBuffer.append("    <active-tc ");
                if (modeConfig.selectedTopComponentID != null && !"".equals(modeConfig.selectedTopComponentID)) {
                    string = PersistenceManager.escapeTcId4XmlContent(modeConfig.selectedTopComponentID);
                    stringBuffer.append(" id=\"").append(string).append("\" ");
                }
                if (modeConfig.previousSelectedTopComponentID != null && !"".equals(modeConfig.previousSelectedTopComponentID)) {
                    string = PersistenceManager.escapeTcId4XmlContent(modeConfig.previousSelectedTopComponentID);
                    stringBuffer.append(" prev-id=\"").append(string).append("\" ");
                }
                stringBuffer.append("/>\n");
            }
        }

        private void appendEmptyBehavior(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <empty-behavior permanent=\"").append(modeConfig.permanent).append("\"/>\n");
        }
    }
}

