/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class BeanTreeView
extends TreeView {
    static final long serialVersionUID = 3841322840231536380L;

    public BeanTreeView() {
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }

    @Override
    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    @Override
    protected void showSelection(TreePath[] treePathArray) {
        this.tree.getSelectionModel().setSelectionPaths(treePathArray);
        if (treePathArray.length == 1) {
            this.showPathWithoutExpansion(treePathArray[0]);
        }
    }

    @Override
    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        if (nodeArray.length > 0) {
            Node node = nodeArray[0].getParentNode();
            for (int i = 1; i < nodeArray.length; ++i) {
                if (node == nodeArray[i].getParentNode()) continue;
                explorerManager.setSelectedNodes(nodeArray);
                return;
            }
            if (explorerManager.getRootContext().getParentNode() == node) {
                explorerManager.setExploredContextAndSelection(explorerManager.getRootContext(), nodeArray);
            } else {
                explorerManager.setExploredContextAndSelection(node, nodeArray);
            }
        } else {
            explorerManager.setSelectedNodes(nodeArray);
        }
    }

    @Override
    protected void showPath(TreePath treePath) {
        this.tree.expandPath(treePath);
        this.showPathWithoutExpansion(treePath);
    }

    private void showPathWithoutExpansion(TreePath treePath) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null && rectangle.y >= 0) {
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tree.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        if (this.tree == null) {
            return true;
        }
        return this.tree.isEnabled();
    }
}

