/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Bits;

public class DataLayout {
    public static final int noTag = 0;
    public static final int bitDataTag = 1;
    public static final int counterDataTag = 2;
    public static final int jumpDataTag = 3;
    public static final int receiverTypeDataTag = 4;
    public static final int virtualCallDataTag = 5;
    public static final int retDataTag = 6;
    public static final int branchDataTag = 7;
    public static final int multiBranchDataTag = 8;
    public static final int trapBits = 4;
    public static final int trapShift = 4;
    public static final int trapMask = Bits.rightNBits(4);
    public static final int trapMaskInPlace = trapMask << 4;
    public static final int flagLimit = 4;
    public static final int flagMask = Bits.rightNBits(4);
    public static final int firstFlag = 0;
    private Address data;
    private int offset;
    private boolean handlized;
    public static final int counterIncrement = 1;

    public DataLayout(MethodData d, int o) {
        this.data = d.getHandle();
        this.offset = o;
    }

    public DataLayout(Address d, int o) {
        this.data = d;
        this.offset = o;
        this.handlized = true;
    }

    public int dp() {
        return this.offset;
    }

    private int getU11(int at) {
        return this.data.getJByteAt(this.offset + at) & 0xFF;
    }

    private int getU22(int at) {
        return this.data.getJShortAt(this.offset + at) & 0xFFFF;
    }

    int cellAt(int index) {
        return (int)this.data.getCIntegerAt(this.offset + DataLayout.cellOffset(index), MethodData.cellSize, false);
    }

    Oop oopAt(int index) {
        if (this.handlized) {
            throw new InternalError("unsupported");
        }
        OopHandle handle = this.data.getOopHandleAt(this.offset + DataLayout.cellOffset(index));
        return VM.getVM().getObjectHeap().newOop(handle);
    }

    public Address addressAt(int index) {
        if (this.handlized) {
            return this.data.getAddressAt(this.offset + DataLayout.cellOffset(index));
        }
        return this.data.getOopHandleAt(this.offset + DataLayout.cellOffset(index));
    }

    static boolean needsArrayLen(int tag) {
        return tag == 8;
    }

    static int headerSizeInBytes() {
        return MethodData.cellSize;
    }

    static int headerSizeInCells() {
        return 1;
    }

    static int computeSizeInBytes(int cellCount) {
        return DataLayout.headerSizeInBytes() + cellCount * MethodData.cellSize;
    }

    public int tag() {
        return this.getU11(0);
    }

    int trapState() {
        return this.flags() >> 4 & trapMask;
    }

    int flags() {
        return this.getU11(1);
    }

    int bci() {
        return this.getU22(2);
    }

    boolean flagAt(int flagNumber) {
        return (this.flags() & 1 << flagNumber) != 0;
    }

    static int headerOffset() {
        return 0;
    }

    static int tagOffset() {
        return 0;
    }

    static int flagsOffset() {
        return 1;
    }

    static int bciOffset() {
        return 2;
    }

    public static int cellOffset(int index) {
        return MethodData.cellSize + index * MethodData.cellSize;
    }
}

