/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class RecognizeInstanceFiles
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceFiles.class.getName());

    public Lookup create(String string) {
        return new OverFiles(string);
    }

    public <T> T lookupObject(String string, Class<T> clazz) {
        FileObject fileObject = FileUtil.getConfigFile(string);
        if (fileObject != null && fileObject.isData()) {
            return FOItem.createInstanceFor(fileObject, clazz);
        }
        return null;
    }

    private static final class FOItem
    extends AbstractLookup.Pair<Object> {
        private static Reference<Object> EMPTY = new WeakReference<Object>(null);
        private FileObject fo;
        private Reference<Object> ref = EMPTY;

        public FOItem(FileObject fileObject) {
            this.fo = fileObject;
        }

        protected boolean instanceOf(Class<?> clazz) {
            Object object = this.ref.get();
            if (object != null) {
                return clazz.isInstance(object);
            }
            String string = (String)this.fo.getAttribute("instanceOf");
            if (string != null) {
                for (String string2 : string.split(",")) {
                    try {
                        if (!clazz.isAssignableFrom(Class.forName(string2, false, FOItem.loader()))) continue;
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOG.log(Level.FINE, "could not load " + string2 + " for " + this.fo.getPath(), classNotFoundException);
                    }
                }
                return false;
            }
            return clazz.isAssignableFrom(this.getType());
        }

        protected boolean creatorOf(Object object) {
            return this.ref.get() == object;
        }

        public synchronized Object getInstance() {
            Object object = this.ref.get();
            if (object == null && (object = FOItem.createInstanceFor(this.fo, Object.class)) != null) {
                this.ref = new WeakReference<Object>(object);
            }
            return object;
        }

        static <T> T createInstanceFor(FileObject fileObject, Class<T> clazz) {
            Object object = fileObject.getAttribute("instanceCreate");
            if (object == null) {
                try {
                    Class<? extends Object> clazz2 = FOItem.findTypeFor(fileObject);
                    if (clazz2 == null) {
                        return null;
                    }
                    object = SharedClassObject.class.isAssignableFrom(clazz2) ? SharedClassObject.findObject(clazz2.asSubclass(SharedClassObject.class), (boolean)true) : clazz2.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    Exceptions.printStackTrace((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Exceptions.printStackTrace((Throwable)illegalAccessException);
                }
            }
            return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
        }

        public Class<? extends Object> getType() {
            Class<? extends Object> clazz = FOItem.findTypeFor(this.fo);
            return clazz != null ? clazz : Void.class;
        }

        private static Class<? extends Object> findTypeFor(FileObject fileObject) {
            String string = FOItem.getClassName(fileObject);
            if (string == null) {
                return null;
            }
            try {
                return Class.forName(string, false, FOItem.loader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.INFO, classNotFoundException.getMessage(), classNotFoundException);
                return null;
            }
        }

        public String getId() {
            String string = this.fo.getPath();
            if (string.endsWith(".instance")) {
                string = string.substring(0, string.length() - ".instance".length());
            }
            return string;
        }

        public String getDisplayName() {
            String string = this.fo.getName();
            try {
                string = this.fo.getFileSystem().getStatus().annotateName(string, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, fileStateInvalidException.getMessage(), fileStateInvalidException);
            }
            return string;
        }

        private static String getClassName(FileObject fileObject) {
            int n;
            Object object = fileObject.getAttribute("instanceClass");
            if (object instanceof String) {
                return Utilities.translate((String)((String)object));
            }
            if (object != null) {
                LOG.warning("instanceClass was a " + object.getClass().getName());
            }
            if ((object = fileObject.getAttribute("instanceCreate")) != null) {
                return object.getClass().getName();
            }
            Object object2 = fileObject.getAttributes();
            while (object2.hasMoreElements()) {
                if (!object2.nextElement().equals("instanceCreate")) continue;
                return null;
            }
            object2 = fileObject.getName();
            int n2 = ((String)object2).indexOf(91) + 1;
            if (n2 != 0) {
                LOG.log(Level.WARNING, "Cannot understand {0}", fileObject);
            }
            if ((n = ((String)object2).indexOf(93)) < 0) {
                n = ((String)object2).length();
            }
            if (n2 < n) {
                object2 = ((String)object2).substring(n2, n);
            }
            object2 = ((String)object2).replace('-', '.');
            object2 = Utilities.translate((String)object2);
            return object2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            FOItem fOItem = (FOItem)((Object)object);
            return this.fo == fOItem.fo || this.fo != null && this.fo.equals(fOItem.fo);
        }

        public int hashCode() {
            int n = 3;
            n = 11 * n + (this.fo != null ? this.fo.hashCode() : 0);
            return n;
        }

        private static ClassLoader loader() {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = FOItem.class.getClassLoader();
            }
            return classLoader;
        }
    }

    private static final class OverFiles
    extends ProxyLookup
    implements FileChangeListener {
        private final String path;
        private final FileChangeListener weakL;
        private final AbstractLookup.Content content;
        private final AbstractLookup lkp;

        public OverFiles(String string) {
            this(string, new ArrayList<FOItem>(), new AbstractLookup.Content());
        }

        private OverFiles(String string, List<FOItem> list, AbstractLookup.Content content) {
            this(string, list, new AbstractLookup(content), content);
        }

        private OverFiles(String string, List<FOItem> list, AbstractLookup abstractLookup, AbstractLookup.Content content) {
            super(OverFiles.computeDelegates(string, list, (Lookup)abstractLookup));
            this.path = string;
            this.lkp = abstractLookup;
            this.content = content;
            this.content.setPairs(OverFiles.order(list));
            FileSystem fileSystem = null;
            try {
                fileSystem = FileUtil.getConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            this.weakL = FileUtil.weakFileChangeListener(this, fileSystem);
            fileSystem.addFileChangeListener(this.weakL);
        }

        private static List<FOItem> order(List<FOItem> list) {
            LinkedHashMap<FileObject, FOItem> linkedHashMap = new LinkedHashMap<FileObject, FOItem>();
            for (FOItem object2 : list) {
                linkedHashMap.put(object2.fo, object2);
            }
            List<FileObject> list2 = FileUtil.getOrder(linkedHashMap.keySet(), true);
            ArrayList<FOItem> arrayList = new ArrayList<FOItem>(list2.size());
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                arrayList.add((FOItem)((Object)linkedHashMap.get(fileObject)));
            }
            return arrayList;
        }

        private void refresh(FileEvent fileEvent) {
            if (!(fileEvent.getFile().getPath() + "/").startsWith(this.path)) {
                return;
            }
            ArrayList<FOItem> arrayList = new ArrayList<FOItem>();
            Lookup[] lookupArray = OverFiles.computeDelegates(this.path, arrayList, (Lookup)this.lkp);
            this.content.setPairs(OverFiles.order(arrayList));
            this.setLookups(lookupArray);
        }

        private static Lookup[] computeDelegates(String string, List<FOItem> list, Lookup lookup) {
            Object object;
            FileObject fileObject = FileUtil.getConfigFile(string);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(lookup);
            if (fileObject != null) {
                object = fileObject.getChildren();
                int n = ((FileObject[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    FileObject fileObject2 = object[i];
                    if (fileObject2.isFolder()) {
                        linkedList.add(new OverFiles(fileObject2.getPath()));
                        continue;
                    }
                    if (fileObject2.hasExt("shadow") && (object2 = fileObject2.getAttribute("originalFile")) instanceof String) {
                        fileObject2 = FileUtil.getConfigFile((String)object2);
                    }
                    if (!fileObject2.hasExt("instance") && fileObject2.getAttribute("instanceCreate") == null) continue;
                    list.add(new FOItem(fileObject2));
                }
            }
            if ((object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)) == null) {
                object = Thread.currentThread().getContextClassLoader();
            }
            if (object == null) {
                object = RecognizeInstanceFiles.class.getClassLoader();
            }
            linkedList.add(Lookups.metaInfServices((ClassLoader)object, (String)("META-INF/namedservices/" + string)));
            return linkedList.toArray(new Lookup[0]);
        }

        @Override
        public void fileFolderCreated(FileEvent fileEvent) {
            this.refresh(fileEvent);
        }

        @Override
        public void fileDataCreated(FileEvent fileEvent) {
            this.refresh(fileEvent);
        }

        @Override
        public void fileChanged(FileEvent fileEvent) {
            this.refresh(fileEvent);
        }

        @Override
        public void fileDeleted(FileEvent fileEvent) {
            this.refresh(fileEvent);
        }

        @Override
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.refresh(fileRenameEvent);
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.refresh(fileAttributeEvent);
        }
    }
}

