/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openide.text.DocumentLine;
import org.openide.text.Line;

final class LazyLines
implements List<Line> {
    private List<Line> delegate;
    private DocumentLine.Set set;

    public LazyLines(DocumentLine.Set set) {
        this.set = set;
    }

    private List<Line> createDelegate() {
        int n = this.set.listener.getOriginalLineCount();
        ArrayList<Line> arrayList = new ArrayList<Line>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.set.getOriginal(i));
        }
        return arrayList;
    }

    private synchronized List<Line> getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
        return this.delegate;
    }

    @Override
    public int indexOf(Object object) {
        int n;
        Line line;
        if (object instanceof DocumentLine && (line = this.set.findLine((DocumentLine)object)) != null && this.set.getOriginal(n = this.set.listener.getOld(line.getLineNumber())).equals(object)) {
            return n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getDelegate()).hashCode();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Line> listIterator() {
        return this.getDelegate().listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.getDelegate().toArray(TArray);
    }

    @Override
    public ListIterator<Line> listIterator(int n) {
        return this.getDelegate().listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.getDelegate()).equals(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    @Override
    public void add(int n, Line line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public Line set(int n, Line line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public Line get(int n) {
        return this.getDelegate().get(n);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getDelegate().containsAll(collection);
    }

    @Override
    public boolean add(Line line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Line> subList(int n, int n2) {
        return this.getDelegate().subList(n, n2);
    }

    @Override
    public Line remove(int n) {
        return this.getDelegate().remove(n);
    }

    @Override
    public Iterator<Line> iterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }
}

