/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9InstructionDecoder;

class V9WriteDecoder
extends InstructionDecoder
implements V9InstructionDecoder {
    V9WriteDecoder() {
    }

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        SPARCInstruction instr = null;
        int specialRegNum = V9WriteDecoder.getDestinationRegister(instruction);
        if (specialRegNum == 1 || specialRegNum == 4 || specialRegNum == 5 || specialRegNum > 6 && specialRegNum < 15) {
            instr = v9factory.newIllegalInstruction(instruction);
        } else {
            int rs1Num = V9WriteDecoder.getSourceRegister1(instruction);
            if (specialRegNum == 15) {
                instr = V9WriteDecoder.isIBitSet(instruction) && rs1Num == 0 ? v9factory.newV9SirInstruction() : v9factory.newIllegalInstruction(instruction);
            } else {
                int asrRegNum = -1;
                if (specialRegNum > 15) {
                    asrRegNum = specialRegNum;
                    specialRegNum = 7;
                }
                SPARCRegister rs1 = SPARCRegisters.getRegister(rs1Num);
                instr = v9factory.newV9WriteInstruction(specialRegNum, asrRegNum, rs1, V9WriteDecoder.getOperand2(instruction));
            }
        }
        return instr;
    }
}

