/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinVistaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private final int TXT_X_PAD = this.isUseStretchingTabs() ? 9 : 4;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 4;
    private static final int BUMP_X_PAD = 3;
    private static final int BUMP_Y_PAD_UPPER = 6;
    private static final int BUMP_Y_PAD_BOTTOM = 3;
    private static boolean colorsReady = false;
    private static Color unselFillBrightUpperC;
    private static Color unselFillDarkUpperC;
    private static Color unselFillBrightLowerC;
    private static Color unselFillDarkLowerC;
    private static Color selFillC;
    private static Color focusFillUpperC;
    private static Color focusFillBrightLowerC;
    private static Color focusFillDarkLowerC;
    private static Color mouseOverFillBrightUpperC;
    private static Color mouseOverFillDarkUpperC;
    private static Color mouseOverFillBrightLowerC;
    private static Color mouseOverFillDarkLowerC;
    private static Color txtC;
    private static Color borderC;
    private static Color selBorderC;
    private static Color borderInnerC;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinVistaViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 17);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinVistaViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        WinVistaViewTabDisplayerUI.initColors();
        jComponent.setOpaque(true);
        this.getLayoutModel().setPadding(new Dimension(2 * this.TXT_X_PAD, 0));
    }

    @Override
    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 17 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        if (0 == n) {
            ++n2;
        }
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                Dimension dimension = component.getPreferredSize();
                if (n4 < dimension.width + 4) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    n6 = n4 - (dimension.width + 4 + 2 * this.TXT_X_PAD);
                    component.setLocation(n2 + n6 + 2 * this.TXT_X_PAD, n3 + (n5 - dimension.height) / 2);
                }
            }
        } else {
            n6 = n4 - 2 * this.TXT_X_PAD;
        }
        if (this.isUseStretchingTabs()) {
            ColorUtil.paintVistaTabDragTexture(this.getDisplayer(), graphics, n2 + 3, n3 + 6, n5 - 9);
        }
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + this.TXT_X_PAD), (int)(n3 + fontMetrics.getAscent() + 3), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0 || n < 0;
        boolean bl2 = this.isTabHighlighted(n);
        graphics.translate(n2, n3);
        Color color = bl2 ? selBorderC : borderC;
        graphics.setColor(color);
        boolean bl3 = false;
        if (bl) {
            graphics.drawLine(0, 0, 0, n5 - 2);
        }
        graphics.drawLine(0, 0, n4 - 1, 0);
        if (n < this.getDataModel().size() - 1 && this.isTabHighlighted(n + 1)) {
            graphics.setColor(selBorderC);
        }
        graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 2);
        graphics.setColor(borderC);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.setColor(borderInnerC);
        if (bl) {
            graphics.drawLine(1, 1, 1, n5 - 2);
        } else {
            graphics.drawLine(0, 1, 0, n5 - 2);
        }
        graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 2);
        graphics.drawLine(1, 1, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n3 += 2;
        n5 -= 2;
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        boolean bl4 = this.isMouseOver(n);
        if (bl2 && !bl3) {
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, focusFillUpperC, focusFillBrightLowerC, focusFillDarkLowerC);
        } else if (bl && !bl3) {
            graphics.setColor(selFillC);
            graphics.fillRect(n2, n3, n4, n5);
        } else if (bl4 && !bl3) {
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, mouseOverFillBrightUpperC, mouseOverFillDarkUpperC, mouseOverFillBrightLowerC, mouseOverFillDarkLowerC);
        } else if (bl3) {
            Color color = new Color(255, 255, 128);
            Color color2 = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, color, color2);
        } else {
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, unselFillBrightUpperC, unselFillDarkUpperC, unselFillBrightLowerC, unselFillDarkLowerC);
        }
    }

    @Override
    protected Font getTxtFont() {
        Font font = super.getTxtFont();
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        return font;
    }

    private boolean isTabHighlighted(int n) {
        if (n < 0) {
            return false;
        }
        if (((OwnController)this.getController()).getMouseIndex() == n) {
            return true;
        }
        return this.isSelected(n) && this.isActive();
    }

    private boolean isMouseOver(int n) {
        if (n < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == n && !this.isSelected(n);
    }

    private static void initColors() {
        if (!colorsReady) {
            txtC = UIManager.getColor("TabbedPane.foreground");
            selFillC = UIManager.getColor("tab_sel_fill");
            focusFillUpperC = UIManager.getColor("tab_focus_fill_upper");
            focusFillBrightLowerC = UIManager.getColor("tab_focus_fill_bright_lower");
            focusFillDarkLowerC = UIManager.getColor("tab_focus_fill_dark_lower");
            unselFillBrightUpperC = UIManager.getColor("tab_unsel_fill_bright_upper");
            unselFillDarkUpperC = UIManager.getColor("tab_unsel_fill_dark_upper");
            unselFillBrightLowerC = UIManager.getColor("tab_unsel_fill_bright_lower");
            unselFillDarkLowerC = UIManager.getColor("tab_unsel_fill_dark_lower");
            mouseOverFillBrightUpperC = UIManager.getColor("tab_mouse_over_fill_bright_upper");
            mouseOverFillDarkUpperC = UIManager.getColor("tab_mouse_over_fill_dark_upper");
            mouseOverFillBrightLowerC = UIManager.getColor("tab_mouse_over_fill_bright_lower");
            mouseOverFillDarkLowerC = UIManager.getColor("tab_mouse_over_fill_dark_lower");
            borderC = UIManager.getColor("tab_border");
            selBorderC = UIManager.getColor("tab_sel_border");
            borderInnerC = UIManager.getColor("tab_border_inner");
            colorsReady = true;
        }
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/openide/awt/resources/vista_bigclose_enabled.png", "org/openide/awt/resources/vista_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/vista_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/vista_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinVistaViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    @Override
    public void postTabAction(TabActionEvent tabActionEvent) {
        super.postTabAction(tabActionEvent);
        if ("maximize".equals(tabActionEvent.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.updateHighlight(WinVistaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = WinVistaViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n) - 1;
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n) + 2;
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinVistaViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex) - 1;
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex) + 2;
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                WinVistaViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }
    }
}

