/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import com.sun.java.swing.Painter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class NimbusEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new NimbusLeftClipPainter();
    private static final TabPainter rightClip = new NimbusRightClipPainter();
    private static final TabPainter normal = new NimbusPainter();
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);
    static final boolean IS_JDK_17 = System.getProperty("java.version").startsWith("1.7");
    private static final Insets INSETS = new Insets(0, 2, 0, 10);

    public NimbusEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    @Override
    public Color getSelectedForeground() {
        return UIManager.getColor("textText");
    }

    @Override
    public Color getForeground() {
        return this.getSelectedForeground();
    }

    @Override
    public int getPixelsToAddToSelection() {
        return 4;
    }

    @Override
    protected int getCaptionYAdjustment() {
        return 0;
    }

    @Override
    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 14;
        return dimension;
    }

    private static void paintTabBackground(Graphics graphics, int n, Component component, int n2, int n3, int n4, int n5) {
        Shape shape = graphics.getClip();
        NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
        ++n4;
        boolean bl = nimbusEditorTabCellRenderer.isPreviousTabSelected();
        if (bl) {
            graphics.setClip(n2 + 1, n3, n4 - 1, n5);
        }
        Object object = null;
        object = nimbusEditorTabCellRenderer.isSelected() ? (nimbusEditorTabCellRenderer.isActive() ? UIManager.get("TabbedPane:TabbedPaneTab[MouseOver+Selected].backgroundPainter") : UIManager.get("TabbedPane:TabbedPaneTab[Selected].backgroundPainter")) : UIManager.get("TabbedPane:TabbedPaneTab[Enabled].backgroundPainter");
        if (IS_JDK_17) {
            if (object != null && object instanceof javax.swing.Painter) {
                javax.swing.Painter painter = (javax.swing.Painter)object;
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setBackground(UIManager.getColor("Panel.background"));
                graphics2D.clearRect(0, 0, n4, n5);
                painter.paint(graphics2D, null, n4, n5);
                graphics.drawImage(bufferedImage, n2, n3, null);
            }
        } else if (object != null && object instanceof Painter) {
            Painter painter = (Painter)object;
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(UIManager.getColor("Panel.background"));
            graphics2D.clearRect(0, 0, n4, n5);
            painter.paint(graphics2D, null, n4, n5);
            graphics.drawImage(bufferedImage, n2, n3, null);
        }
        if (bl) {
            graphics.setClip(shape);
        }
    }

    private static int getHeightDifference(NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer) {
        return 0;
    }

    private static class NimbusRightClipPainter
    implements TabPainter {
        private NimbusRightClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = component.getWidth() + 10;
            int n4 = component.getHeight() - 4;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            Rectangle rectangle = polygon.getBounds();
            int n = NimbusEditorTabCellRenderer.getHeightDifference(nimbusEditorTabCellRenderer);
            NimbusEditorTabCellRenderer.paintTabBackground(graphics, 0, component, rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class NimbusLeftClipPainter
    implements TabPainter {
        private NimbusLeftClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -3;
            int n2 = 0;
            int n3 = component.getWidth() + 3;
            int n4 = component.getHeight() - 4;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            Rectangle rectangle = polygon.getBounds();
            int n = NimbusEditorTabCellRenderer.getHeightDifference(nimbusEditorTabCellRenderer);
            NimbusEditorTabCellRenderer.paintTabBackground(graphics, 0, component, rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class NimbusPainter
    implements TabPainter {
        private NimbusPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = nimbusEditorTabCellRenderer.isLeftmost() ? 3 : 0;
            int n2 = 0;
            int n3 = nimbusEditorTabCellRenderer.isLeftmost() ? component.getWidth() - 3 : component.getWidth();
            int n4 = component.getHeight() - 4;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer = (NimbusEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            Rectangle rectangle = polygon.getBounds();
            int n = NimbusEditorTabCellRenderer.getHeightDifference(nimbusEditorTabCellRenderer);
            NimbusEditorTabCellRenderer.paintTabBackground(graphics, 0, component, rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
            if (!this.supportsCloseButton((JComponent)component)) {
                return;
            }
            this.paintCloseButton(graphics, (JComponent)component);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            boolean bl;
            boolean bl2 = ((NimbusEditorTabCellRenderer)jComponent).isClipRight();
            boolean bl3 = ((NimbusEditorTabCellRenderer)jComponent).isClipLeft();
            boolean bl4 = bl = !((NimbusEditorTabCellRenderer)jComponent).isShowCloseButton();
            if (bl3 || bl2 || bl) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
            } else {
                String string = this.findIconPath((NimbusEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                int n = icon.getIconWidth();
                int n2 = icon.getIconHeight();
                rectangle.x = rectangle2.x + rectangle2.width - n - 2;
                rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2);
                rectangle.width = n;
                rectangle.height = n2;
            }
        }

        private void paintCloseButton(Graphics graphics, JComponent jComponent) {
            if (((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                Rectangle rectangle2 = new Rectangle();
                this.getCloseButtonRectangle(jComponent, rectangle2, rectangle);
                String string = this.findIconPath((NimbusEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            }
        }

        private String findIconPath(NimbusEditorTabCellRenderer nimbusEditorTabCellRenderer) {
            if (nimbusEditorTabCellRenderer.inCloseButton() && nimbusEditorTabCellRenderer.isPressed()) {
                return "org/openide/awt/resources/gtk_close_pressed.png";
            }
            if (nimbusEditorTabCellRenderer.inCloseButton()) {
                return "org/openide/awt/resources/gtk_close_rollover.png";
            }
            return "org/openide/awt/resources/gtk_close_enabled.png";
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return ((AbstractTabCellRenderer)jComponent).isShowCloseButton();
        }
    }
}

