/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public final class X509Extended7DeployTrustManager
extends X509ExtendedTrustManager {
    private X509ExtendedTrustManager trustManager = null;
    private static CertStore rootStore = null;
    private static CertStore sslRootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserSSLRootStore = null;
    private static boolean isBrowserSSLRootStoreLoaded = false;
    private static boolean alwaysShow;
    private static boolean mismatchShow;
    private String[] supportedAlgs = new String[]{"HTTPS"};

    public static void reset() {
        rootStore = RootCertStore.getCertStore();
        sslRootStore = SSLRootCertStore.getCertStore();
        permanentStore = DeploySSLCertStore.getCertStore();
        sessionStore = new SessionCertStore("x509Extended7");
        deniedStore = new DeniedCertStore();
        alwaysShow = Config.getBooleanProperty("deployment.security.https.warning.show");
        mismatchShow = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning");
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserSSLRootStore = service.getBrowserSSLRootCertStore();
            isBrowserSSLRootStoreLoaded = false;
        }
    }

    public X509Extended7DeployTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509ExtendedTrustManager)trustManagerArray[0];
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSocket sSLSocket = (SSLSocket)socket;
        SSLSession sSLSession = sSLSocket.getHandshakeSession();
        String string2 = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
        String string3 = sSLSession.getPeerHost();
        if (string2 != null && !this.isSupportedAlgorithm(string2)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            int n3;
            int n4;
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            if (!alwaysShow) {
                try {
                    this.trustManager.checkClientTrusted(x509CertificateArray, string, sSLSocket);
                    return;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            if (sessionStore.contains(x509CertificateArray[0])) {
                return;
            }
            if (permanentStore.contains(x509CertificateArray[0])) {
                return;
            }
            if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n4 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n4]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n4]))) {
                bl = true;
            }
            for (n3 = 0; n3 < x509CertificateArray.length; ++n3) {
                try {
                    x509CertificateArray[n3].checkValidity();
                    continue;
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    n = -1;
                    continue;
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    n = 1;
                }
            }
            if (!Trace.isAutomationEnabled()) {
                int n5 = n3 = alwaysShow || bl || n != 0 || mismatchShow && !CertUtils.checkWildcardDomainList(string3, CertUtils.getServername(x509CertificateArray[0])) ? 1 : 0;
                if (n3 != 0) {
                    Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                    URL uRL = null;
                    try {
                        uRL = new URL("https", sSLSession.getPeerHost(), sSLSession.getPeerPort(), "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n2 = TrustDeciderDialog.showDialog(x509CertificateArray, uRL, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true, string3);
                } else {
                    n2 = 0;
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                n2 = 0;
            }
            if (n2 == 0) {
                sessionStore.add(x509CertificateArray[0]);
                sessionStore.save();
            } else if (n2 == 2) {
                CertStore certStore = DeploySSLCertStore.getUserCertStore();
                certStore.load(true);
                if (certStore.add(x509CertificateArray[0])) {
                    certStore.save();
                }
            } else {
                deniedStore.add(x509CertificateArray[0]);
                deniedStore.save();
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSocket sSLSocket = (SSLSocket)socket;
        SSLSession sSLSession = sSLSocket.getHandshakeSession();
        String string2 = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
        String string3 = sSLSession.getPeerHost();
        if (string2 != null && !this.isSupportedAlgorithm(string2)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            int n3;
            int n4;
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            if (!alwaysShow) {
                try {
                    this.trustManager.checkServerTrusted(x509CertificateArray, string, sSLSocket);
                    return;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            if (sessionStore.contains(x509CertificateArray[0])) {
                return;
            }
            if (permanentStore.contains(x509CertificateArray[0])) {
                return;
            }
            if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n4 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n4]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n4]))) {
                bl = true;
            }
            for (n3 = 0; n3 < x509CertificateArray.length; ++n3) {
                try {
                    x509CertificateArray[n3].checkValidity();
                    continue;
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    n = -1;
                    continue;
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    n = 1;
                }
            }
            if (!Trace.isAutomationEnabled()) {
                int n5 = n3 = alwaysShow || bl || n != 0 || mismatchShow && !CertUtils.checkWildcardDomainList(string3, CertUtils.getServername(x509CertificateArray[0])) ? 1 : 0;
                if (n3 != 0) {
                    Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                    URL uRL = null;
                    try {
                        uRL = new URL("https", sSLSession.getPeerHost(), sSLSession.getPeerPort(), "");
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                    n2 = TrustDeciderDialog.showDialog(x509CertificateArray, uRL, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true, string3);
                } else {
                    n2 = 0;
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                n2 = 0;
            }
            if (n2 == 0) {
                sessionStore.add(x509CertificateArray[0]);
                sessionStore.save();
            } else if (n2 == 2) {
                CertStore certStore = DeploySSLCertStore.getUserCertStore();
                certStore.load(true);
                if (certStore.add(x509CertificateArray[0])) {
                    certStore.save();
                }
            } else {
                deniedStore.add(x509CertificateArray[0]);
                deniedStore.save();
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private boolean isSupportedAlgorithm(String string) {
        for (int i = 0; i < this.supportedAlgs.length; ++i) {
            if (!string.equalsIgnoreCase(this.supportedAlgs[i])) continue;
            return true;
        }
        return false;
    }

    static {
        X509Extended7DeployTrustManager.reset();
    }
}

