/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder {
    protected Configuration configuration;
    protected static Set<String> containingPackagesSeen;
    protected static final boolean DEBUG = false;

    public AbstractBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public abstract String getName();

    public abstract void build() throws IOException;

    protected void build(XMLNode node, Content contentTree) {
        String component = node.name;
        try {
            this.invokeMethod("build" + component, new Class[]{XMLNode.class, Content.class}, new Object[]{node, contentTree});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            this.configuration.root.printError("Unknown element: " + component);
            throw new DocletAbortException();
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configuration.root.printError("Exception " + e.getClass().getName() + " thrown while processing element: " + component);
            throw new DocletAbortException();
        }
    }

    protected void buildChildren(XMLNode node, Content contentTree) {
        for (XMLNode child : node.children) {
            this.build(child, contentTree);
        }
    }

    protected void invokeMethod(String methodName, Class<?>[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }
}

