/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.panels.ClassSelectRootMethodsPanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public abstract class BaseSelectRootMethodsAction
extends NodeAction {
    private static final String NO_CLASS_FOUND_MSG = NbBundle.getMessage(BaseSelectRootMethodsAction.class, (String)"SelectRootMethodsAction_NoClassFoundMsg");

    public BaseSelectRootMethodsAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(BaseSelectRootMethodsAction.class, (String)"LBL_SelectRootMethodsAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        new NBSwingWorker(){
            String className = null;

            protected void doInBackground() {
                this.className = BaseSelectRootMethodsAction.this.getFileClassName(JavaProfilerSource.createFrom((FileObject)dataObject.getPrimaryFile()));
            }

            protected void done() {
                if (this.className != null) {
                    Lookup.Provider provider = ProjectUtilities.getProject((FileObject)dataObject.getPrimaryFile());
                    ProfilingSettings profilingSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)provider).getProfilingSettings();
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings2 : profilingSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)profilingSettings2.getProfilingType())) continue;
                        arrayList.add(profilingSettings2);
                    }
                    ProfilingSettings profilingSettings3 = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                    if (profilingSettings3 == null) {
                        return;
                    }
                    ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = ClassSelectRootMethodsPanel.getDefault().getRootMethods(dataObject.getPrimaryFile(), profilingSettings3.getInstrumentationRootMethods());
                    if (sourceCodeSelectionArray == null) {
                        return;
                    }
                    profilingSettings3.addRootMethods(sourceCodeSelectionArray);
                    if (arrayList.contains(profilingSettings3)) {
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettings, (ProfilingSettings)profilingSettings3, (Lookup.Provider)provider);
                    } else {
                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[((ProfilingSettings)profilingSettings).length + 1];
                        System.arraycopy(profilingSettings, 0, profilingSettingsArray, 0, ((ProfilingSettings)profilingSettings).length);
                        profilingSettingsArray[((ProfilingSettings)profilingSettings).length] = profilingSettings3;
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings3, (Lookup.Provider)provider);
                    }
                } else {
                    ProfilerDialogs.displayError((String)NO_CLASS_FOUND_MSG);
                }
            }
        }.execute();
    }

    protected abstract String getFileClassName(JavaProfilerSource var1);
}

