/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.Logging;
import com.sun.javafx.TempState;
import com.sun.javafx.Utils;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableObservableList;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.CSSFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.PropertyHelper;
import javafx.scene.Scene;

public abstract class Parent
extends Node {
    private static final int DIRTY_CHILDREN_THRESHOLD = 10;
    private static final boolean warnOnAutoMove = PropertyHelper.getBooleanProperty("javafx.sg.warn");
    private static final int REMOVED_CHILDREN_THRESHOLD = 20;
    private boolean removedChildrenExceedsThreshold = false;
    private final Set<Node> childSet = new HashSet<Node>();
    private int startIdx = 0;
    private int pgChildrenSize = 0;
    private boolean ignoreChildrenTrigger = false;
    private boolean childrenTriggerPermutation = false;
    private List<Node> removed;
    private final ObservableList<Node> children = new VetoableObservableList<Node>(){
        private boolean geomChanged;
        private boolean childrenModified;

        @Override
        protected void onProposedChange(List<Node> list, int[] nArray) {
            Node node;
            int n;
            if (Parent.this.ignoreChildrenTrigger) {
                return;
            }
            if (Parent.this.getScene() != null) {
                Toolkit.getToolkit().checkFxUserThread();
            }
            this.geomChanged = false;
            long l = Parent.this.children.size() + list.size();
            int n2 = 0;
            for (n = 0; n < nArray.length; n += 2) {
                n2 += nArray[n + 1] - nArray[n];
            }
            l -= (long)n2;
            if (Parent.this.childrenTriggerPermutation) {
                this.childrenModified = false;
                return;
            }
            this.childrenModified = true;
            if (l == (long)Parent.this.childSet.size()) {
                this.childrenModified = false;
                for (n = list.size() - 1; n >= 0; --n) {
                    node = list.get(n);
                    if (Parent.this.childSet.contains(node)) continue;
                    this.childrenModified = true;
                    break;
                }
            }
            for (n = 0; n < nArray.length; n += 2) {
                for (int i = nArray[n]; i < nArray[n + 1]; ++i) {
                    Parent.this.childSet.remove(Parent.this.children.get(i));
                }
            }
            try {
                Parent.this.childSet.addAll(list);
                if ((long)Parent.this.childSet.size() != l) {
                    throw new IllegalArgumentException(this.constructExceptionMessage("duplicate children added", null));
                }
                if (this.childrenModified) {
                    for (n = list.size() - 1; n >= 0; --n) {
                        node = list.get(n);
                        if (node == null) {
                            throw new NullPointerException(this.constructExceptionMessage("child node is null", null));
                        }
                        if (node.getClipParent() != null) {
                            throw new IllegalArgumentException(this.constructExceptionMessage("node already used as a clip", node));
                        }
                        if (!Parent.this.wouldCreateCycle(Parent.this, node)) continue;
                        throw new IllegalArgumentException(this.constructExceptionMessage("cycle detected", node));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                Parent.this.childSet.clear();
                Parent.this.childSet.addAll(Parent.this.children);
                throw runtimeException;
            }
            if (!this.childrenModified) {
                return;
            }
            if (Parent.this.removed == null) {
                Parent.this.removed = new ArrayList();
            }
            if (Parent.this.removed.size() + n2 > 20) {
                Parent.this.removedChildrenExceedsThreshold = true;
            }
            for (n = 0; n < nArray.length; n += 2) {
                for (int i = nArray[n]; i < nArray[n + 1]; ++i) {
                    Node node2 = (Node)Parent.this.children.get(i);
                    if (Parent.this.dirtyChildren != null) {
                        Parent.this.dirtyChildren.remove(node2);
                    }
                    if (node2 == null) continue;
                    if (!this.geomChanged && node2.isVisible()) {
                        this.geomChanged = Parent.this.childRemoved(node2);
                    }
                    if (node2.getParent() == Parent.this) {
                        node2.setParent(null);
                        node2.setScene(null);
                    }
                    if (Parent.this.removedChildrenExceedsThreshold) continue;
                    Parent.this.removed.add(node2);
                }
            }
        }

        @Override
        protected void onChanged(ListChangeListener.Change<Node> change) {
            if (this.childrenModified) {
                Object object;
                int n;
                int n2;
                boolean bl = false;
                while (change.next()) {
                    Node node;
                    int n3;
                    n2 = change.getFrom();
                    n = change.getTo();
                    for (int i = n2; i < n; ++i) {
                        Node node2 = (Node)Parent.this.children.get(i);
                        if (node2 == null || node2.getParent() == null || node2.getParent() == Parent.this) continue;
                        if (warnOnAutoMove) {
                            System.err.println("WARNING added to a new parent without first removing it from its current");
                            System.err.println("    parent. It will be automatically removed from its current parent.");
                            System.err.println("    node=" + node2 + " oldparent= " + node2.getParent() + " newparent=" + this);
                        }
                        node2.getParent().children.remove(node2);
                        if (node2.isManaged()) {
                            bl = true;
                        }
                        if (!warnOnAutoMove) continue;
                        Thread.dumpStack();
                    }
                    object = change.getRemoved();
                    int n4 = object.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        node = object.get(n3);
                        if (node == null || !node.isManaged()) continue;
                        bl = true;
                    }
                    for (n3 = n2; n3 < n; ++n3) {
                        node = (Node)Parent.this.children.get(n3);
                        if (node == null) continue;
                        if (node.isManaged()) {
                            bl = true;
                        }
                        node.setParent(Parent.this);
                        node.setScene(Parent.this.getScene());
                        if (Parent.this.dirtyChildren != null) {
                            Parent.this.dirtyChildren.add(node);
                        }
                        if (this.geomChanged || !node.isVisible()) continue;
                        this.geomChanged = Parent.this.childAdded(node);
                    }
                }
                if (Parent.this.dirtyChildren == null && Parent.this.children.size() > 10) {
                    Parent.this.dirtyChildren = new LinkedHashSet(2 * Parent.this.children.size());
                    if (this.geomChanged) {
                        n2 = Parent.this.children.size();
                        for (n = 0; n < n2; ++n) {
                            object = (Node)Parent.this.children.get(n);
                            if (!((Node)object).isVisible() || !((Node)object).boundsChanged) continue;
                            Parent.this.dirtyChildren.add(object);
                        }
                    }
                }
                if (this.geomChanged) {
                    Parent.this.impl_geomChanged();
                }
                if (bl) {
                    Parent.this.requestLayout();
                }
            }
            change.reset();
            change.next();
            if (Parent.this.startIdx > change.getFrom()) {
                Parent.this.startIdx = change.getFrom();
            }
            Parent.this.impl_markDirty(DirtyBits.PARENT_CHILDREN);
        }

        private String constructExceptionMessage(String string, Node node) {
            StringBuilder stringBuilder = new StringBuilder("Children: ");
            stringBuilder.append(string);
            stringBuilder.append(": parent = ").append(Parent.this);
            if (node != null) {
                stringBuilder.append(", node = ").append(node);
            }
            return stringBuilder.toString();
        }
    };
    private ObjectProperty<TraversalEngine> impl_traversalEngine;
    private ReadOnlyBooleanWrapper needsLayout;
    boolean performingLayout = false;
    private boolean sizeCacheClear = true;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            StyleManager.getInstance().parentStylesheetsChanged(Parent.this, change);
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                Parent.this.impl_cssResetInitialValues();
                break;
            }
            Parent.this.impl_reapplyCSS();
        }
    };
    private BaseBounds tmp = new RectBounds();
    private BaseBounds cachedBounds = new RectBounds();
    private boolean cachedBoundsInvalid = true;
    private LinkedHashSet<Node> dirtyChildren = null;
    private Node top;
    private Node left;
    private Node bottom;
    private Node right;
    private Node near;
    private Node far;

    @Override
    @Deprecated
    public void impl_updatePG() {
        Object object;
        super.impl_updatePG();
        if (Utils.assertionEnabled() && (object = this.getPGGroup().getChildren()).size() != this.pgChildrenSize) {
            System.err.println("*** pgnodes.size() [" + object.size() + "] != pgChildrenSize [" + this.pgChildrenSize + "]");
        }
        if (this.impl_isDirty(DirtyBits.PARENT_CHILDREN)) {
            int n;
            object = this.getPGGroup();
            object.clearFrom(this.startIdx);
            for (n = this.startIdx; n < this.children.size(); ++n) {
                Node node = (Node)this.children.get(n);
                if (node == null) continue;
                object.add(n, node.impl_getPGNode());
            }
            if (this.removedChildrenExceedsThreshold) {
                object.markDirty();
                this.removedChildrenExceedsThreshold = false;
            } else if (this.removed != null && !this.removed.isEmpty()) {
                for (n = 0; n < this.removed.size(); ++n) {
                    object.addToRemoved(this.removed.get(n).impl_getPGNode());
                }
                this.removed.clear();
            }
            this.startIdx = this.pgChildrenSize = this.children.size();
        }
        if (Utils.assertionEnabled()) {
            this.validatePG();
        }
    }

    void validatePG() {
        boolean bl = false;
        List<PGNode> list = this.getPGGroup().getChildren();
        if (list.size() != this.children.size()) {
            System.err.println("*** pgnodes.size validatePG() [" + list.size() + "] != children.size() [" + this.children.size() + "]");
            bl = true;
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = (Node)this.children.get(i);
                if (node.getParent() != this) {
                    System.err.println("*** this=" + this + " validatePG children[" + i + "].parent= " + node.getParent());
                    bl = true;
                }
                if (node.impl_getPGNode() == list.get(i)) continue;
                System.err.println("*** pgnodes[" + i + "] validatePG != children[" + i + "]");
                bl = true;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"validation of PGGroup children failed");
        }
    }

    void printSeq(String string, List<Node> list) {
        String string2 = string;
        for (Node node : list) {
            string2 = string2 + node + " ";
        }
        System.out.println(string2);
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return FXCollections.unmodifiableObservableList(this.children);
    }

    protected <E extends Node> List<E> getManagedChildren() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.getChildren()) {
            if (node == null || !node.isManaged()) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void impl_toFront(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(this.children.size() - 1) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void impl_toBack(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(0) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(0, node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    private void computeDirtyScene(Scene scene) {
        for (Node node : this.getChildren()) {
            if (node == null) continue;
            node.setScene(this.getScene());
        }
        if (this.isNeedsLayout() && scene != null) {
            scene.removeFromDirtyLayoutList(this);
        }
        if (this.getScene() != null && this.isNeedsLayout() && this.isLayoutRoot()) {
            this.getScene().addToDirtyLayoutList(this);
        }
    }

    @Override
    void sceneChanged(Scene scene) {
        this.computeDirtyScene(scene);
    }

    Node getFirstChild() {
        if (this.children.size() > 0) {
            return (Node)this.children.get(0);
        }
        return null;
    }

    Node getLastChild() {
        if (!this.children.isEmpty()) {
            return (Node)this.children.get(this.children.size() - 1);
        }
        return null;
    }

    Node getNextChild(Node node) {
        Node node2 = null;
        for (Node node3 : this.children) {
            if (node == node2) {
                return node3;
            }
            node2 = node3;
        }
        return null;
    }

    Node getPreviousChild(Node node) {
        Node node2 = null;
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Node node3 = (Node)this.children.get(i);
            if (node == node2) {
                return node3;
            }
            node2 = node3;
        }
        return null;
    }

    @Override
    void setDerivedDepthTest(boolean bl) {
        super.setDerivedDepthTest(bl);
        ObservableList<Node> observableList = this.getChildren();
        for (int i = 0; i < observableList.size(); ++i) {
            Node node = (Node)observableList.get(i);
            node.computeDerivedDepthTest();
        }
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.containsBounds(d, d2)) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                Node node = ((Node)this.children.get(i)).impl_pickNode(d, d2);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Node node = ((Node)this.children.get(i)).impl_pickNode(pickRay);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    boolean isConnected() {
        return super.isConnected() || this.isSceneRoot();
    }

    @Override
    public Node lookup(String string) {
        Node node = super.lookup(string);
        if (node == null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                node = ((Node)this.children.get(i)).lookup(string);
                if (node == null) continue;
                return node;
            }
        }
        return node;
    }

    @Override
    List<Node> lookupAll(Selector selector, List<Node> list) {
        list = super.lookupAll(selector, list);
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            list = ((Node)this.children.get(i)).lookupAll(selector, list);
        }
        return list;
    }

    @Deprecated
    public final void setImpl_traversalEngine(TraversalEngine traversalEngine) {
        this.impl_traversalEngineProperty().set(traversalEngine);
    }

    @Deprecated
    public final TraversalEngine getImpl_traversalEngine() {
        return this.impl_traversalEngine == null ? null : (TraversalEngine)this.impl_traversalEngine.get();
    }

    @Deprecated
    public final ObjectProperty<TraversalEngine> impl_traversalEngineProperty() {
        if (this.impl_traversalEngine == null) {
            this.impl_traversalEngine = new SimpleObjectProperty<TraversalEngine>(this, "impl_traversalEngine");
        }
        return this.impl_traversalEngine;
    }

    protected final void setNeedsLayout(boolean bl) {
        this.needsLayoutPropertyImpl().set(bl);
    }

    public final boolean isNeedsLayout() {
        return this.needsLayout == null ? true : this.needsLayout.get();
    }

    public final ReadOnlyBooleanProperty needsLayoutProperty() {
        return this.needsLayoutPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper needsLayoutPropertyImpl() {
        if (this.needsLayout == null) {
            this.needsLayout = new ReadOnlyBooleanWrapper(this, "needsLayout", true);
        }
        return this.needsLayout;
    }

    public void requestLayout() {
        if (!this.isNeedsLayout()) {
            this.prefWidthCache = -1.0;
            this.prefHeightCache = -1.0;
            this.minWidthCache = -1.0;
            this.minHeightCache = -1.0;
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            if (platformLogger.isLoggable(400)) {
                platformLogger.finer(this.toString());
            }
            this.setNeedsLayout(true);
            if (this.isLayoutRoot()) {
                if (this.getScene() != null) {
                    if (platformLogger.isLoggable(400)) {
                        platformLogger.finer(this.toString() + " layoutRoot added to scene dirty layout list");
                    }
                    this.getScene().addToDirtyLayoutList(this);
                }
            } else if (this.getParent() != null) {
                this.getParent().requestLayout();
            }
        } else {
            this.clearSizeCache();
        }
    }

    void clearSizeCache() {
        if (this.sizeCacheClear) {
            return;
        }
        this.sizeCacheClear = true;
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
        if (!this.isLayoutRoot() && this.getParent() != null) {
            this.getParent().clearSizeCache();
        }
    }

    @Override
    public double prefWidth(double d) {
        if (d == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.computePrefWidth(-1.0);
                this.sizeCacheClear = false;
            }
            return this.prefWidthCache;
        }
        return this.computePrefWidth(d);
    }

    @Override
    public double prefHeight(double d) {
        if (d == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.computePrefHeight(-1.0);
                this.sizeCacheClear = false;
            }
            return this.prefHeightCache;
        }
        return this.computePrefHeight(d);
    }

    @Override
    public double minWidth(double d) {
        if (d == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.computeMinWidth(-1.0);
                this.sizeCacheClear = false;
            }
            return this.minWidthCache;
        }
        return this.computeMinWidth(d);
    }

    @Override
    public double minHeight(double d) {
        if (d == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.computeMinHeight(-1.0);
                this.sizeCacheClear = false;
            }
            return this.minHeightCache;
        }
        return this.computeMinHeight(d);
    }

    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            double d4 = node.getLayoutBounds().getMinX() + node.getLayoutX();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4 + node.prefWidth(-1.0));
        }
        return d3 - d2;
    }

    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            double d4 = node.getLayoutBounds().getMinY() + node.getLayoutY();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4 + node.prefHeight(-1.0));
        }
        return d3 - d2;
    }

    protected double computeMinWidth(double d) {
        return this.prefWidth(d);
    }

    protected double computeMinHeight(double d) {
        return this.prefHeight(d);
    }

    @Override
    public double getBaselineOffset() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            return node.getLayoutBounds().getMinY() + node.getLayoutY() + node.getBaselineOffset();
        }
        return super.getBaselineOffset();
    }

    public final void layout() {
        if (this.isNeedsLayout()) {
            this.performingLayout = true;
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            if (platformLogger.isLoggable(500)) {
                platformLogger.fine(this + " size: " + this.getLayoutBounds().getWidth() + " x " + this.getLayoutBounds().getHeight());
            }
            this.layoutChildren();
            this.setNeedsLayout(false);
            ObservableList<Node> observableList = this.getChildren();
            int n = observableList.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)observableList.get(i);
                if (!(node instanceof Parent)) continue;
                ((Parent)node).layout();
            }
            this.performingLayout = false;
        }
    }

    protected void layoutChildren() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isResizable() || !node.isManaged()) continue;
            node.autosize();
        }
    }

    boolean isSceneRoot() {
        return this.getScene() != null ? this.getScene().getRoot() == this : false;
    }

    boolean isLayoutRoot() {
        return !this.isManaged() || this.isSceneRoot();
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    @Deprecated
    public List<String> impl_getAllParentStylesheets() {
        List<String> list = null;
        Parent parent = this.getParent();
        if (parent != null) {
            list = parent.impl_getAllParentStylesheets();
        }
        if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            if (list == null) {
                list = new ArrayList<String>(this.stylesheets.size());
            }
            int n = this.stylesheets.size();
            for (int i = 0; i < n; ++i) {
                list.add((String)this.stylesheets.get(i));
            }
        }
        return list;
    }

    @Override
    @Deprecated
    public void impl_processCSS(boolean bl) {
        boolean bl2 = bl || this.cssFlag == CSSFlags.REAPPLY;
        super.impl_processCSS(bl2);
        ObservableList<Node> observableList = this.getChildren();
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)observableList.get(i);
            if (node == null) continue;
            node.impl_processCSS(bl2);
        }
    }

    @Override
    @Deprecated
    public void impl_cssResetInitialValues() {
        super.impl_cssResetInitialValues();
        ObservableList<Node> observableList = this.getChildren();
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)observableList.get(i);
            if (node == null) continue;
            node.impl_cssResetInitialValues();
        }
    }

    protected Parent() {
        this.computeDirtyScene(null);
        this.requestLayout();
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGGroup();
    }

    PGGroup getPGGroup() {
        return (PGGroup)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.children.isEmpty()) {
            return baseBounds.makeEmpty();
        }
        if (baseTransform.isTranslateOrIdentity()) {
            if (this.cachedBoundsInvalid) {
                this.recomputeBounds();
            }
            baseBounds = !baseTransform.isIdentity() ? baseBounds.deriveWithNewBounds((float)((double)this.cachedBounds.getMinX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMinY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMinZ() + baseTransform.getMzt()), (float)((double)this.cachedBounds.getMaxX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMaxY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMaxZ() + baseTransform.getMzt())) : baseBounds.deriveWithNewBounds(this.cachedBounds);
            if (this.dirtyChildren != null) {
                this.dirtyChildren.clear();
            }
            return baseBounds;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        boolean bl = true;
        for (Node node : this.getChildren()) {
            if (!node.isVisible() || (baseBounds = node.getTransformedBounds(baseBounds, baseTransform)).isEmpty()) continue;
            if (bl) {
                d = baseBounds.getMinX();
                d2 = baseBounds.getMinY();
                d3 = baseBounds.getMinZ();
                d4 = baseBounds.getMaxX();
                d5 = baseBounds.getMaxY();
                d6 = baseBounds.getMaxZ();
                bl = false;
                continue;
            }
            d = Math.min((double)baseBounds.getMinX(), d);
            d2 = Math.min((double)baseBounds.getMinY(), d2);
            d3 = Math.min((double)baseBounds.getMinZ(), d3);
            d4 = Math.max((double)baseBounds.getMaxX(), d4);
            d5 = Math.max((double)baseBounds.getMaxY(), d5);
            d6 = Math.max((double)baseBounds.getMaxZ(), d6);
        }
        if (bl) {
            baseBounds.makeEmpty();
        } else {
            baseBounds = baseBounds.deriveWithNewBounds((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
        }
        if (this.dirtyChildren != null) {
            this.dirtyChildren.clear();
        }
        return baseBounds;
    }

    boolean childAdded(Node node) {
        if (this.top == null || this.bottom == null || this.left == null || this.right == null || this.near == null || this.far == null) {
            this.cachedBounds.makeEmpty();
            this.cachedBoundsInvalid = true;
            return true;
        }
        boolean bl = false;
        if (node.isVisible()) {
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (!this.tmp.isEmpty()) {
                node.boundsChanged = false;
                double d = this.tmp.getMinX();
                double d2 = this.tmp.getMinY();
                double d3 = this.tmp.getMinZ();
                double d4 = this.tmp.getMaxX();
                double d5 = this.tmp.getMaxY();
                double d6 = this.tmp.getMaxZ();
                double d7 = this.cachedBounds.getMinX();
                double d8 = this.cachedBounds.getMinY();
                double d9 = this.cachedBounds.getMinZ();
                double d10 = this.cachedBounds.getMaxX();
                double d11 = this.cachedBounds.getMaxY();
                double d12 = this.cachedBounds.getMaxZ();
                double d13 = Math.min(d, d7);
                double d14 = Math.min(d2, d8);
                double d15 = Math.min(d3, d9);
                double d16 = Math.max(d4, d10);
                double d17 = Math.max(d5, d11);
                double d18 = Math.max(d6, d12);
                if (d2 < d8) {
                    bl = true;
                    this.top = node;
                }
                if (d < d7) {
                    bl = true;
                    this.left = node;
                }
                if (d3 < d9) {
                    bl = true;
                    this.near = node;
                }
                if (d5 > d11) {
                    bl = true;
                    this.bottom = node;
                }
                if (d4 > d10) {
                    bl = true;
                    this.right = node;
                }
                if (d6 > d12) {
                    bl = true;
                    this.far = node;
                }
                this.cachedBounds = this.cachedBounds.deriveWithNewBounds((float)d13, (float)d14, (float)d15, (float)d16, (float)d17, (float)d18);
            }
        }
        return bl;
    }

    boolean childRemoved(Node node) {
        node.boundsChanged = false;
        if (node == this.top) {
            this.top = null;
        }
        if (node == this.left) {
            this.left = null;
        }
        if (node == this.bottom) {
            this.bottom = null;
        }
        if (node == this.right) {
            this.right = null;
        }
        if (node == this.near) {
            this.near = null;
        }
        if (node == this.far) {
            this.far = null;
        }
        if (this.top == null || this.bottom == null || this.left == null || this.right == null || this.near == null || this.far == null) {
            this.cachedBounds.makeEmpty();
            this.cachedBoundsInvalid = true;
            this.far = null;
            this.near = null;
            this.right = null;
            this.bottom = null;
            this.left = null;
            this.top = null;
            return true;
        }
        return false;
    }

    void recomputeBounds() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (this.children.isEmpty()) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.clear();
            }
            this.cachedBoundsInvalid = false;
            this.cachedBounds.makeEmpty();
            return;
        }
        if (this.children.size() == 1) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.clear();
            }
            this.cachedBoundsInvalid = false;
            Node node = (Node)this.children.get(0);
            if (node == null) {
                return;
            }
            if (node.isVisible()) {
                this.cachedBounds = node.getTransformedBounds(this.cachedBounds, BaseTransform.IDENTITY_TRANSFORM);
            } else {
                this.cachedBounds.makeEmpty();
            }
            node.boundsChanged = false;
            return;
        }
        if (this.cachedBounds != null && !this.cachedBounds.isEmpty() && this.top != null && this.left != null && this.bottom != null && this.right != null && this.near != null && this.far != null && this.top.isVisible() && this.left.isVisible() && this.bottom.isVisible() && this.right.isVisible() && this.near.isVisible() && this.far.isVisible()) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            boolean bl = false;
            double d11 = this.cachedBounds.getMinX();
            double d12 = this.cachedBounds.getMinY();
            double d13 = this.cachedBounds.getMinZ();
            double d14 = this.cachedBounds.getMaxX();
            double d15 = this.cachedBounds.getMaxY();
            double d16 = this.cachedBounds.getMaxZ();
            double d17 = d11;
            double d18 = d12;
            d5 = d13;
            d4 = d14;
            d3 = d15;
            d2 = d16;
            if (this.dirtyChildren != null) {
                for (Node node : this.dirtyChildren) {
                    if (node.isVisible() && node.boundsChanged) {
                        this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                        if (this.tmp.isEmpty()) {
                            if (node == this.top) {
                                bl = true;
                                break;
                            }
                            if (node == this.left) {
                                bl = true;
                                break;
                            }
                            if (node == this.bottom) {
                                bl = true;
                                break;
                            }
                            if (node == this.right) {
                                bl = true;
                                break;
                            }
                            if (node == this.near) {
                                bl = true;
                                break;
                            }
                            if (node == this.far) {
                                bl = true;
                                break;
                            }
                        } else {
                            d = this.tmp.getMinX();
                            d10 = this.tmp.getMinY();
                            d9 = this.tmp.getMinZ();
                            d8 = this.tmp.getMaxX();
                            d7 = this.tmp.getMaxY();
                            d6 = this.tmp.getMaxZ();
                            if (node == this.top && d10 > d12) {
                                bl = true;
                                break;
                            }
                            if (node == this.left && d > d11) {
                                bl = true;
                                break;
                            }
                            if (node == this.near && d9 > d13) {
                                bl = true;
                                break;
                            }
                            if (node == this.bottom && d7 < d15) {
                                bl = true;
                                break;
                            }
                            if (node == this.right && d8 < d14) {
                                bl = true;
                                break;
                            }
                            if (node == this.far && d6 < d16) {
                                bl = true;
                                break;
                            }
                            if (d10 < d18) {
                                d18 = d10;
                                this.top = node;
                            }
                            if (d < d17) {
                                d17 = d;
                                this.left = node;
                            }
                            if (d9 < d5) {
                                d5 = d9;
                                this.near = node;
                            }
                            if (d7 > d3) {
                                d3 = d7;
                                this.bottom = node;
                            }
                            if (d8 > d4) {
                                d4 = d8;
                                this.right = node;
                            }
                            if (d6 > d2) {
                                d2 = d6;
                                this.far = node;
                            }
                        }
                    }
                    node.boundsChanged = false;
                }
            } else {
                ObservableList<Node> observableList = this.getChildren();
                int n = observableList.size();
                for (int i = 0; i < n; ++i) {
                    Node node = (Node)observableList.get(i);
                    if (node == null) continue;
                    if (node.isVisible() && node.boundsChanged) {
                        this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                        if (this.tmp.isEmpty()) {
                            if (node == this.top) {
                                bl = true;
                                break;
                            }
                            if (node == this.left) {
                                bl = true;
                                break;
                            }
                            if (node == this.bottom) {
                                bl = true;
                                break;
                            }
                            if (node == this.right) {
                                bl = true;
                                break;
                            }
                            if (node == this.near) {
                                bl = true;
                                break;
                            }
                            if (node == this.far) {
                                bl = true;
                                break;
                            }
                        } else {
                            d10 = this.tmp.getMinX();
                            d9 = this.tmp.getMinY();
                            d8 = this.tmp.getMinZ();
                            d7 = this.tmp.getMaxX();
                            d6 = this.tmp.getMaxY();
                            double d19 = this.tmp.getMaxZ();
                            if (node == this.top && d9 > d12) {
                                bl = true;
                                break;
                            }
                            if (node == this.left && d10 > d11) {
                                bl = true;
                                break;
                            }
                            if (node == this.near && d8 > d13) {
                                bl = true;
                                break;
                            }
                            if (node == this.bottom && d6 < d15) {
                                bl = true;
                                break;
                            }
                            if (node == this.right && d7 < d14) {
                                bl = true;
                                break;
                            }
                            if (node == this.far && d19 < d16) {
                                bl = true;
                                break;
                            }
                            if (d9 < d18) {
                                d18 = d9;
                                this.top = node;
                            }
                            if (d10 < d17) {
                                d17 = d10;
                                this.left = node;
                            }
                            if (d8 < d5) {
                                d5 = d8;
                                this.near = node;
                            }
                            if (d6 > d3) {
                                d3 = d6;
                                this.bottom = node;
                            }
                            if (d7 > d4) {
                                d4 = d7;
                                this.right = node;
                            }
                            if (d19 > d2) {
                                d2 = d19;
                                this.far = node;
                            }
                        }
                    }
                    node.boundsChanged = false;
                }
            }
            if (this.dirtyChildren != null) {
                this.dirtyChildren.clear();
            }
            if (!bl) {
                this.cachedBoundsInvalid = false;
                this.cachedBounds = this.cachedBounds.deriveWithNewBounds((float)d17, (float)d18, (float)d5, (float)d4, (float)d3, (float)d2);
                return;
            }
        }
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        boolean bl = true;
        ObservableList<Node> observableList = this.getChildren();
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)observableList.get(i);
            if (node == null) continue;
            node.boundsChanged = false;
            if (!node.isVisible()) continue;
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            d5 = this.tmp.getMinX();
            d4 = this.tmp.getMinY();
            d3 = this.tmp.getMinZ();
            d2 = this.tmp.getMaxX();
            double d26 = this.tmp.getMaxY();
            d = this.tmp.getMaxZ();
            if (bl) {
                this.near = this.far = node;
                this.right = this.far;
                this.bottom = this.far;
                this.left = this.far;
                this.top = this.far;
                d20 = d5;
                d21 = d4;
                d22 = d3;
                d23 = d2;
                d24 = d26;
                d25 = d;
                bl = false;
                continue;
            }
            if (d4 < d21) {
                d21 = d4;
                this.top = node;
            }
            if (d5 < d20) {
                d20 = d5;
                this.left = node;
            }
            if (d3 < d22) {
                d22 = d3;
                this.near = node;
            }
            if (d26 > d24) {
                d24 = d26;
                this.bottom = node;
            }
            if (d2 > d23) {
                d23 = d2;
                this.right = node;
            }
            if (!(d > d25)) continue;
            d25 = d;
            this.far = node;
        }
        if (this.dirtyChildren != null) {
            this.dirtyChildren.clear();
        }
        this.cachedBoundsInvalid = false;
        if (bl) {
            this.far = null;
            this.near = null;
            this.right = null;
            this.bottom = null;
            this.left = null;
            this.top = null;
            this.cachedBounds.makeEmpty();
        } else {
            this.cachedBounds = this.cachedBounds.deriveWithNewBounds((float)d20, (float)d21, (float)d22, (float)d23, (float)d24, (float)d25);
        }
    }

    @Override
    @Deprecated
    protected void impl_geomChanged() {
        this.cachedBoundsInvalid = true;
        super.impl_geomChanged();
    }

    void childBoundsChanged(Node node) {
        if (!node.isVisible()) {
            return;
        }
        if (!node.boundsChanged) {
            node.boundsChanged = true;
            if (this.dirtyChildren != null) {
                this.dirtyChildren.add(node);
            }
        }
        this.impl_geomChanged();
    }

    void childVisibilityChanged(Node node) {
        this.cachedBounds.makeEmpty();
        this.impl_geomChanged();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        Point2D point2D = TempState.getInstance().point;
        for (Node node : this.getChildren()) {
            point2D.x = (float)d;
            point2D.y = (float)d2;
            try {
                node.parentToLocal(point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                continue;
            }
            if (!node.contains(point2D.x, point2D.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processContainerNode(this, mXNodeAlgorithmContext);
    }
}

