/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.OverviewController;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OverviewControllerUI
extends JTitledPanel {
    private static Icon ICON_INFO = Icons.getIcon((String)"GeneralIcons.Info");
    private static final String VIEW_TITLE = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewDescr");
    private static final String IN_PROGRESS_MSG = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_InProgressMsg");
    private AbstractButton presenter;
    private HTMLTextArea dataArea;
    private OverviewController overviewController;
    private Instance instanceToSelect;
    private boolean showSysprops = false;
    private boolean showThreads = false;

    public OverviewControllerUI(OverviewController overviewController) {
        super(VIEW_TITLE, ICON_INFO, true);
        this.overviewController = overviewController;
        this.initComponents();
        this.refreshSummary();
    }

    public void showInThreads(Instance instance) {
        if (!this.showThreads) {
            this.showThreads = true;
            this.instanceToSelect = instance;
            this.refreshSummary();
            return;
        }
        String string = String.valueOf(instance.getInstanceId());
        this.dataArea.scrollToReference(string);
        Document document = this.dataArea.getDocument();
        HTMLDocument hTMLDocument = (HTMLDocument)document;
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            AttributeSet attributeSet = iterator.getAttributes();
            String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
            if (string2 != null && string2.equals(string)) {
                this.dataArea.select(iterator.getStartOffset(), iterator.getEndOffset());
                this.dataArea.requestFocusInWindow();
            }
            iterator.next();
        }
    }

    private void refreshSummary() {
        if (!this.showSysprops && !this.showThreads) {
            this.dataArea.setText(IN_PROGRESS_MSG);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                String string = "<nobr>" + OverviewControllerUI.this.overviewController.computeSummary() + "</nobr>";
                String string2 = "<nobr>" + OverviewControllerUI.this.overviewController.computeEnvironment() + "</nobr>";
                String string3 = "<nobr>" + OverviewControllerUI.this.overviewController.computeSystemProperties(OverviewControllerUI.this.showSysprops) + "</nobr>";
                String string4 = "<nobr>" + OverviewControllerUI.this.overviewController.computeThreads(OverviewControllerUI.this.showThreads) + "</nobr>";
                final String string5 = string + "<br><br>" + string2 + "<br><br>" + string3 + "<br><br>" + string4;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewControllerUI.this.dataArea.setText(string5);
                        if (OverviewControllerUI.this.instanceToSelect != null) {
                            OverviewControllerUI.this.showInThreads(OverviewControllerUI.this.instanceToSelect);
                            OverviewControllerUI.this.instanceToSelect = null;
                        } else {
                            OverviewControllerUI.this.dataArea.setCaretPosition(0);
                        }
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                String string = uRL.toString();
                if (string.equals("file:/sysprops")) {
                    OverviewControllerUI.this.showSysprops = true;
                    OverviewControllerUI.this.refreshSummary();
                } else if (string.equals("file:/threads")) {
                    OverviewControllerUI.this.showThreads = true;
                    OverviewControllerUI.this.refreshSummary();
                } else {
                    OverviewControllerUI.this.overviewController.showURL(string);
                }
            }
        };
        this.dataArea.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        JScrollPane jScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getTitleBorderColor()));
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(true);
        jPanel.setBackground(this.dataArea.getBackground());
        jPanel.add((Component)jScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

