/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class FileBasedURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(FileBasedURLMapper.class.getName());

    public final URL getURL(FileObject fileObject, int n) {
        if (n == 2) {
            return null;
        }
        URL uRL = null;
        try {
            if (fileObject instanceof BaseFileObj) {
                BaseFileObj baseFileObj = (BaseFileObj)fileObject;
                uRL = FileBasedURLMapper.fileToURL(baseFileObj.getFileName().getFile(), fileObject);
            } else if (fileObject instanceof RootObj) {
                RootObj rootObj = (RootObj)fileObject;
                return this.getURL((FileObject)rootObj.getRealRoot(), n);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public final FileObject[] getFileObjects(URL uRL) {
        File file;
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        if (uRL.getPath().equals("//") || uRL.getPath().equals("////")) {
            return null;
        }
        FileObject fileObject = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.log(Level.INFO, "URL=" + uRL, uRISyntaxException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.INFO, "URL=" + uRL, illegalArgumentException);
            return null;
        }
        fileObject = FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.ToFileObject);
        return new FileObject[]{fileObject};
    }

    private static URL fileToURL(File file, FileObject fileObject) throws MalformedURLException {
        String string;
        URL uRL = FileBasedURLMapper.toURI(file, fileObject.isFolder()).toURL();
        if (fileObject.isFolder() && !(string = uRL.toExternalForm()).endsWith("/")) {
            uRL = new URL(string + "/");
        }
        return uRL;
    }

    private static URI toURI(File file, boolean bl) {
        try {
            File file2 = file.getAbsoluteFile();
            String string = FileBasedURLMapper.slashify(file2.getPath(), bl);
            if (string.startsWith("//")) {
                string = "//" + string;
            }
            return new URI("file", null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }
}

