/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.profiler.ApplicationProfilerViewProvider;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.openide.util.NbBundle;

final class ProfilerSupport {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSupport.class.getName());
    private static final boolean FORCE_PROFILING_SUPPORTED = Boolean.getBoolean("com.sun.tools.visualvm.profiler.SupportAllVMs");
    private static final String HOTSPOT_VM_NAME_PREFIX = "Java HotSpot";
    private static final String OPENJDK_VM_NAME_PREFIX = "OpenJDK ";
    private static final String SUN_VM_VENDOR_PREFIX = "Sun ";
    private static final String ORACLE_VM_VENDOR_PREFIX = "Oracle ";
    private static final String APPLE_VM_VENDOR_PREFIX = "Apple ";
    private static final String HP_VM_VENDOR_PREFIX = "\"Hewlett-Packard ";
    private static final String JAVA_RT_16_PREFIX = "1.6.0";
    private static final String JAVA_RT_17_PREFIX = "1.7.0";
    private static final String JAVA_RT_18_PREFIX = "1.8.0";
    private static ProfilerSupport instance;
    private boolean isInitialized;
    private Application profiledApplication;
    private ApplicationProfilerViewProvider profilerViewProvider;

    public static synchronized ProfilerSupport getInstance() {
        if (instance == null) {
            instance = new ProfilerSupport();
        }
        return instance;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    boolean supportsProfiling(Application application) {
        if (application.getHost() != Host.LOCALHOST) {
            return false;
        }
        if (Application.CURRENT_APPLICATION.equals((Object)application)) {
            return false;
        }
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isBasicInfoSupported() || !jvm.isAttachable()) {
            return false;
        }
        if (FORCE_PROFILING_SUPPORTED) {
            return true;
        }
        if (!(jvm.is16() || jvm.is17() || jvm.is18())) {
            return false;
        }
        String vmName = jvm.getVmName();
        String vmVendor = jvm.getVmVendor();
        return !(vmName == null || !vmName.startsWith(HOTSPOT_VM_NAME_PREFIX) && !vmName.startsWith(OPENJDK_VM_NAME_PREFIX) || vmVendor == null || !vmVendor.startsWith(ORACLE_VM_VENDOR_PREFIX) && !vmVendor.startsWith(SUN_VM_VENDOR_PREFIX) && !vmVendor.startsWith(APPLE_VM_VENDOR_PREFIX) && !vmVendor.startsWith(HP_VM_VENDOR_PREFIX));
    }

    boolean classSharingBreaksProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        Properties properties = jvm.getSystemProperties();
        if (properties == null) {
            return true;
        }
        String javaRTVersion = properties.getProperty("java.runtime.version");
        if (javaRTVersion == null) {
            return true;
        }
        int updateNumber = ProfilerSupport.getUpdateNumber(javaRTVersion);
        int buildNumber = ProfilerSupport.getBuildNumber(javaRTVersion);
        String vmName = jvm.getVmName();
        if (vmName.startsWith(HOTSPOT_VM_NAME_PREFIX) ? (javaRTVersion.startsWith(JAVA_RT_16_PREFIX) ? (updateNumber == 10 ? buildNumber >= 24 : updateNumber >= 6) : (javaRTVersion.startsWith(JAVA_RT_17_PREFIX) ? buildNumber >= 26 : javaRTVersion.startsWith(JAVA_RT_18_PREFIX))) : vmName.startsWith(OPENJDK_VM_NAME_PREFIX) && (javaRTVersion.startsWith(JAVA_RT_16_PREFIX) ? buildNumber >= 11 : (javaRTVersion.startsWith(JAVA_RT_17_PREFIX) ? buildNumber >= 26 : javaRTVersion.startsWith(JAVA_RT_18_PREFIX)))) {
            return false;
        }
        String vmInfo = jvm.getVmInfo();
        return vmInfo.contains("sharing");
    }

    private static int getUpdateNumber(String javaRTVersion) {
        int underscoreIndex = javaRTVersion.indexOf("_");
        if (underscoreIndex == -1) {
            return 0;
        }
        try {
            String updateNumberString = javaRTVersion.substring(underscoreIndex + "_".length(), javaRTVersion.indexOf("-"));
            return Integer.parseInt(updateNumberString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int getBuildNumber(String javaRTVersion) {
        try {
            String buildNumberString = javaRTVersion.substring(javaRTVersion.indexOf("-b") + "-b".length());
            return Integer.parseInt(buildNumberString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    void setProfiledApplication(Application profiledApplication) {
        this.profiledApplication = profiledApplication;
    }

    Application getProfiledApplication() {
        return this.profiledApplication;
    }

    void selectActiveProfilerView() {
        this.selectProfilerView(this.profiledApplication);
    }

    void selectProfilerView(Application application) {
        if (application == null) {
            return;
        }
        DataSourceView activeView = this.profilerViewProvider.view(application);
        if (activeView == null) {
            return;
        }
        DataSourceWindowManager.sharedInstance().selectView(activeView);
    }

    private static String getCurrentJDKExecutable() {
        return ProfilerSupport.getJDKExecutable(System.getProperty("java.home"));
    }

    private static String getJDKExecutable(String jdkHome) {
        if (jdkHome == null || jdkHome.trim().length() == 0) {
            return null;
        }
        String jreSuffix = File.separator + "jre";
        if (jdkHome.endsWith(jreSuffix)) {
            jdkHome = jdkHome.substring(0, jdkHome.length() - jreSuffix.length());
        }
        String jdkExe = jdkHome + File.separator + "bin" + File.separator + "java" + (Platform.isWindows() ? ".exe" : "");
        return jdkExe;
    }

    private boolean checkCurrentJDKCalibration() {
        return this.checkCalibration(ProfilerSupport.getCurrentJDKExecutable(), Platform.getJDKVersionString(), Platform.getSystemArchitecture(), null, null);
    }

    boolean checkJDKCalibration(Application application, Runnable preCalibrator, Runnable postCalibrator) {
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        Properties properties = jvm.getSystemProperties();
        if (properties == null) {
            return false;
        }
        return this.checkCalibration(ProfilerSupport.getJDKExecutable(properties.getProperty("java.home")), Platform.getJDKVersionString((String)properties.getProperty("java.version")), Platform.getSystemArchitecture(), preCalibrator, postCalibrator);
    }

    private boolean checkCalibration(String jvmExecutable, String jdkString, int architecture, Runnable preCalibrator, Runnable postCalibrator) {
        if (jvmExecutable == null) {
            return false;
        }
        ProfilerEngineSettings pes = NetBeansProfiler.getDefaultNB().getTargetAppRunner().getProfilerEngineSettings();
        int savedPort = pes.getPortNo();
        InstrumentationFilter savedInstrFilter = pes.getInstrumentationFilter();
        String savedJVMExeFile = pes.getTargetJVMExeFile();
        String savedJDKVersionString = pes.getTargetJDKVersionString();
        int savedArch = pes.getSystemArchitecture();
        String savedCP = pes.getMainClassPath();
        boolean result = true;
        pes.setTargetJVMExeFile(jvmExecutable);
        pes.setTargetJDKVersionString(jdkString);
        pes.setSystemArchitecture(architecture);
        pes.setPortNo(ProfilerIDESettings.getInstance().getCalibrationPortNo());
        pes.setInstrumentationFilter(new InstrumentationFilter());
        pes.setMainClassPath("");
        if (!NetBeansProfiler.getDefaultNB().getTargetAppRunner().readSavedCalibrationData()) {
            if (preCalibrator != null) {
                preCalibrator.run();
            }
            result = this.calibrateJVM();
            if (postCalibrator != null) {
                postCalibrator.run();
            }
        }
        pes.setPortNo(savedPort);
        pes.setInstrumentationFilter(savedInstrFilter);
        pes.setTargetJDKVersionString(savedJDKVersionString);
        pes.setSystemArchitecture(savedArch);
        pes.setTargetJVMExeFile(savedJVMExeFile);
        pes.setMainClassPath(savedCP);
        return result;
    }

    private boolean calibrateJVM() {
        ProfilerDialogs.displayInfo((String)NbBundle.getMessage(ProfilerSupport.class, (String)"MSG_Calibration"));
        boolean result = false;
        try {
            result = NetBeansProfiler.getDefaultNB().runConfiguredCalibration();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to calibrate profiler", e);
        }
        return result;
    }

    private ProfilerSupport() {
        boolean bl = this.isInitialized = Profiler.getDefault() != null && this.checkCurrentJDKCalibration();
        if (this.isInitialized) {
            this.profilerViewProvider = new ApplicationProfilerViewProvider();
            this.profilerViewProvider.initialize();
            ProfilerIDESettings.getInstance().setAutoOpenSnapshot(false);
            ProfilerIDESettings.getInstance().setAutoSaveSnapshot(true);
        }
    }
}

