/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LayoutParser
extends DefaultHandler {
    private Map<String, XMLNode> xmlElementsMap = new HashMap<String, XMLNode>();
    private XMLNode currentNode;
    private Configuration configuration;
    private static LayoutParser instance;
    private String currentRoot;
    private boolean isParsing;

    private LayoutParser(Configuration configuration) {
        this.configuration = configuration;
    }

    public static LayoutParser getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new LayoutParser(configuration);
        }
        return instance;
    }

    public XMLNode parseXML(String root) {
        if (this.xmlElementsMap.containsKey(root)) {
            return this.xmlElementsMap.get(root);
        }
        try {
            this.currentRoot = root;
            this.isParsing = false;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            InputStream in = this.configuration.getBuilderXML();
            saxParser.parse(in, (DefaultHandler)this);
            return this.xmlElementsMap.get(root);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DocletAbortException();
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (this.isParsing || qName.equals(this.currentRoot)) {
            this.isParsing = true;
            this.currentNode = new XMLNode(this.currentNode, qName);
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.currentNode.attrs.put(attrs.getLocalName(i), attrs.getValue(i));
            }
            if (qName.equals(this.currentRoot)) {
                this.xmlElementsMap.put(qName, this.currentNode);
            }
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (!this.isParsing) {
            return;
        }
        this.currentNode = this.currentNode.parent;
        this.isParsing = !qName.equals(this.currentRoot);
    }
}

